/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.ejianc.foundation.supplier.bean.SupplerIncidentEntity;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierGradeEntity;
import com.ejianc.foundation.supplier.bean.SupplierYearEntity;
import com.ejianc.foundation.supplier.service.ISupplerIncidentService;
import com.ejianc.foundation.supplier.service.ISupplierGradeService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.service.ISupplierYearService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplierCollect"})
public class SupplierCollect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplerIncidentService incidentService;
    @Autowired
    private ISupplierYearService yearService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISupplierGradeService gradeService;
    @Autowired
    private ISupplierService supplierService;

    @RequestMapping(value={"createYearEvaluation"})
    @ResponseBody
    public CommonResponse<String> createYearEvaluation() {
        List<SupplerIncidentEntity> list = this.incidentService.getYearIncident(LocalDate.now().getYear());
        if (ListUtil.isEmpty(list)) {
            this.logger.info("\u6ca1\u6709\u53ef\u6267\u884c\u6570\u636e\uff0c\u672a\u751f\u6210\u672c\u5e74\u5ea6\u8bc4\u4ef7\u5355\u636e\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01", (Object)"\u6ca1\u6709\u53ef\u6267\u884c\u6570\u636e\uff0c\u672a\u751f\u6210\u672c\u5e74\u5ea6\u8bc4\u4ef7\u5355\u636e\uff01");
        }
        ArrayList<SupplierYearEntity> yearEntities = new ArrayList<SupplierYearEntity>();
        for (SupplerIncidentEntity supplerIncidentEntity : list) {
            SupplierYearEntity entity = new SupplierYearEntity();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("ZY_SUPPLIER_NDPJ_CODE", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                entity.setCode("NDPJ-" + IdWorker.getId());
            }
            entity.setSupplyId(supplerIncidentEntity.getSupplyId());
            entity.setSupplyName(supplerIncidentEntity.getSupplyName());
            entity.setOrgId(supplerIncidentEntity.getOrgId());
            entity.setOrgName(supplerIncidentEntity.getOrgName());
            entity.setOrgCode(supplerIncidentEntity.getOrgCode());
            entity.setEndDate(new Date());
            entity.setYearDeduct(0);
            entity.setBillState(0);
            entity.setStatus(0);
            entity.setProcessBranch(supplerIncidentEntity.getBuckleBranch());
            entity.setThiYearNum(supplerIncidentEntity.getBillState());
            entity.setTotalNum(supplerIncidentEntity.getBillState());
            entity.setTotalAmount(supplerIncidentEntity.getContractAmount());
            yearEntities.add(entity);
        }
        this.yearService.saveOrUpdateBatch(yearEntities);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01", (Object)"\u751f\u6210\u672c\u5e74\u5ea6\u8bc4\u4ef7\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"createYearRating"})
    @ResponseBody
    public CommonResponse<String> createYearRating() {
        List<SupplierYearEntity> list = this.yearService.queryTotalAvg();
        if (ListUtil.isEmpty(list)) {
            this.logger.info("\u6ca1\u6709\u53ef\u6267\u884c\u6570\u636e\uff0c\u672a\u66f4\u6539\u4efb\u4f55\u4f9b\u5e94\u5546\u7b49\u7ea7\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01", (Object)"\u6ca1\u6709\u53ef\u6267\u884c\u6570\u636e\uff0c\u672a\u66f4\u6539\u4efb\u4f55\u4f9b\u5e94\u5546\u7b49\u7ea7\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("id", "asc");
        List gradeEntities = this.gradeService.queryList(queryParam, false);
        if (ListUtil.isEmpty((List)gradeEntities)) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u5931\u8d25\uff01", (Object)"\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
        }
        Map<String, BigDecimal> gradeMap = gradeEntities.stream().collect(Collectors.toMap(SupplierGradeEntity::getName, SupplierGradeEntity::getReachScore));
        Map<String, BigDecimal> gradeTakeMap = gradeEntities.stream().collect(Collectors.toMap(SupplierGradeEntity::getName, SupplierGradeEntity::getLevelRate));
        if (!gradeMap.containsKey("A")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230A\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u5931\u8d25\uff01", (Object)"\u6ca1\u6709\u627e\u5230A\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
        }
        if (!gradeMap.containsKey("B")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230B\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u5931\u8d25\uff01", (Object)"\u6ca1\u6709\u627e\u5230B\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
        }
        if (!gradeMap.containsKey("C")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230C\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u5931\u8d25\uff01", (Object)"\u6ca1\u6709\u627e\u5230C\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
        }
        if (!gradeMap.containsKey("D")) {
            this.logger.info("\u6267\u884c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230D\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
            return CommonResponse.success((String)"\u6267\u884c\u5931\u8d25\uff01", (Object)"\u6ca1\u6709\u627e\u5230D\u7ea7\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01");
        }
        for (SupplierYearEntity yearEntity : list) {
            BigDecimal yearDeduct = BigDecimal.valueOf(100 + yearEntity.getYearDeduct());
            SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(yearEntity.getSupplyId()));
            supplier.setYearScore(yearDeduct);
            if (yearDeduct.compareTo(gradeMap.get("A")) >= 0) {
                supplier.setGradeName("A");
            } else if (yearDeduct.compareTo(gradeMap.get("B")) >= 0) {
                supplier.setGradeName("B");
            } else if (yearDeduct.compareTo(gradeMap.get("C")) >= 0) {
                supplier.setGradeName("C");
            } else {
                supplier.setGradeName("D");
            }
            this.supplierService.saveOrUpdate((Object)supplier, false);
        }
        queryParam = new QueryParam();
        queryParam.getParams().put("billState", Parameter.getInInstance((Object)new String[]{"1", "3"}));
        List supplierTotal = this.supplierService.queryList(queryParam, false);
        int total = supplierTotal.size();
        queryParam.getParams().put("gradeName", Parameter.getEqInstance((Object)"A"));
        queryParam.getOrderMap().put("yearScore", "asc");
        List supplierA = this.supplierService.queryList(queryParam, false);
        int a = supplierA.size();
        int mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("A")).divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).intValue();
        if (a > mostNum) {
            int over = a - mostNum;
            for (int i = 0; i < over; ++i) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierA.get(i));
                this.logger.info("\u4f9b\u5e94\u5546\u603b\u6570\uff1a{}\uff0c\u6839\u636eA\u7ea7\u4f9b\u5e94\u5546\u89c4\u5219\uff0c\u5176\u8fbe\u6807\u5206\u6570\u4e3a\uff1a{}\uff0c\u5176\u6570\u91cf\u5360\u6bd4\u4e3a\uff1a{} \uff0c\u6700\u591a{}\u4e2a\uff0c\u4f9b\u5e94\u5546\u3010{}\u3011\u7b49\u7ea7\u88ab\u8c03\u6574\u5230\u4e3aB", new Object[]{total, gradeMap.get("A"), gradeTakeMap.get("A"), mostNum, supplier.getName()});
                supplier.setGradeName("B");
                this.supplierService.saveOrUpdate((Object)supplier, false);
            }
        }
        queryParam.getParams().put("gradeName", Parameter.getEqInstance((Object)"B"));
        List supplierB = this.supplierService.queryList(queryParam, false);
        int b = supplierB.size();
        mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("B")).divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).intValue();
        if (b > mostNum) {
            int over = b - mostNum;
            for (int i = 0; i < over; ++i) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierB.get(i));
                this.logger.info("\u4f9b\u5e94\u5546\u603b\u6570\uff1a{}\uff0c\u6839\u636eB\u7ea7\u4f9b\u5e94\u5546\u89c4\u5219\uff0c\u5176\u8fbe\u6807\u5206\u6570\u4e3a\uff1a{}\uff0c\u5176\u6570\u91cf\u5360\u6bd4\u4e3a\uff1a{} \uff0c\u6700\u591a{}\u4e2a\uff0c\u4f9b\u5e94\u5546\u3010{}\u3011\u7b49\u7ea7\u88ab\u8c03\u6574\u5230\u4e3aC", new Object[]{total, gradeMap.get("B"), gradeTakeMap.get("B"), mostNum, supplier.getName()});
                supplier.setGradeName("C");
                this.supplierService.saveOrUpdate((Object)supplier, false);
            }
        }
        queryParam.getParams().put("gradeName", Parameter.getEqInstance((Object)"C"));
        List supplierC = this.supplierService.queryList(queryParam, false);
        int c = supplierC.size();
        mostNum = BigDecimal.valueOf(total).multiply(gradeTakeMap.get("C")).divide(BigDecimal.valueOf(100L), 0, RoundingMode.DOWN).intValue();
        if (c > mostNum) {
            int over = c - mostNum;
            for (int i = 0; i < over; ++i) {
                SupplierEntity supplier = (SupplierEntity)((Object)supplierC.get(i));
                this.logger.info("\u4f9b\u5e94\u5546\u603b\u6570\uff1a{}\uff0c\u6839\u636eC\u7ea7\u4f9b\u5e94\u5546\u89c4\u5219\uff0c\u5176\u8fbe\u6807\u5206\u6570\u4e3a\uff1a{}\uff0c\u5176\u6570\u91cf\u5360\u6bd4\u4e3a\uff1a{} \uff0c\u6700\u591a{}\u4e2a\uff0c\u4f9b\u5e94\u5546\u3010{}\u3011\u7b49\u7ea7\u88ab\u8c03\u6574\u5230\u4e3aD", new Object[]{total, gradeMap.get("C"), gradeTakeMap.get("C"), mostNum, supplier.getName()});
                supplier.setGradeName("D");
                this.supplierService.saveOrUpdate((Object)supplier, false);
            }
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f\uff01", (Object)"\u672c\u5e74\u5ea6\u4f9b\u5e94\u5546\u8bc4\u7ea7\u6570\u636e\u5df2\u751f\u6210\uff01");
    }
}

