package com.ejianc.foundation.support.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;

@RestController
@RequestMapping("/billCodeApi/")
public class BillCodeApiController  {

    @Autowired
    private IBillCodeGenerator generator;

    /**
     * 根据编码规则生成单据号（可批量）
     *
     * @param id 编码规则主键ID
     * @return
     */
    @GetMapping("getByCode")
    public CommonResponse<String> getCodeBatchByRuleCode(@RequestParam(value = "code") String code) throws BillCodeException {
    	Long tenantId = InvocationInfoProxy.getTenantid();
        String billCode = generator.generateBillCodeById(code, tenantId);
        return CommonResponse.success("获取编码成功！", billCode);
    }

}
