package com.ejianc.foundation.dataModel.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import javax.servlet.http.HttpServletRequest;

import com.google.gson.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.dataModel.bean.DataModelBillEntity;
import com.ejianc.foundation.dataModel.bean.DataModelCusEntity;
import com.ejianc.foundation.dataModel.bean.DataModelCustomerBillEntity;
import com.ejianc.foundation.dataModel.bean.DataModelDataEntity;
import com.ejianc.foundation.dataModel.bean.DataModelDataSetEntity;
import com.ejianc.foundation.dataModel.bean.DataModelEntity;
import com.ejianc.foundation.dataModel.bean.DataModelRoleEntity;
import com.ejianc.foundation.dataModel.mapper.DataModelMapper;
import com.ejianc.foundation.dataModel.service.IDataModelBillService;
import com.ejianc.foundation.dataModel.service.IDataModelColumnService;
import com.ejianc.foundation.dataModel.service.IDataModelCusService;
import com.ejianc.foundation.dataModel.service.IDataModelCustomerBillService;
import com.ejianc.foundation.dataModel.service.IDataModelDataService;
import com.ejianc.foundation.dataModel.service.IDataModelDataSetService;
import com.ejianc.foundation.dataModel.service.IDataModelRoleService;
import com.ejianc.foundation.dataModel.service.IDataModelService;
import com.ejianc.foundation.dataModel.service.*;
import com.ejianc.foundation.dataModel.vo.DataModelColConditionVO;
import com.ejianc.foundation.dataModel.vo.DataModelColumnVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.util.CalculatorUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.util.JdkBase64Util;

/**
 * 数据模型主表
 * 
 * @author generator
 * 
 */
@Service("dataModelService")
public class DataModelServiceImpl extends BaseServiceImpl<DataModelMapper, DataModelEntity> implements IDataModelService{

    private static final Logger logger = LoggerFactory.getLogger(DataModelServiceImpl.class);

    @Autowired
    private DataModelMapper dataModelMapper;
    @Autowired
    private IRoleApi iRoleApi;
    @Autowired
    private IDataModelRoleService dataModelRoleService;
    @Autowired
    private IDataModelBillService iDataModelBillService;
    @Autowired
    private IDataModelCustomerBillService customerBillService;
    @Autowired
    private IDataModelDataService dataModelDataService;
    @Autowired
    private IDataModelCusService iDataModelCusService;
    @Autowired
    private IDataModelDataSetService iDataModelDataSetService;
    @Autowired
    private IDataModelColumnService iDataModelColumnService;
    @Autowired
    private EnvironmentTools environmentTools;

    public static void main(String[] args) {
        String x = "{\"totalAEEOnPassageTaxMny\":940000.00000000,\"totalMaCPOnPassageChangeTaxMny\":0.00,\"totalSignedOutConTaxMnyCona\":145664157.63,\"totalLaborsubOnPassageTaxMny\":-24391654.73000000,\"totalProotherTOnPassageChangeTaxMny\":0.00,\"signedPayRate\":81.09,\"totalPrormatOnPassageTaxMny\":0.00,\"totalOutContractOnPassageChangeTaxMny\":0.00,\"canSignPayMny\":34022379.43,\"incomeCostAdjustTaxMny\":-36316777.92000000,\"totalLPOnPassageTaxMny\":3775502.25000000,\"totalMaCPOnPassageTaxMny\":1887075.55000000,\"signedLaborSubContractTaxMny\":49136648.77000000,\"signedPayContractTaxMny\":145664157.63000000,\"targetCostSignedTaxMoney\":151055207.33000000,\"totalProsubOnPassageTaxMny\":51986.55000000,\"totalLPOnPassageChangeTaxMny\":0.00,\"totalSignedOutConTaxMny\":151055207.33,\"totalAEEOnPassageChangeTaxMny\":0.00,\"totalPrormatTOnPassageChangeTaxMny\":0.00,\"totalIncomeContractTaxMny\":186289114.86,\"signedProSubContractTaxMny\":6568013.70,\"totalProotherOnPassageTaxMny\":0.00}";
        JSONObject data = JSON.parseObject(x);
        CalculatorUtils.getResult("LWFBHT", data);
    }

    @Override
    public CommonResponse<List<JSONObject>> saveOrQueryDataModelDataByBill(JSONObject jsonObject, HttpServletRequest request) {

        String baseHost = environmentTools.getBaseHost(InvocationInfoProxy.getTenantid());

        /** 所有数据模型的数据集 */
        List<JSONObject> allList = new ArrayList<>();
        Map allMap = new HashMap();// 模型id---模型数据
        /** 待返回数据集 */
        List<JSONObject> res = new ArrayList<>();
        Map resMap = new HashMap();// 模型id---模型id
        /** 待保存数据集 */
        List<JSONObject> saveList = new ArrayList<>();

        //1、获取单据类型
        String billTypeCode = jsonObject.getString("billTypeCode");
        JSONObject bill = jsonObject.getJSONObject("bill");
        /** queryType 1、查询 2、保存查询 */
        Integer queryType = jsonObject.getInteger("type");
        if(bill.getString("id")!=null){
            QueryWrapper<DataModelDataEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_id", bill.getString("id"));
            wrapper.last("LIMIT 1");
            DataModelDataEntity dataEntity = dataModelDataService.getOne(wrapper);
            if(dataEntity!=null){
                JSONArray array = JSONArray.parseArray(dataEntity.getData());
                if(array!=null){
                    for (Object o : array) {
                        JSONObject object = (JSONObject)o;
                        if(allMap.get(object.getString("dataModelId"))==null){
                            allList.add(object);
                            allMap.put(object.getString("dataModelId"),object);// 模型id---模型数据
                        }
                    }
                }
            }
        }

        //2、根据单据类型查询数据模型
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeCode",new Parameter(QueryParam.EQ, billTypeCode));
        List<DataModelCustomerBillEntity> customerBillEntities = customerBillService.queryList(param);
        if(ListUtil.isEmpty(customerBillEntities)){
            return CommonResponse.success("该单据类型未挂载任何数据模型！");
        }
        //3、查询出主数据模型 角色关系
        CommonResponse<List<Long>> roleIds = iRoleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if(!roleIds.isSuccess() || (roleIds.isSuccess() && ListUtil.isEmpty(roleIds.getData()))){
            logger.error("查询当前用户挂载的角色:{}",JSONObject.toJSONString(roleIds));
            return CommonResponse.success("未查询到查询当前用户挂载的角色！");
        }

        /** 查询 用户是否拥有这些数据模型的查看权限 */
        QueryParam roleParam = new QueryParam();
        roleParam.getParams().put("roleId",new Parameter(QueryParam.IN,roleIds.getData()));
        List<DataModelRoleEntity> dataModelRoleEntities = dataModelRoleService.queryList(roleParam);
        if(ListUtil.isEmpty(dataModelRoleEntities)){
            logger.error("当前用户挂载的角色里面 没有挂载任何数据模型:{}",JSONObject.toJSONString(roleIds));
            return CommonResponse.success("当前用户挂载的角色里面，没有挂载任何数据模型！");
        }

        //3、查询出主数据模型
        ConcurrentHashMap<Long, MdProjectVO> projectCache = new ConcurrentHashMap<>();

        for (DataModelCustomerBillEntity customerBillEntity : customerBillEntities) {
            DataModelBillEntity billEntity = iDataModelBillService.getById(customerBillEntity.getModelBillId());
            logger.info("挂载的的单据类型信息：{}",JSONObject.toJSONString(billEntity));
            /**
             * billEntity.getQueryType
             * 查询方式：1实时，2快照
             *
             * 实时，一定要查询，不管queryType是1还是2
             * 快照，queryType=1的时候指的是查询
             *     又分为单据有没有生成
             *     有单据，不查询，无单据查询
             *     queryType=2时候指的是保存时候
             *     此时要查询
             *
             * */
            if(billEntity!=null && (billEntity.getQueryType() == 1 || queryType==2 || StringUtils.isEmpty(bill.getString("id"))) ){
                DataModelEntity modelEntity = selectById(billEntity.getDataModelId());
                if(modelEntity!=null){
                    logger.info("挂载的的数据模型信息：{}，挂载的的单据类型信息：{}",JSONObject.toJSONString(modelEntity),JSONObject.toJSONString(billEntity));
                    /**  当前数据模型数据合集 */
                    List<JSONObject> dataSetData = new ArrayList<>();
                    /** 替换客户自定义内容 */
                    DataModelCusEntity cusEntity = iDataModelCusService.queryCusModelByModelId(modelEntity.getId());
                    if(cusEntity!=null){
                        modelEntity.setName(cusEntity.getName());
                    }
                    String setIds[] = modelEntity.getDataSetIds().split(",");
                    ExecutorService threadPool = null;
                    try {
                        if(modelEntity.getModelType() == 1 || modelEntity.getModelType() == 3 || modelEntity.getModelType() == 4 || modelEntity.getModelType() == 5){
                            /** 数据模型类型：1、指标，2、报表，3、饼状图，4、柱状图，5、折线图 ,指标型、饼状图、柱状图、折线图不处理子数据集，选取第一个数据集作为主数据集，其余为子数据集*/
                            threadPool = Executors.newFixedThreadPool(1);
                            DataModelDataSetEntity setEntity = iDataModelDataSetService.selectById(setIds[0]);
                            Callable<List<JSONObject>> mainDataModelCall =new MainDatasetCallable(billTypeCode,setIds,RequestContextHolder.getRequestAttributes(),modelEntity,setEntity,
                                    bill,billEntity.getBillParam(),billEntity.getSubTabParam(),request.getHeader("authority"),InvocationInfoProxy.getTenantid(),projectCache,baseHost);
                            Future<List<JSONObject>> childFuture = threadPool.submit(mainDataModelCall);
                            List<JSONObject> list = childFuture.get(30, TimeUnit.SECONDS);
                            if(ListUtil.isNotEmpty(list)){
                                dataSetData.addAll(list);
                            }
                        }else {
                            threadPool = Executors.newFixedThreadPool(setIds.length);
                            List<Future> futureList = new ArrayList<>();

                            for (int i = 0; i < setIds.length; i++) {
                                DataModelDataSetEntity setEntity = iDataModelDataSetService.selectById(setIds[i]);

                                Callable<List<JSONObject>> mainDataModelCall =new MainDatasetCallable(billTypeCode,setIds,RequestContextHolder.getRequestAttributes(),modelEntity,setEntity,
                                        bill,billEntity.getBillParam(),billEntity.getSubTabParam(),request.getHeader("authority"),InvocationInfoProxy.getTenantid(),projectCache,baseHost);
                                Future<List<JSONObject>> childFuture = threadPool.submit(mainDataModelCall);
                                futureList.add(childFuture);
                            }
                            /** 查询出所有数据模型相应数据 */
                            for (Future<List<JSONObject>> future : futureList) {
                                /** 每个主数据集数据 */
                                List<JSONObject> list = future.get(30, TimeUnit.SECONDS);
                                if(ListUtil.isNotEmpty(list)){
                                    dataSetData.addAll(list);
                                }
                            }
                        }
                        JSONObject dataModel = new JSONObject();

                        /** 获取字段放入数据 */
                        List<DataModelColumnVO>  columnVOS = iDataModelColumnService.queryListByTenant(modelEntity.getId());
                        dataModel.put("columns",columnVOS);


                        if(dataSetData.size() > 0){
                            for (JSONObject data : dataSetData) {
                                /** 自定义计算字段处理 */
                                for (DataModelColumnVO columnVO : columnVOS) {
                                    if(StringUtils.isNotEmpty(columnVO.getFormula())){
                                        logger.info("计算公式：{},数据：{}",columnVO.getFormula(),data);
                                        data.put(columnVO.getProperty(), CalculatorUtils.getResult(columnVO.getFormula(), data));

//                                        {"totalAEEOnPassageTaxMny":940000.00000000,"totalMaCPOnPassageChangeTaxMny":0.00,"totalSignedOutConTaxMnyCona":145664157.63,"totalLaborsubOnPassageTaxMny":-24391654.73000000,"totalProotherTOnPassageChangeTaxMny":0.00,"signedPayRate":81.09,"totalPrormatOnPassageTaxMny":0.00,"totalOutContractOnPassageChangeTaxMny":0.00,"canSignPayMny":34022379.43,"incomeCostAdjustTaxMny":-36316777.92000000,"totalLPOnPassageTaxMny":3775502.25000000,"totalMaCPOnPassageTaxMny":1887075.55000000,"signedLaborSubContractTaxMny":49136648.77000000,"signedPayContractTaxMny":145664157.63000000,"targetCostSignedTaxMoney":151055207.33000000,"totalProsubOnPassageTaxMny":51986.55000000,"totalLPOnPassageChangeTaxMny":0.00,"totalSignedOutConTaxMny":151055207.33,"totalAEEOnPassageChangeTaxMny":0.00,"totalPrormatTOnPassageChangeTaxMny":0.00,"totalIncomeContractTaxMny":186289114.86,"signedProSubContractTaxMny":6568013.70,"totalProotherOnPassageTaxMny":0.00}
                                    }
                                }
                                /** 显示样式处理 */
                                data.put("colStyles", new JSONObject());
                                for (DataModelColumnVO columnVO : columnVOS) {
                                    if(ListUtil.isNotEmpty(columnVO.getConditionEntities())){
                                        for (DataModelColConditionVO conditionEntity : columnVO.getConditionEntities()) {
                                            if(StringUtils.isNotEmpty(conditionEntity.getCond())){
                                                boolean r = CalculatorUtils.getFiled(conditionEntity.getCond(),data,columnVOS,logger);
                                                if(r){
                                                    JSONObject colStyles = data.getJSONObject("colStyles");
                                                    JSONObject style = new JSONObject();
                                                    style.put("color",conditionEntity.getColor());
                                                    style.put("background",conditionEntity.getBgColor());
                                                    style.put("bold",conditionEntity.getBold());
                                                    colStyles.put(columnVO.getProperty(),style);
                                                    data.put("colStyles", colStyles);
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        dataModel.put("name",modelEntity.getName());
                        dataModel.put("type",modelEntity.getModelType());
                        dataModel.put("dataModelId",modelEntity.getId());
                        dataModel.put("billId",bill.getLong("id"));
                        dataModel.put("data",dataSetData);
                        dataModel.put("sequence",modelEntity.getSequence());

                        allList.add(dataModel);
                        allMap.put(dataModel.getString("dataModelId"),dataModel);

                    } catch (InterruptedException | ExecutionException | TimeoutException e) {
                        e.printStackTrace();
                        logger.error("查询数据模型出错:{}",e.getMessage());
                    } finally {
                        if(threadPool!=null){
                            //线程池关闭
                            threadPool.shutdown();
                        }
                    }
                }
            }
        }

        /** 找出拥有权限的数据模型数据返回 */
        for (DataModelRoleEntity roleEntity : dataModelRoleEntities) {
            if(allMap.get(roleEntity.getDatasetId().toString()) != null){
                if(resMap.get(roleEntity.getDatasetId().toString()) == null){
                    resMap.put(roleEntity.getDatasetId().toString(),roleEntity.getDatasetId());
                    res.add((JSONObject)allMap.get(roleEntity.getDatasetId().toString()));
                }
            }
        }
        /** 需要保存查询的数据 */
        if(queryType == 2){
            for (DataModelCustomerBillEntity customerBillEntity : customerBillEntities) {
                DataModelBillEntity billEntity = iDataModelBillService.getById(customerBillEntity.getModelBillId());
                if(billEntity.getQueryType() == 2){
                    saveList.add((JSONObject)allMap.get(billEntity.getDataModelId().toString()));
                }
            }
            QueryWrapper<DataModelDataEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_id", bill.getString("id"));
            wrapper.last("LIMIT 1");
            DataModelDataEntity dataEntity = dataModelDataService.getOne(wrapper);
            if(dataEntity == null){
                dataEntity = new DataModelDataEntity();
            }
            dataEntity.setBillId(bill.getString("id"));
            dataEntity.setData(JSONObject.toJSONString(saveList));
            dataModelDataService.saveOrUpdate(dataEntity,false);
        }

        if(ListUtil.isNotEmpty(res)){
            res.sort(Comparator.comparingInt(a -> a.getInteger("sequence")));
        }
        return CommonResponse.success(res);
    }

    @Override
    public CommonResponse<List<Long>> queryDataModelExist(String billTypeCode) {
        //2、根据单据类型查询数据模型
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeCode",new Parameter(QueryParam.EQ, billTypeCode));
        List<DataModelCustomerBillEntity> customerBillEntities = customerBillService.queryList(param);
        if(ListUtil.isEmpty(customerBillEntities)){
            return CommonResponse.error("该单据类型未挂载任何数据模型！");
        }
        List<DataModelCustomerBillEntity> customerBills = new ArrayList<>();
        for (DataModelCustomerBillEntity record : customerBillEntities) {
            DataModelBillEntity entity = iDataModelBillService.selectById(record.getModelBillId());
            if(entity!=null){
                customerBills.add(record);
            }
        }
        if(ListUtil.isEmpty(customerBills)){
            return CommonResponse.error("该单据类型未挂载任何数据模型！");
        }
        //3、查询出主数据模型 角色关系
        CommonResponse<List<Long>> roleIds = iRoleApi.queryRoleIdsByUserId(InvocationInfoProxy.getUserid());
        if(!roleIds.isSuccess() || (roleIds.isSuccess() && ListUtil.isEmpty(roleIds.getData()))){
            return CommonResponse.error("未查询到查询当前用户挂载的角色！");
        }

        /** 查询 用户是否拥有这些数据模型的查看权限 */
        QueryParam roleParam = new QueryParam();
        roleParam.getParams().put("roleId",new Parameter(QueryParam.IN,roleIds.getData()));
        List<DataModelRoleEntity> dataModelRoleEntities = dataModelRoleService.queryList(roleParam);
        if(ListUtil.isEmpty(dataModelRoleEntities)){
            return CommonResponse.error("当前用户挂载的角色里面，没有挂载任何数据模型！");
        }

        /** 找出拥有权限的数据模型数据返回 */
        Map<String,Long> resMap = new HashMap<>();
        List<Long> res = new ArrayList<>();
        for (DataModelRoleEntity roleEntity : dataModelRoleEntities) {
            for (DataModelCustomerBillEntity customerBillEntity : customerBills) {
                if(customerBillEntity.getDataModelId().equals(roleEntity.getDatasetId()) && resMap.get(roleEntity.getDatasetId().toString()) == null){
                    DataModelEntity dataModelEntity = selectById(customerBillEntity.getDataModelId());
                    if(dataModelEntity!=null){
                        resMap.put(roleEntity.getDatasetId().toString(),roleEntity.getDatasetId());
                        res.add(roleEntity.getDatasetId());
                    }
                }
            }
        }
        if(ListUtil.isEmpty(res)){
            return CommonResponse.error("当前用户没有挂载任何数据模型！");
        }
        return CommonResponse.success(res);
    }

    /**
     * 根据id字符串逗号分隔，真实删除数据
     *
     * @param ids
     */
    @Override
    public void deleteByIds(String ids) {
        dataModelMapper.deleteByIds(ids);
    }


    class MainDatasetCallable implements Callable<List<JSONObject>> {
        private RequestAttributes context;
        private String[] setIds;
        private DataModelEntity modelEntity;
        private DataModelDataSetEntity setEntity;
        private String baseHost;
        private String billTypeCode;
        private String authority;
        private String billParam;
        private String billSubParam;
        private Long tenantId;
        private JSONObject billData;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public MainDatasetCallable(String billTypeCode,String[] setIds,RequestAttributes context, DataModelEntity modelEntity,DataModelDataSetEntity setEntity,JSONObject billData,String billParam,String billSubParam
                                   , String authority, Long tenantId, ConcurrentHashMap<Long, MdProjectVO> projectCache,String baseHost) {
            this.billTypeCode = billTypeCode;
            this.setIds = setIds;
            this.billSubParam = billSubParam;
            this.billParam = billParam;
            this.setEntity = setEntity;
            this.billData = billData;
            this.context = context;
            this.modelEntity = modelEntity;
            this.authority = authority;
            this.tenantId = tenantId;
            this.projectCache = projectCache;
            this.baseHost = baseHost;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            InvocationInfoProxy.setTenantid(tenantId);
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);

            List<JSONObject> mainDatasetList = null;

            // 通过元数据查询该数据集属于哪个项目
            MdProjectVO projectVO = projectCache.get(setEntity.getMdprojectId());
            if(null == projectVO) {
                String url = baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                Map<String, String> param = new HashMap<>();
                Map<String, String> header = new HashMap<>();
                param.put("id", setEntity.getMdprojectId().toString());
                header.put("authority", authority);
                String projectInfoResp = HttpTookit.get(url, param, header);
                logger.info("查询【id-{}】元数据项目信息结果：{}", setEntity.getMdprojectId().toString(), projectInfoResp);
                CommonResponse<JSONObject> response = JSONObject.parseObject(projectInfoResp, CommonResponse.class);

                if (response.isSuccess()) {
                    projectVO = JSONObject.parseObject(JSONObject.toJSONString(response.getData()), MdProjectVO.class);
                    projectCache.put(projectVO.getId(), projectVO);
                } else {
                    logger.error("数据模型【{}】查询数据失败, 其对应元数据查询失败, 原因：{}", JSONObject.toJSONString(modelEntity), response.getMsg());
                }
            }
            if(null != projectVO && StringUtils.isNotEmpty(setEntity.getSqlContent())) {
                String mainDatasetUrl = baseHost + projectVO.getProjectName() + "/common/report/parse";
                JSONObject mainParamJson = new JSONObject();
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", tenantId);
                String bp = modelEntity.getBillParam();
                if(StringUtils.isNotEmpty(bp) && StringUtils.isNotEmpty(billParam)){
                    String[] billP = billParam.split(",");//单据字段
                    String[] bpp = bp.split(",");
                    if(bpp.length == billP.length){
                        for (int i = 0; i < bpp.length; i++) {
                            String s = bpp[i];
                            String p = billP[i];
                            if(billData.getString(p) == null){
                                logger.error("单据数据{}为空，单据数据{}",p,billData);
                            }
                            /** 将单据数据参数拼接上 */
                            if(billData.getString(p)!=null && billData.getString(p).indexOf("{")>-1){
                                mainQueryParam.put(s,billData.getJSONObject(p).getString("id"));
                            }else {
                                mainQueryParam.put(s,billData.getString(p));
                            }
                        }
                    }else {
                        logger.error("单据数据字段{}与系统字段{}不匹配",billParam,bp);
                    }
                }else {
                    logger.error("单据数据字段{}与系统字段{}有空值",billParam,bp);
                }
                /** 拼接子表参数 */
                if(modelEntity.getSubTabParam() != null && billSubParam != null){
                    String[] sqlParam = modelEntity.getSubTabParam().split(",");
                    String[] subs = billSubParam.split(",");
                    if(sqlParam.length == subs.length){
                        for (int i = 0; i < subs.length; i++) {
                            String[] sub = subs[i].split(":");
                            if(sub.length!=2){
                                logger.error("单据子表字段{}与系统子表字段{} 不匹配",billSubParam,modelEntity.getSubTabParam());
                            }else {
                                JSONArray array = billData.getJSONArray(sub[0]);//子表键值获取子表数据
                                String key = sub[1];//子表字段键值
                                StringBuffer valueArr = new StringBuffer();
                                if(array!=null){
                                    for (Object o : array) {
                                        JSONObject row = new JSONObject((HashMap)o);
                                        if(StringUtils.isNotEmpty(row.getString(key))){
                                            valueArr.append("'").append(row.getString(key)).append("',");
                                        }
                                    }
                                }
                                if(valueArr.length()>0){
                                    mainQueryParam.put(sqlParam[i],valueArr.toString().substring(0,valueArr.length()-1));
                                }
                            }

                        }
                    }else {
                        logger.error("单据子表字段{}与系统子表字段{}数量不匹配",billSubParam,modelEntity.getSubTabParam());
                    }
                }else {
                    logger.error("单据子表字段{}与系统子表字段{}有空值",billSubParam,modelEntity.getSubTabParam());
                }

                String sql = "SELECT dsq.* FROM (" + setEntity.getSqlContent() + " ) dsq  ";

                mainParamJson.put("sqlContent", JdkBase64Util.encode(sql));
                mainParamJson.put("datasetType", "1");
                mainParamJson.put("params", mainQueryParam);

                String mainResponseStr = ReferHttpClientUtils.postByJson(mainDatasetUrl, JSON.toJSONString(mainParamJson));

                CommonResponse<List<JSONObject>> mainResponse = JSON.parseObject(mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    if(mainDatasetList == null){
                        mainDatasetList = new ArrayList<>();
                    }
                    mainDatasetList.addAll(mainResponse.getData());

                } else {
                    logger.error("******************* 执行SQL查询失败：{}  *******************", mainResponse.getMsg());
                }
            }else {
                logger.error("*******************数据模型没找到对应元数据：{}  *******************", JSONObject.toJSONString(modelEntity));
            }

            /** 根据数据地址查询数据集 */
            if(StringUtils.isNotEmpty(setEntity.getDataUrl())){
                String url = null;
                if(setEntity.getDataUrl().startsWith("http")){
                    url = setEntity.getDataUrl();
                }else {
                    url = baseHost + setEntity.getDataUrl();
                }
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", tenantId);
                mainQueryParam.put("billTypeCode", billTypeCode);
                mainQueryParam.put("bill", billData);
                String bp = modelEntity.getBillParam();
                /** 拼接主表参数 */
                if(StringUtils.isNotEmpty(bp) && StringUtils.isNotEmpty(billParam)){
                    String[] billP = billParam.split(",");//单据字段
                    String[] bpp = bp.split(",");
                    if(bpp.length == billP.length){
                        for (int i = 0; i < bpp.length; i++) {
                            String s = bpp[i];
                            String p = billP[i];
                            if(billData.getString(p) == null){
                                logger.error("单据数据{}为空，单据数据{}",p,billData);
                            }
                            /** 将单据数据参数拼接上 */
                            if(billData.getString(p)!=null && billData.getString(p).indexOf("{")>-1){
                                mainQueryParam.put(s,billData.getJSONObject(p).getString("id"));
                            }else {
                                mainQueryParam.put(s,billData.getString(p));
                            }
                        }
                    }else {
                        logger.error("单据数据字段{}与系统字段{}不匹配",billParam,bp);
                    }
                }else {
                    logger.error("单据数据字段{}与系统字段{}有空值",billParam,bp);
                }

                /** 拼接子表参数 */
                if(modelEntity.getSubTabParam() != null && billSubParam != null){
                    String[] sqlParam = modelEntity.getSubTabParam().split(",");
                    String[] subs = billSubParam.split(",");
                    if(sqlParam.length == subs.length){
                        for (int i = 0; i < subs.length; i++) {
                            String[] sub = subs[i].split(":");
                            if(sub.length!=2){
                                logger.error("单据子表字段{}与系统子表字段{} 不匹配",billSubParam,modelEntity.getSubTabParam());
                            }else {
                                JSONArray array = billData.getJSONArray(sub[0]);//子表键值获取子表数据
                                String key = sub[1];//子表字段键值
                                List<String> value = new ArrayList<>();
                                if(array!=null){
                                    for (Object o : array) {
                                        JSONObject row = new JSONObject((HashMap)o);
                                        if(StringUtils.isNotEmpty(row.getString(key))){
                                            value.add(row.getString(key));
                                        }
                                    }
                                }
                                if(value.size()>0){
                                    mainQueryParam.put(sqlParam[i],value);
                                }
                            }
                        }
                    }else {
                        logger.error("单据子表字段{}与系统子表字段{}数量不匹配",billSubParam,modelEntity.getSubTabParam());
                    }
                }else {
                    logger.error("单据子表字段{}与系统子表字段{}有空值",billSubParam,modelEntity.getSubTabParam());
                }

                String mainResponseStr = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(mainQueryParam));

                CommonResponse<List<JSONObject>> mainResponse = JSON.parseObject(mainResponseStr, CommonResponse.class);
                logger.info("url-{},mainQueryParam-{},mainResponse-{}",url,JSON.toJSONString(mainQueryParam),JSON.toJSONString(mainResponse));
                if (mainResponse.isSuccess()) {
                    if(mainDatasetList == null){
                        mainDatasetList = new ArrayList<>();
                    }
                    mainDatasetList.addAll(mainResponse.getData());
                } else {
                    logger.error("******************* 根据数据地址查询数据集 查询失败：{}  *******************", mainResponse.getMsg());
                }

            }

            // 查询子数据集
            QueryParam queryParam = new QueryParam();
            if(modelEntity.getModelType() == 1 || modelEntity.getModelType() == 3 || modelEntity.getModelType() == 4 || modelEntity.getModelType() == 5){
                if(ListUtil.isEmpty(mainDatasetList)){
                    mainDatasetList = new ArrayList<>();
                    mainDatasetList.add(new JSONObject());
                }
                /** 指标型、饼状图、柱状图、折线图，选取第一个数据集作为主数据集，其余为子数据集 */
                if(setIds.length>1){
                    List<String> ids = new ArrayList<>();
                    for (int i = 1; i < setIds.length; i++) {
                        ids.add(setIds[i]);
                    }
                    queryParam.getParams().put("id",new Parameter(QueryParam.IN,ids));
                }else {
                    /** 没有子数据集 */
                    return mainDatasetList;
                }
            }else {
                queryParam.getParams().put("parentId",new Parameter(QueryParam.EQ,setEntity.getId()));
            }
            List<DataModelDataSetEntity> childDatasetList = iDataModelDataSetService.queryList(queryParam);
            if (ListUtil.isNotEmpty(childDatasetList) && ListUtil.isNotEmpty(mainDatasetList)) {
                /** 创建n个子线线程池*/
                ExecutorService threadPool = Executors.newFixedThreadPool(childDatasetList.size());
                try {
                    for (JSONObject mainDataset : mainDatasetList) {
                        /** 每一条主数据集数据 */
                        List<Future<List<JSONObject>>> futureList = new ArrayList<>();
                        for (DataModelDataSetEntity childDataset : childDatasetList) {
                            Callable<List<JSONObject>> childCallable = new ChildDatasetCallable(billTypeCode,modelEntity,billParam,billSubParam,childDataset, mainDataset,billData,
                                    context, tenantId, authority, projectCache,baseHost);
                            Future<List<JSONObject>> childFuture = threadPool.submit(childCallable);
                            futureList.add(childFuture);
                        }

                        for (Future<List<JSONObject>> future : futureList) {
                            List<JSONObject> childList = future.get();
                            if (childList != null && childList.size() > 0) {
                                JSONObject childObject = childList.get(0);
                                if(null != childObject) {
                                    for (Map.Entry<String, Object> entry : childObject.entrySet()) {
                                        if(entry.getValue() instanceof BigDecimal && entry.getValue().toString().equals("0E-8")){
                                            mainDataset.put(entry.getKey(), new BigDecimal("0.00"));
                                        }else {
                                            mainDataset.put(entry.getKey(), entry.getValue());
                                        }
                                    }
                                }
                            }
                        }
                    }
                } finally {
                    //线程池关闭
                    threadPool.shutdown();
                }
            }

            return mainDatasetList;
        }
    }


    /**
     * 子线程
     *
     * @author Administrator
     *
     */
    class ChildDatasetCallable implements Callable<List<JSONObject>> {

        private DataModelEntity modelEntity;
        private DataModelDataSetEntity childDataset;
        private JSONObject mainDataset;
        private RequestAttributes context;
        private Long tenantId;
        private String authority;
        private String baseHost;
        private String billTypeCode;
        private String billParam;
        private String billSubParam;
        private JSONObject billData;
        private ConcurrentHashMap<Long, MdProjectVO> projectCache;

        public ChildDatasetCallable(String billTypeCode,DataModelEntity modelEntity,String billParam,String billSubParam,DataModelDataSetEntity childDataset, JSONObject mainDataset,JSONObject billData,
                                    RequestAttributes context, Long tenantId, String authority, ConcurrentHashMap<Long, MdProjectVO> projectCache,String baseHost) {
            this.billTypeCode = billTypeCode;
            this.modelEntity = modelEntity;
            this.billParam = billParam;
            this.billSubParam = billSubParam;
            this.childDataset = childDataset;
            this.mainDataset = mainDataset;
            this.context = context;
            this.tenantId = tenantId;
            this.authority = authority;
            this.billData = billData;
            this.projectCache = projectCache;
            this.baseHost = baseHost;
        }

        @Override
        public List<JSONObject> call() throws Exception {
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);

            List<JSONObject> dataList = new ArrayList<>();
//             通过元数据查询该数据集属于哪个项目
            MdProjectVO projectVO = projectCache.get(childDataset.getMdprojectId());
            if(null == projectVO) {
                String url = baseHost + "ejc-metadata-web/api/mdProjectApi/queryDetail";
                Map<String, String> param = new HashMap<>();
                Map<String, String> header = new HashMap<>();
                param.put("id", childDataset.getMdprojectId().toString());
                header.put("authority", authority);
                String projectInfoResp = HttpTookit.get(url, param, header);
                logger.info("查询【id-{}】元数据项目信息结果：{}", childDataset.getMdprojectId(), projectInfoResp);
                CommonResponse<JSONObject> response = JSONObject.parseObject(projectInfoResp, CommonResponse.class);
                if (response.isSuccess()) {
                    projectVO = JSONObject.parseObject(JSONObject.toJSONString(response.getData()), MdProjectVO.class);
                    projectCache.put(projectVO.getId(), projectVO);
                } else {
                    logger.error("数据子集【id-{}】查询数据失败, 其对应元数据查询失败, 原因：{}", childDataset.getId(), response.getMsg());
                }
            }

            /** 优先 执行sql查询数据集 */
            if(null != projectVO && StringUtils.isNotEmpty(childDataset.getSqlContent())) {
                String childDatasetUrl = baseHost + projectVO.getProjectName() + "/common/report/parse";

                JSONObject childParamJson = new JSONObject();
                JSONObject childQueryParam = new JSONObject();
                childQueryParam.put("tenantId", tenantId);
                if (StringUtils.isNotBlank(childDataset.getChildParam())) {
                    String[] childParamArr = childDataset.getChildParam().split(",");
                    for (String childParamStr : childParamArr) {
                        childQueryParam.put(childParamStr, mainDataset.getString(childParamStr));
                    }
                }
                String bp = modelEntity.getBillParam();
                if(StringUtils.isNotEmpty(bp) && StringUtils.isNotEmpty(billParam)){
                    String[] bpp = bp.split(",");
                    String[] billP = billParam.split(",");//单据字段
                    if(bpp.length == billP.length){
                        for (int i = 0; i < bpp.length; i++) {
                            String s = bpp[i];
                            String p = billP[i];
                            if(billData.getString(p) == null){
                                logger.error("单据数据{}为空，单据数据{}",p,billData);
                            }
                            /** 将单据数据参数拼接上 */
                            if(billData.getString(p)!=null && billData.getString(p).indexOf("{")>-1){
                                childQueryParam.put(s,billData.getJSONObject(p).getString("id"));
                            }else {
                                childQueryParam.put(s,billData.getString(p));
                            }
                        }
                    }else {
                        logger.error("单据数据字段{}与系统字段{}不匹配",billParam,bp);
                    }
                }else {
                    logger.error("单据数据字段{}与系统字段{}有空值",billParam,bp);
                }

                childParamJson.put("sqlContent", JdkBase64Util.encode(childDataset.getSqlContent()));
                childParamJson.put("datasetType", "2");
                childParamJson.put("params", childQueryParam);

                String childResponseStr = ReferHttpClientUtils.postByJson(childDatasetUrl, JSON.toJSONString(childParamJson));

                CommonResponse<List<JSONObject>> childResponse = JSON.parseObject(childResponseStr, CommonResponse.class);

                if (childResponse.isSuccess()) {
                    logger.info("执行sql-{}, 参数-{}, 结果-{}", childDataset.getSqlContent(), childQueryParam, JSONObject.toJSONString(childResponse.getData()));
                    if(ListUtil.isNotEmpty(childResponse.getData())){
                        return childResponse.getData();
                    }
                }
            }


            /** 根据数据地址查询数据集 */
            if(childDataset.getDataUrl()!=null){
                String url = null;
                if(childDataset.getDataUrl().startsWith("http")){
                    url = childDataset.getDataUrl();
                }else {
                    url = baseHost + childDataset.getDataUrl();
                }
                JSONObject mainQueryParam = new JSONObject();
                mainQueryParam.put("tenantId", tenantId);
                mainQueryParam.put("billTypeCode", billTypeCode);
                mainQueryParam.put("bill", billData);
                String bp = modelEntity.getBillParam();
                /** 拼接主表参数 */
                if(StringUtils.isNotEmpty(bp) && StringUtils.isNotEmpty(billParam)){
                    String[] billP = billParam.split(",");//单据字段
                    String[] bpp = bp.split(",");
                    if(bpp.length == billP.length){
                        for (int i = 0; i < bpp.length; i++) {
                            String s = bpp[i];
                            String p = billP[i];
                            if(billData.getString(p) == null){
                                logger.error("单据数据{}为空，单据数据{}",p,billData);
                            }
                            /** 将单据数据参数拼接上 */
                            if(billData.getString(p)!=null && billData.getString(p).indexOf("{")>-1){
                                mainQueryParam.put(s,billData.getJSONObject(p).getString("id"));
                            }else {
                                mainQueryParam.put(s,billData.getString(p));
                            }
                        }
                    }else {
                        logger.error("单据数据字段{}与系统字段{}不匹配",billParam,bp);
                    }
                }else {
                    logger.error("单据数据字段{}与系统字段{}有空值",billParam,bp);
                }

                /** 拼接子表参数 */
                if(modelEntity.getSubTabParam() != null && billSubParam != null){
                    String[] sqlParam = modelEntity.getSubTabParam().split(",");
                    String[] subs = billSubParam.split(",");
                    if(sqlParam.length == subs.length){
                        for (int i = 0; i < subs.length; i++) {
                            String[] sub = subs[i].split(":");
                            if(sub.length!=2){
                                logger.error("单据子表字段{}与系统子表字段{} 不匹配",billSubParam,modelEntity.getSubTabParam());
                            }else {
                                JSONArray array = billData.getJSONArray(sub[0]);//子表键值获取子表数据
                                String key = sub[1];//子表字段键值
                                List<String> value = new ArrayList<>();
                                if(array!=null){
                                    for (Object o : array) {
                                        JSONObject row = new JSONObject((HashMap)o);
                                        if(StringUtils.isNotEmpty(row.getString(key))){
                                            value.add(row.getString(key));
                                        }
                                    }
                                }
                                if(value.size()>0){
                                    mainQueryParam.put(sqlParam[i],value);
                                }
                            }
                        }
                    }else {
                        logger.error("单据子表字段{}与系统子表字段{}数量不匹配",billSubParam,modelEntity.getSubTabParam());
                    }
                }else {
                    logger.error("单据子表字段{}与系统子表字段{}有空值",billSubParam,modelEntity.getSubTabParam());
                }

                String mainResponseStr = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(mainQueryParam));

                CommonResponse<List<JSONObject>> mainResponse = JSON.parseObject(mainResponseStr, CommonResponse.class);
                if (mainResponse.isSuccess()) {
                    if(ListUtil.isNotEmpty(mainResponse.getData())){
                        return mainResponse.getData();
                    }
                } else {
                    logger.error("******************* 根据数据地址查询数据集 查询失败：{}  *******************", mainResponse.getMsg());
                }

            }

            return dataList;
        }

    }
}
