/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.bill.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bill.bean.BillRoleEntity;
import com.ejianc.foundation.bill.service.IBillRoleService;
import com.ejianc.foundation.bill.vo.BillRoleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billRole"})
public class BillRoleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillRoleService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillRoleVO> saveOrUpdate(@RequestBody BillRoleVO saveOrUpdateVO) {
        BillRoleEntity entity = (BillRoleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BillRoleEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeId", new Parameter("eq", (Object)saveOrUpdateVO.getBillTypeId()));
        if (CollectionUtils.isNotEmpty((Collection)this.service.queryList(param, false))) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u7c7b\u578b\u5df2\u5b58\u5728\u5236\u5ea6\u8bf4\u660e\uff0c\u8bf7\u6362\u4e00\u4e2a\u5355\u636e\u7c7b\u578b\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        BillRoleVO vo = (BillRoleVO)BeanMapper.map((Object)((Object)entity), BillRoleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillRoleVO> queryDetail(Long id) {
        BillRoleEntity entity = (BillRoleEntity)((Object)this.service.selectById(id));
        BillRoleVO vo = (BillRoleVO)BeanMapper.map((Object)((Object)entity), BillRoleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/findByBillTypeId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillRoleVO> findByBillTypeId(String billTypeId) {
        if (StringUtils.isEmpty((CharSequence)billTypeId)) {
            return CommonResponse.success();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billTypeId", new Parameter("eq", (Object)billTypeId));
        List entities = this.service.queryList(param, false);
        if (ListUtil.isEmpty((List)entities)) {
            return CommonResponse.success();
        }
        BillRoleEntity entity = (BillRoleEntity)((Object)entities.get(0));
        BillRoleVO vo = (BillRoleVO)BeanMapper.map((Object)((Object)entity), BillRoleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillRoleVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillRoleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        fuzzyFields.add("billTypeCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillRoleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeCode");
        fuzzyFields.add("billTypeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BillRole-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBillRoleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BillRoleVO>> refBillRoleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber.intValue());
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillRoleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

