/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller.api;

import com.ejianc.foundation.supplier.bean.SupplerIncidentEntity;
import com.ejianc.foundation.supplier.service.ISupplerIncidentService;
import com.ejianc.foundation.supplier.service.ISupplierCommentModleService;
import com.ejianc.foundation.supplier.util.ContractPerformanceStateEnum;
import com.ejianc.foundation.supplier.vo.ContractInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/supplierZY"})
public class SupplierZYApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISupplerIncidentService supplerIncidentService;
    @Autowired
    private ISupplierCommentModleService commentModleService;

    @RequestMapping(value={"/createGuoChengPingJia"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Long> createGuoChengPingJia(@RequestBody ContractInfoVO e) {
        if (e.getContractId() == null) {
            return CommonResponse.error((String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (e.getContractName() == null) {
            return CommonResponse.error((String)"\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getContractCode() == null) {
            return CommonResponse.error((String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getPartybId() == null) {
            return CommonResponse.error((String)"\u4e59\u65b9\uff08\u4f9b\u5e94\u5546\uff09id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getPartybName() == null) {
            return CommonResponse.error((String)"\u4e59\u65b9\uff08\u4f9b\u5e94\u5546\uff09\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getOrgId() == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u90e8\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getOrgName() == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u90e8\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getOrgCode() == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u90e8\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getProjectId() == null) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (e.getProjectName() == null) {
            return CommonResponse.error((String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SupplerIncidentEntity entity = new SupplerIncidentEntity();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("ZY_SUPPLIER_GCPJ_CODE", InvocationInfoProxy.getTenantid());
        if (billCode.isSuccess()) {
            entity.setCode((String)billCode.getData());
        } else {
            entity.setCode("GCPJ-" + IdWorker.getId());
        }
        entity.setContractId(e.getContractId());
        entity.setContractName(e.getContractName());
        entity.setContractCode(e.getContractCode());
        entity.setSupplyId(e.getPartybId());
        entity.setSupplyName(e.getPartybName());
        entity.setOrgId(e.getOrgId());
        entity.setOrgName(e.getOrgName());
        entity.setOrgCode(e.getOrgCode());
        entity.setProjectId(e.getProjectId());
        entity.setProjectName(e.getProjectName());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setContractId(e.getContractId());
        entity.setPerformanceStatus(e.getPerformanceStatus());
        entity.setStatus(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setContractType(e.getSourceType());
        entity.setContractName(e.getContractName());
        entity.setProjectId(e.getProjectId());
        entity.setProjectName(e.getProjectName());
        entity.setContractAmount(e.getContractTaxMny());
        entity.setSupplyId(e.getPartybId());
        entity.setSupplyName(e.getPartybName());
        entity.setOrgId(e.getOrgId());
        entity.setOrgName(e.getOrgName());
        entity.setOrgCode(e.getOrgCode());
        entity.setParentOrgId(e.getParentOrgId());
        entity.setParentOrgName(e.getParentOrgName());
        entity.setParentOrgCode(e.getParentOrgCode());
        entity.setHeadUserId(e.getSupplierProjectManagerId());
        entity.setHeadUserName(e.getSupplierProjectManagerName());
        entity.setDate(new Date());
        if (ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode().equals(e.getPerformanceStatus())) {
            entity.setSource("\u6700\u7ec8\u7ed3\u7b97");
        } else {
            entity.setSource("\u5b9a\u65f6\u63a8\u9001");
        }
        entity.setBuckleBranch(BigDecimal.ZERO);
        this.supplerIncidentService.saveOrUpdate((Object)entity, false);
        return CommonResponse.error((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)entity.getId());
    }
}

