package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;

@Controller
@RequestMapping("weather")
public class WeatherController {
    private final String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * @Author mrsir_wxp
     * @Date 2022/8/19 根据省份和城市查询天气
     * @Description queryWeatherByProvinceAndCity
     * @Param province 省份
     * @Param city 城市
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.oa.vo.WorkLogVO>
     */
    @RequestMapping(value = "/queryWeatherByProvinceAndCity", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryWeatherByProvinceAndCity(@RequestParam("province") String province, @RequestParam("city") String city, HttpServletRequest request ) throws UnsupportedEncodingException {
        JSONObject res = new JSONObject();
        String url = qqWeatherUrl+ URLEncoder.encode(province,"UTF-8");
        if(StringUtils.isEmpty(city)){
            url = url +"&city="+URLEncoder.encode(province,"UTF-8");
        }else {
            url = url +"&city="+URLEncoder.encode(city,"UTF-8");
        }
        /*if(StringUtils.isNotEmpty(d)){
            url = url +"&county="+URLEncoder.encode(d,"UTF-8");
        }*/
        String weather = null;
        logger.info("请求天气参数：{}", url);
        try {
            weather = ReferHttpClientUtils.get(url,request);
        } catch (GeneralSecurityException e) {
            logger.error("获取天气异常：province-{}, city-{}", province,city, e);
        } catch (IOException e) {
            logger.error("获取天气异常：province-{}, city-{}", province,city, e);
        }
        logger.info("{}{}{}",province,city,weather);
        if(StringUtils.isNotEmpty(weather)){
            res.put("weather",JSONObject.parseObject(weather));
        }else {
            res.put("weather",null);
        }
        return CommonResponse.success("查询详情数据成功！",res);
    }
}
