/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.quota.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.quota.bean.QuotaEntity;
import com.ejianc.foundation.quota.service.IQuotaService;
import com.ejianc.foundation.quota.vo.QuotaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"quota"})
public class QuotaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ZY_QUOTA_CODE";
    @Autowired
    private IQuotaService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuotaVO> saveOrUpdate(@RequestBody QuotaVO saveOrUpdateVO) {
        QuotaEntity entity = (QuotaEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, QuotaEntity.class));
        boolean isNew = false;
        if (entity.getId() == null || entity.getId() == 0L) {
            isNew = true;
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            Long id = IdWorker.getId();
            entity.setId(id);
            if (entity.getParentId() == null) {
                entity.setInnerCode(id.toString());
            } else {
                QuotaEntity p = (QuotaEntity)((Object)this.service.selectById(entity.getParentId()));
                entity.setInnerCode(p.getInnerCode() + "|" + id);
            }
            if (entity.getPrice() == null) {
                entity.setPrice(BigDecimal.ZERO);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.processPrice(entity, isNew);
        QuotaVO vo = (QuotaVO)BeanMapper.map((Object)((Object)entity), QuotaVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private void processPrice(QuotaEntity entity, boolean isNew) {
        boolean needUpdate = false;
        if (isNew) {
            if (entity.getParentId() != null) {
                needUpdate = true;
            }
        } else {
            QueryParam param = QueryParam.getInstance();
            param.getParams().put("parentId", new Parameter("eq", (Object)entity.getId()));
            List list = this.service.queryList(param, false);
            if (ListUtil.isEmpty((List)list) && entity.getParentId() != null) {
                needUpdate = true;
            }
        }
        if (needUpdate) {
            String[] split = entity.getInnerCode().split("\\|");
            QueryParam param = QueryParam.getInstance();
            for (int i = split.length - 2; i > -1; --i) {
                QuotaEntity quotaEntity = (QuotaEntity)((Object)this.service.selectById(Long.valueOf(split[i])));
                param.getParams().put("parentId", new Parameter("eq", (Object)quotaEntity.getId()));
                List list = this.service.queryList(param, false);
                BigDecimal price = list.stream().map(QuotaEntity::getPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                quotaEntity.setPrice(price);
                this.service.saveOrUpdate((Object)quotaEntity, false);
            }
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuotaVO> queryDetail(Long id) {
        QuotaEntity entity = (QuotaEntity)((Object)this.service.selectById(id));
        QuotaVO vo = (QuotaVO)BeanMapper.map((Object)((Object)entity), QuotaVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (QuotaVO quotaVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuotaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("parentId", new Parameter("eq", null));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), QuotaVO.class);
        this.setChildren(list);
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void setChildren(List<QuotaVO> list) {
        if (ListUtil.isNotEmpty(list)) {
            for (QuotaVO quotaVO : list) {
                QueryParam param = QueryParam.getInstance();
                param.getParams().put("parentId", new Parameter("eq", (Object)quotaVO.getId()));
                List entities = this.service.queryList(param, false);
                if (!ListUtil.isNotEmpty((List)entities)) continue;
                quotaVO.setChildren(BeanMapper.mapList((Iterable)entities, QuotaVO.class));
                this.setChildren(quotaVO.getChildren());
            }
        }
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Quota-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refQuotaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QuotaVO>> refQuotaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="relyCondition") String relyCondition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isEmpty((CharSequence)relyCondition)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page(1L, 0L, 0L));
        }
        param.getParams().put("pid", new Parameter("eq", (Object)relyCondition.split("=")[1]));
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            param.getParams().put("parentId", new Parameter("eq", null));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        List list = BeanMapper.mapList((Iterable)page.getRecords(), QuotaVO.class);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        this.setChildren(list);
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

