/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeReternVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.billcode.entity.BillCodeSNEntity;
import com.ejianc.foundation.billcode.service.IBcrSnService;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.mapper.BillCodeRuleMapper;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="billTypeRuleService")
public class BillCodeRuleServiceImpl
extends BaseServiceImpl<BillCodeRuleMapper, BillCodeRuleEntity>
implements IBillCodeRuleService {
    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;
    @Value(value="${oms.tenantid}")
    private String BASE_TNANT_ID;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IBillCodeEngineService billCodeEngineService;
    @Autowired
    private IBcrSnService bcrSnService;

    @Override
    public void delete(List<Long> ids) {
        ((BillCodeRuleMapper)this.baseMapper).deleteBatchIds(ids);
    }

    @Override
    public BillCodeRuleVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BillCodeRuleVO vo = null;
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    private void queryAttrDetail(BillCodeRuleVO vo, Long tenantId) {
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter("eq", (Object)vo.getId()));
        q.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        q.getOrderMap().put("elem_order", "asc");
        List<BillCodeRuleAttrVO> attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        if (CollectionUtils.isEmpty(attrs)) {
            q.getParams().put("tenant_id", new Parameter("eq", (Object)this.BASE_TNANT_ID));
            attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        }
        vo.setAttrs(attrs);
    }

    private void queryAttrDetail(BillCodeRuleVO vo, BillCodeParam billCodeParam) {
        JSONObject billDetail;
        QueryParam q = new QueryParam();
        q.getParams().put("billcode_rule_id", new Parameter("eq", (Object)vo.getId()));
        q.getParams().put("tenant_id", new Parameter("eq", (Object)billCodeParam.getTenantId()));
        q.getOrderMap().put("elem_order", "asc");
        List<BillCodeRuleAttrVO> attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        if (CollectionUtils.isEmpty(attrs)) {
            q.getParams().put("tenant_id", new Parameter("eq", (Object)this.BASE_TNANT_ID));
            attrs = this.billCodeRuleAttrService.getListByProperties(q, false);
        }
        if (attrs != null && attrs.size() > 0 && (billDetail = billCodeParam.getBillDetail()) != null) {
            for (BillCodeRuleAttrVO billCodeRuleAttrVO : attrs) {
                String key;
                String billValue;
                if (!StringUtils.isNotBlank((CharSequence)billCodeRuleAttrVO.getElemValue()) || !StringUtils.isNotBlank((CharSequence)(billValue = billDetail.getString(key = billCodeRuleAttrVO.getElemValue().trim())))) continue;
                billCodeRuleAttrVO.setBillValue(billValue);
            }
        }
        vo.setAttrs(attrs);
    }

    @Override
    public void save(BillCodeRuleVO billCodeRuleVo) {
        BillCodeRuleEntity saveEntity = null;
        ArrayList<BillCodeRuleAttrVO> attrs = new ArrayList();
        if (null != billCodeRuleVo.getId()) {
            attrs = billCodeRuleVo.getAttrs();
            saveEntity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectById(billCodeRuleVo.getId()));
            saveEntity.setRuleName(billCodeRuleVo.getRuleName());
            super.saveOrUpdate((Object)saveEntity);
        } else {
            billCodeRuleVo.setDr(BaseVO.DR_UNDELETE);
            billCodeRuleVo.setTenantId(InvocationInfoProxy.getTenantid());
            saveEntity = (BillCodeRuleEntity)((Object)BeanMapper.map((Object)billCodeRuleVo, BillCodeRuleEntity.class));
            super.saveOrUpdate((Object)saveEntity);
            attrs = billCodeRuleVo.getAttrs();
        }
        if (CollectionUtils.isNotEmpty(attrs)) {
            this.billCodeRuleAttrService.save(attrs, saveEntity.getId(), true);
        }
    }

    @Override
    public BillCodeRuleVO queryDetail(String ruleCode) {
        BillCodeRuleVO vo = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"rule_code", (Object)ruleCode);
        query.eq((Object)"tenant_id", (Object)this.BASE_TNANT_ID);
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectOne((Wrapper)query));
        if (null != entity) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    @Override
    public BillCodeRuleVO queryDetailByCodeAndTenantId(String code, Long tenantId) {
        BillCodeRuleVO vo = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"rule_code", (Object)code);
        query.eq((Object)"tenant_id", (Object)this.BASE_TNANT_ID);
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectOne((Wrapper)query));
        if (entity != null) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, tenantId);
        }
        return vo;
    }

    @Override
    public BillCodeRuleVO queryBillCodeDetail(BillCodeParam billCodeParam) {
        BillCodeRuleVO vo = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"rule_code", (Object)billCodeParam.getRuleCode());
        query.eq((Object)"tenant_id", (Object)this.BASE_TNANT_ID);
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)((BillCodeRuleMapper)this.baseMapper).selectOne((Wrapper)query));
        if (entity != null) {
            vo = (BillCodeRuleVO)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class);
            this.queryAttrDetail(vo, billCodeParam);
        }
        return vo;
    }

    @Override
    public List<BillCodeSNVO> queryBillCodeSnList(Long id) {
        ArrayList<BillCodeSNVO> resp = new ArrayList<BillCodeSNVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("rule_id", new Parameter("eq", (Object)id));
        List eList = this.bcrSnService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            for (BillCodeSNEntity entity : eList) {
                BillCodeSNVO vo = (BillCodeSNVO)((Object)BeanMapper.map((Object)((Object)entity), BillCodeSNVO.class));
                String range = "";
                try {
                    JSONObject json;
                    JSONArray jArray;
                    Long tenantId = vo.getTenantId();
                    if (tenantId != null && (jArray = ReferObjectUtil.getReferEntityValue((String)tenantId.toString(), (String)"idm-tenant")) != null && jArray.size() > 0) {
                        json = (JSONObject)jArray.get(0);
                        range = json.get((Object)"name").toString();
                    }
                    if (StringUtils.isBlank((CharSequence)range) && (jArray = ReferObjectUtil.getReferEntityValue((String)tenantId.toString(), (String)"idm-org")) != null && jArray.size() > 0) {
                        json = (JSONObject)jArray.get(0);
                        range = json.get((Object)"name").toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                vo.setRange(range);
                String markStr = vo.getMarkStr();
                markStr = markStr.replace("^custom^", "").replace("^sysentityattr^", "").replace("^sysdate^", "");
                vo.setFlowBasis(markStr);
                vo.setOldsn(vo.getLastsn());
                resp.add(vo);
            }
        }
        return resp;
    }

    @Override
    public void updateLastsn(BillCodeSNVO vo) {
        String RETURN_BILL_CODE_CACHE_KEY_PREFIX = "returnejcbillcode";
        String BILL_CODE_SN_REFER_CACHE_KEY_PREFIX = "ejcbillcode";
        String CACHE_KEY_SEPERATOR = ":";
        String key = RETURN_BILL_CODE_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
        this.billCodeEngineService.updateSNVO(vo.getRuleId().toString(), vo.getMarkStr(), vo.getLastsn(), vo.getTenantId());
        ArrayList<Object> rtnvos = new ArrayList<Object>();
        rtnvos.add(BeanMapper.map((Object)((Object)vo), BillCodeReternVO.class));
        this.cacheManager.set(key, (Serializable)((Object)JSONArray.toJSONString(rtnvos)));
        String key2 = BILL_CODE_SN_REFER_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
        this.cacheManager.set(key2, (Serializable)((Object)vo));
    }

    @Override
    public void updateLastsnList(List<BillCodeSNVO> vos) {
        for (BillCodeSNVO vo : vos) {
            String RETURN_BILL_CODE_CACHE_KEY_PREFIX = "returnejcbillcode";
            String BILL_CODE_SN_REFER_CACHE_KEY_PREFIX = "ejcbillcode";
            String CACHE_KEY_SEPERATOR = ":";
            String key = RETURN_BILL_CODE_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
            this.billCodeEngineService.updateSNVO(vo.getRuleId().toString(), vo.getMarkStr(), vo.getLastsn(), vo.getTenantId());
            ArrayList<Object> rtnvos = new ArrayList<Object>();
            rtnvos.add(BeanMapper.map((Object)((Object)vo), BillCodeReternVO.class));
            this.cacheManager.set(key, (Serializable)((Object)JSONArray.toJSONString(rtnvos)));
            String key2 = BILL_CODE_SN_REFER_CACHE_KEY_PREFIX + CACHE_KEY_SEPERATOR + vo.getRuleId() + vo.getMarkStr() + vo.getTenantId();
            this.cacheManager.set(key2, (Serializable)((Object)vo));
        }
    }
}

