/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdRelationApi;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.bean.ModuleEntity;
import com.ejianc.foundation.support.mapper.BillTypeMapper;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.billState.param.QueryQuoteParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BillTypeServiceImpl
extends BaseServiceImpl<BillTypeMapper, BillTypeEntity>
implements IBillTypeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${oms.tenantid}")
    private Long baseTenantId;
    private Gson gson = new Gson();
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IMdRelationApi mdRelationApi;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private BillTypeMapper billTypeMapper;

    @Override
    public void delete(List<Long> ids) {
        ((BillTypeMapper)this.baseMapper).deleteBatchIds(ids);
    }

    @Override
    public BillTypeVO queryDetail(Long id) {
        BillTypeEntity entity = (BillTypeEntity)((Object)((BillTypeMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            return (BillTypeVO)BeanMapper.map((Object)((Object)entity), BillTypeVO.class);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getBillTypeTree() {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sequence", "asc");
        queryParam.setOrderMap(orderMap);
        List moduleList = this.moduleService.queryList(queryParam, false);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)this.baseTenantId);
        List list = ((BillTypeMapper)this.baseMapper).selectList((Wrapper)query);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (BaseEntity entity : moduleList) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getModuleName());
            map.put("title", entity.getModuleName());
            map.put("parentId", entity.getParentId());
            map.put("nodeType", entity.getNodeType());
            map.put("code", entity.getModuleCode());
            resultMapList.add(map);
        }
        if (list != null && list.size() > 0) {
            for (BaseEntity entity : list) {
                map = new HashMap();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getBillName());
                map.put("title", entity.getBillName());
                map.put("parentId", entity.getModuleId());
                map.put("nodeType", "billType");
                map.put("code", entity.getBillCode());
                map.put("metadataId", entity.getMetadataId());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @Override
    public List<Map<String, Object>> getBillTypeTreeByCodes(String codes) {
        List<String> billCodes = Arrays.asList(codes.split(","));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)this.baseTenantId);
        query.in((Object)"bill_code", billCodes);
        List list = ((BillTypeMapper)this.baseMapper).selectList((Wrapper)query);
        List moduleIds = list.stream().map(BillTypeEntity::getModuleId).collect(Collectors.toList());
        QueryParam queryParam1 = new QueryParam();
        queryParam1.getParams().put("id", new Parameter("in", moduleIds));
        List moduleList = this.moduleService.queryList(queryParam1, false);
        HashSet<Long> moduleIdsAll = new HashSet<Long>();
        for (ModuleEntity moduleEntity : moduleList) {
            String[] split;
            for (String s : split = moduleEntity.getInnerCode().split("\\|")) {
                moduleIdsAll.add(Long.valueOf(s));
            }
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(BaseEntity::getId, moduleIdsAll);
        lambdaQueryWrapper.orderByAsc(ModuleEntity::getSequence);
        List moduleListRest = this.moduleService.list((Wrapper)lambdaQueryWrapper);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ModuleEntity entity : moduleListRest) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getModuleName());
            map.put("title", entity.getModuleName());
            map.put("parentId", entity.getParentId());
            map.put("nodeType", entity.getNodeType());
            map.put("code", entity.getModuleCode());
            resultMapList.add(map);
        }
        if (list != null && list.size() > 0) {
            for (BillTypeEntity entity : list) {
                map = new HashMap();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getBillName());
                map.put("title", entity.getBillName());
                map.put("parentId", entity.getModuleId());
                map.put("nodeType", "billType");
                map.put("code", entity.getBillCode());
                map.put("metadataId", entity.getMetadataId());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @Override
    public CommonResponse<Map<String, String>> checkQuotes(String billTypeCode, List<Long> billIds) {
        HashMap<String, String> checkResult;
        block14: {
            QueryQuoteParam param = new QueryQuoteParam();
            List checkIds = billIds.stream().map(item -> item.toString()).collect(Collectors.toList());
            checkResult = new HashMap<String, String>();
            try {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("billCode", new Parameter("eq", (Object)billTypeCode));
                IPage pageData = super.queryPage(queryParam, false);
                if (pageData.getTotal() > 0L) {
                    BillTypeVO billTypeVo = (BillTypeVO)BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
                    CommonResponse quoteResponse = this.mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
                    if (quoteResponse.isSuccess()) {
                        List quoteVOs = (List)quoteResponse.getData();
                        if (quoteVOs != null && quoteVOs.size() > 0) {
                            Map checkResultMap = null;
                            for (MdQuoteVO vo : quoteVOs) {
                                param.setBillIds(checkIds);
                                param.setTableName(vo.getTableName());
                                param.setColumn(vo.getAttributeCode());
                                String url = this.environmentTools.getBaseHost() + vo.getProjectName() + "/commonstate/queryQuoteBatch";
                                String paramterStr = this.gson.toJson((Object)param);
                                try {
                                    String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                                    this.logger.info("\u5f15\u7528\u6821\u9a8c\uff1aurl={},param={},result={}", new Object[]{url, paramterStr, result});
                                    CommonResponse data = (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<Map>>(){}.getType());
                                    if (!data.isSuccess()) continue;
                                    checkResultMap = (Map)data.getData();
                                    for (Object key : checkResultMap.keySet()) {
                                        if (!"true".equals(checkResultMap.get(key.toString()).toString())) continue;
                                        checkResult.put(key.toString(), "true");
                                        checkIds.remove(key.toString());
                                    }
                                    if (checkIds.size() != 0) continue;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new BusinessException(e.getMessage());
                                }
                            }
                            if (CollectionUtils.isNotEmpty(checkIds)) {
                                for (String checkId : checkIds) {
                                    checkResult.put(checkId, "false");
                                }
                            }
                        } else if (CollectionUtils.isNotEmpty(checkIds)) {
                            for (String checkId : checkIds) {
                                checkResult.put(checkId, "unknown");
                            }
                        }
                        break block14;
                    }
                    throw new BusinessException("\u6839\u636e\u5143\u6570\u636eid\uff1a" + billTypeVo.getMetadataId() + "\u67e5\u8be2\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
                }
                throw new BusinessException("\u6839\u636e\u5355\u636e\u7c7b\u578b\u7f16\u7801\u67e5\u8be2\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                return CommonResponse.error((String)e.getMessage());
            }
        }
        return CommonResponse.success(checkResult);
    }

    public CommonResponse<String> checkQuote(String billTypeCode, QueryQuoteParam param) {
        block8: {
            try {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("billCode", new Parameter("eq", (Object)billTypeCode));
                IPage pageData = super.queryPage(queryParam, false);
                if (pageData.getTotal() > 0L) {
                    BillTypeVO billTypeVo = (BillTypeVO)BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
                    CommonResponse quoteResponse = this.mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
                    if (quoteResponse.isSuccess()) {
                        List quoteVOs = (List)quoteResponse.getData();
                        if (quoteVOs != null && quoteVOs.size() > 0) {
                            for (MdQuoteVO vo : quoteVOs) {
                                param.setTableName(vo.getTableName());
                                param.setColumn(vo.getAttributeCode());
                                String url = this.environmentTools.getBaseHost() + vo.getProjectName() + "/commonstate/queryQuoteById";
                                String paramterStr = this.gson.toJson((Object)param);
                                try {
                                    String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                                    this.logger.info("\u5f15\u7528\u6821\u9a8c\uff1aurl={},param={},result={}", new Object[]{url, paramterStr, result});
                                    CommonResponse data = (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
                                    if (!data.isSuccess() || data.getData() == null || "0".equals(data.getData())) continue;
                                    String msg = "\u8be5\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u5355\u636e\uff08" + vo.getEntityDisplayName() + "\uff09\u5f15\u7528";
                                    throw new BusinessException(msg);
                                }
                                catch (Exception e) {
                                    throw new BusinessException(e.getMessage());
                                }
                            }
                        }
                        break block8;
                    }
                    throw new BusinessException("\u6839\u636e\u5143\u6570\u636eid\uff1a" + billTypeVo.getMetadataId() + "\u67e5\u8be2\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
                }
                throw new BusinessException("\u6839\u636e\u5355\u636e\u7c7b\u578b\u7f16\u7801\u67e5\u8be2\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                return CommonResponse.error((String)e.getMessage());
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> checkQuote(String billTypeCode, Long billId) {
        QueryQuoteParam param = new QueryQuoteParam();
        param.setBillId(billId.toString());
        return this.checkQuote(billTypeCode, param);
    }

    @Override
    public BillTypeVO getByMetadataId(Long metadataId) {
        BillTypeVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"metadata_id", (Object)metadataId);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        BillTypeEntity e = (BillTypeEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (BillTypeVO)BeanMapper.map((Object)((Object)e), BillTypeVO.class);
        }
        return resp;
    }

    @Override
    public List<BillTypeEntity> queryAllBillTypeList() {
        List<BillTypeEntity> billTypeList = this.billTypeMapper.queryAllBillTypeList();
        return billTypeList;
    }

    @Override
    public CommonResponse<List<Long>> checkQuotesAndReturnQuoteBillIds(String billTypeCode, List<Long> billIds) {
        ArrayList<Long> checkResult;
        block8: {
            QueryQuoteParam param = new QueryQuoteParam();
            List checkIds = billIds.stream().map(item -> item.toString()).collect(Collectors.toList());
            checkResult = new ArrayList<Long>();
            try {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("billCode", new Parameter("eq", (Object)billTypeCode));
                IPage pageData = super.queryPage(queryParam, false);
                if (pageData.getTotal() > 0L) {
                    BillTypeVO billTypeVo = (BillTypeVO)BeanMapper.map(pageData.getRecords().get(0), BillTypeVO.class);
                    CommonResponse quoteResponse = this.mdRelationApi.queryQuoteById(billTypeVo.getMetadataId());
                    if (quoteResponse.isSuccess()) {
                        List quoteVOs = (List)quoteResponse.getData();
                        if (quoteVOs == null || quoteVOs.size() <= 0) break block8;
                        Map checkResultMap = null;
                        for (MdQuoteVO vo : quoteVOs) {
                            param.setBillIds(checkIds);
                            param.setTableName(vo.getTableName());
                            param.setColumn(vo.getAttributeCode());
                            String url = this.environmentTools.getBaseHost() + vo.getProjectName() + "/commonstate/queryQuoteBatch";
                            String paramterStr = this.gson.toJson((Object)param);
                            try {
                                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                                this.logger.info("\u5f15\u7528\u6821\u9a8c\uff1aurl={},param={},result={}", new Object[]{url, paramterStr, result});
                                CommonResponse data = (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<Map>>(){}.getType());
                                if (!data.isSuccess()) continue;
                                checkResultMap = (Map)data.getData();
                                for (Object key : checkResultMap.keySet()) {
                                    if (!"true".equals(checkResultMap.get(key.toString()).toString())) continue;
                                    checkResult.add(Long.valueOf(key.toString()));
                                    checkIds.remove(key.toString());
                                }
                                if (checkIds.size() != 0) continue;
                                break block8;
                            }
                            catch (Exception e) {
                                throw new BusinessException(e.getMessage());
                            }
                        }
                        break block8;
                    }
                    throw new BusinessException("\u6839\u636e\u5143\u6570\u636eid\uff1a" + billTypeVo.getMetadataId() + "\u67e5\u8be2\u5f15\u7528\u4fe1\u606f\u5931\u8d25\uff01");
                }
                throw new BusinessException("\u6839\u636e\u5355\u636e\u7c7b\u578b\u7f16\u7801\u67e5\u8be2\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                return CommonResponse.error((String)e.getMessage());
            }
        }
        return CommonResponse.success(checkResult);
    }
}

