package com.ejianc.foundation.supplier.service.impl;

import com.ejianc.foundation.supplier.bean.SupplierYearEntity;
import com.ejianc.foundation.supplier.mapper.SupplierYearMapper;
import com.ejianc.foundation.supplier.service.ISupplierYearService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.*;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
@Service("yearService")
public class SupplierYearServiceImpl extends BaseServiceImpl<SupplierYearMapper, SupplierYearEntity> implements ISupplierYearService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SupplierYearMapper yearMapper;

    @Override
    public Map<Long, Integer> queryGrade(Map<String, List<Long>> map) {
        List<Long> suplyIds = map.get("suplyIds");
        List<SupplierYearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        Map<Long,Integer> resultMap = new HashMap<>();
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(),item.getYearDeduct());
        });
        return resultMap;
    }

    /**
     * @return
     */
    @Override
    public List<SupplierYearEntity> queryTotalAvg() {
        return yearMapper.queryTotalAvg(LocalDate.now().getYear());
    }

}
