/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.init.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.init.mapper.InitMapper;
import com.ejianc.foundation.init.service.InitService;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InitServiceImpl
implements InitService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    InitMapper initMapper;
    @Autowired
    ISupplierService iSupplierService;
    @Autowired
    private ICustomerCategoryService iCustomerCategoryService;
    @Autowired
    private ICustomerService iCustomerService;

    @Override
    public void initData(EnterpriseInitVO vo) {
        this.logger.info("\u521d\u59cb\u5316\u79df\u6237\u6570\u636e\u5f00\u59cb-------{}", (Object)JSONObject.toJSONString((Object)vo));
        if (vo.getTenantId() == null) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u5b58\u5728!");
        }
        this.initMapper.createThreeTables(vo.getTenantId());
        CustomerCategoryEntity customerCategoryEntity = new CustomerCategoryEntity();
        customerCategoryEntity.setId(IdWorker.getId());
        customerCategoryEntity.setName("\u5185\u90e8\u5ba2\u6237");
        customerCategoryEntity.setCode("CC-" + customerCategoryEntity.getId());
        customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
        customerCategoryEntity.setSequence(1);
        customerCategoryEntity.setDescription("\u7cfb\u7edf\u521b\u5efa\uff01");
        customerCategoryEntity.setTenantId(vo.getTenantId());
        this.iCustomerCategoryService.saveOrUpdate((Object)customerCategoryEntity, false);
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setId(IdWorker.getId());
        customerEntity.setSocialCreditCode(vo.getSocialCreditCode());
        customerEntity.setCode("CUS-" + customerEntity.getId());
        customerEntity.setName(vo.getName());
        customerEntity.setCategoryId(customerCategoryEntity.getId());
        customerEntity.setTenantId(vo.getTenantId());
        customerEntity.setLegal(vo.getLegalName());
        customerEntity.setTelephone(vo.getTelephone());
        customerEntity.setDescription("\u7cfb\u7edf\u521b\u5efa!");
        this.iCustomerService.saveOrUpdate((Object)customerEntity, false);
        SupplierEntity supplierEntity = new SupplierEntity();
        supplierEntity.setId(IdWorker.getId());
        supplierEntity.setCode("SP-" + supplierEntity.getId());
        supplierEntity.setTenantId(vo.getTenantId());
        supplierEntity.setName(vo.getName());
        this.iSupplierService.saveOrUpdate((Object)supplierEntity, false);
    }

    @Override
    public void rollBack(Long tenantId) {
        List customerEntities;
        List customerCategoryEntities;
        if (tenantId == null) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u5b58\u5728!");
        }
        this.initMapper.dropThreeTables(tenantId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List supplierEntityList = this.iSupplierService.queryList(queryParam, false);
        if (ListUtil.isNotEmpty((List)supplierEntityList)) {
            this.iSupplierService.removeByIds(supplierEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(customerCategoryEntities = this.iCustomerCategoryService.queryList(queryParam, false)))) {
            this.iCustomerCategoryService.removeByIds(customerCategoryEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(customerEntities = this.iCustomerService.queryList(queryParam, false)))) {
            this.iCustomerService.removeByIds(customerEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public void initDataByParams(EnterpriseInitVO vo) {
        if (vo.getTenantId() == null) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u5b58\u5728!");
        }
        if (vo.getInitData() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (vo.getInitData().contains("all")) {
                map.put("material", "material");
            } else if (vo.getInitData().contains("material")) {
                map.put("material", "material");
            }
            if (map != null && map.size() > 0) {
                this.initMapper.createThreeTablesByParams(map);
            }
            if (vo.getInitData().contains("customer") || vo.getInitData().contains("all")) {
                CustomerCategoryEntity customerCategoryEntity = new CustomerCategoryEntity();
                customerCategoryEntity.setId(IdWorker.getId());
                customerCategoryEntity.setName("\u5185\u90e8\u5ba2\u6237");
                customerCategoryEntity.setCode("CC-" + customerCategoryEntity.getId());
                customerCategoryEntity.setInnerCode(customerCategoryEntity.getId().toString());
                customerCategoryEntity.setSequence(1);
                customerCategoryEntity.setDescription("\u7cfb\u7edf\u521b\u5efa\uff01");
                customerCategoryEntity.setTenantId(vo.getTenantId());
                this.iCustomerCategoryService.saveOrUpdate((Object)customerCategoryEntity, false);
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setId(IdWorker.getId());
                customerEntity.setSocialCreditCode(vo.getSocialCreditCode());
                customerEntity.setCode("CUS-" + customerEntity.getId());
                customerEntity.setName(vo.getName());
                customerEntity.setCategoryId(customerCategoryEntity.getId());
                customerEntity.setTenantId(vo.getTenantId());
                customerEntity.setLegal(vo.getLegalName());
                customerEntity.setTelephone(vo.getTelephone());
                customerEntity.setDescription("\u7cfb\u7edf\u521b\u5efa!");
                this.iCustomerService.saveOrUpdate((Object)customerEntity, false);
            }
            if (vo.getInitData().contains("supplier") || vo.getInitData().contains("all")) {
                SupplierEntity supplierEntity = new SupplierEntity();
                supplierEntity.setId(IdWorker.getId());
                supplierEntity.setCode("SP-" + supplierEntity.getId());
                supplierEntity.setTenantId(vo.getTenantId());
                supplierEntity.setName(vo.getName());
                this.iSupplierService.saveOrUpdate((Object)supplierEntity, false);
            }
        }
    }

    @Override
    public void rollBackByParams(EnterpriseInitVO vo) {
        Long tenantId = vo.getTenantId();
        if (tenantId == null) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u5b58\u5728!");
        }
        if (vo.getInitData() != null) {
            List supplierEntityList;
            HashMap<String, String> map = new HashMap<String, String>();
            if (vo.getInitData().contains("all")) {
                map.put("material", "material");
                map.put("def", "def");
            } else {
                if (vo.getInitData().contains("material")) {
                    map.put("material", "material");
                }
                if (vo.getInitData().contains("material")) {
                    map.put("def", "def");
                }
            }
            if (map != null && map.size() > 0) {
                this.initMapper.dropThreeTables(tenantId);
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            if (vo.getInitData().contains("customer") || vo.getInitData().contains("all")) {
                List customerEntities;
                List customerCategoryEntities = this.iCustomerCategoryService.queryList(queryParam, false);
                if (ListUtil.isNotEmpty((List)customerCategoryEntities)) {
                    this.iCustomerCategoryService.removeByIds(customerCategoryEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                }
                if (ListUtil.isNotEmpty((List)(customerEntities = this.iCustomerService.queryList(queryParam, false)))) {
                    this.iCustomerService.removeByIds(customerEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                }
            }
            if ((vo.getInitData().contains("supplier") || vo.getInitData().contains("all")) && ListUtil.isNotEmpty((List)(supplierEntityList = this.iSupplierService.queryList(queryParam, false)))) {
                this.iSupplierService.removeByIds(supplierEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
        }
    }
}

