package com.ejianc.foundation.supplier.mapper;

import com.ejianc.foundation.supplier.bean.SupplierYearEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
@Mapper
public interface SupplierYearMapper extends BaseCrudMapper<SupplierYearEntity> {

    List<SupplierYearEntity> queryGrade(@Param("suplyIds") List<Long> suplyIds);

    @Select("SELECT  i.supply_id , AVG(i.year_deduct) year_deduct " +
            " FROM ejc_zy_supplier_year i WHERE i.dr = 0 AND YEAR(i.create_time) = #{year} AND i.bill_state IN (1,3) AND i.status = 1 GROUP BY i.supply_id ")
    List<SupplierYearEntity> queryTotalAvg(@Param("year") int year);
}
