package com.ejianc.foundation.support.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeReternVO;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;
import com.ejianc.foundation.support.vo.PublishDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.support.bean.BillCodeRuleAttrEntity;
import com.ejianc.foundation.support.bean.BillCodeRuleEntity;
import com.ejianc.foundation.support.service.IBillCodeRuleAttrService;
import com.ejianc.foundation.support.service.IBillCodeRuleService;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import com.ejianc.foundation.support.vo.BillCodeRuleVO;
import com.ejianc.foundation.support.vo.PublishVO;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 单据类型编码规则
 */
@RestController
@RequestMapping("/billcoderule/")
public class BillCodeRuleController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
	private Gson gson = new Gson();

    @Autowired
    private IBillCodeRuleService billCodeRuleService;
    @Autowired
    private IBillCodeRuleAttrService billCodeRuleAttrService;

    @Value("${oms.tenantid}")
    private Long omTenantId;

    /**
     * 分页查询满足条件的单据编码规则列表
     *
     * @param queryParam
     * @return
     */
    @PostMapping("pageList")
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        try {
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, omTenantId));
            IPage<BillCodeRuleEntity> pageData = billCodeRuleService.queryPage(queryParam, false);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", pageData);
            return CommonResponse.success(jsonObject);
        } catch (Exception e) {
            logger.error("查询单据编码规则列表异常，", e);
            return CommonResponse.error(null != e.getMessage() ? e.getMessage() : "查询单据编码规则列表失败，");
        }
    }

    @PostMapping(value = "delete")
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        try {
            Long curTenantId = InvocationInfoProxy.getTenantid();
            if(!omTenantId.equals(curTenantId)) {
                logger.error("非运营平台租户-【tenantId-{},userId-{}】进行编码规则删除操作", curTenantId, InvocationInfoProxy.getUserid());
                return CommonResponse.error("非运营人员无法进行编码规则删除操作！");
            }
            QueryParam param = new QueryParam();
            param.getParams().put("billcodeRuleId", new Parameter(QueryParam.IN, ids));
            param.getParams().put("tenantId", new Parameter(QueryParam.NE, omTenantId));
            List<BillCodeRuleAttrEntity> attrList = billCodeRuleAttrService.queryList(param, false);
            if(CollectionUtils.isNotEmpty(attrList)) {
                return CommonResponse.error("该编码规则已被租户使用，不允许删除！");
            }
			billCodeRuleService.delete(ids);
            return CommonResponse.success("删除成功");
        } catch (Exception e) {
            logger.error("批量删除单据编码规则异常: ", e);
            return CommonResponse.error(null != e.getMessage() ? e.getMessage() : "删除失败, ");
        }
    }

    /**
     * 根据主键ID查询单据编码规则详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetail")
    public CommonResponse<BillCodeRuleVO> queryDetail(@RequestParam Long id) {
        try {
            BillCodeRuleVO billCodeRuleVo = billCodeRuleService.queryDetail(id);
            return CommonResponse.success(billCodeRuleVo);
        } catch (Exception e) {
            logger.error("查询单据编码规则异常，", e);
            return CommonResponse.error(null != e.getMessage() ? e.getMessage() : "查询单据编码规则失败,");
        }
    }

    /**
     * 保存或更新单据编码规则信息
     *
     * @param billCodeRuleVo
     * @return
     */
    @PostMapping(value = "save")
    public CommonResponse<String> saveOrUpdate(@RequestBody BillCodeRuleVO billCodeRuleVo) {
        try {
//            QueryParam param = new QueryParam();
//            param.getParams().put("billtypeId", new Parameter(QueryParam.EQ, billCodeRuleVo.getBillTypeId()));
//            param.getParams().put("id", new Parameter(QueryParam.NE,
//                    null == billCodeRuleVo.getId() ? 0L : billCodeRuleVo.getId()));
//            List<BillCodeRuleEntity> eLIst = billCodeRuleService.queryList(param, false);
//            if(CollectionUtils.isNotEmpty(eLIst)) {
//                return CommonResponse.error("新增失败，同一单据类型下只能创建一个编码规则！");
//            }

			billCodeRuleService.save(billCodeRuleVo);
            return CommonResponse.success("保存成功！");
        } catch (Exception e) {
            logger.error("保存单据编码规则异常,", e);
            return CommonResponse.error(null != e.getMessage() ? e.getMessage() : "保存单据编码规则失败");
        }
    }

    @PostMapping(value = "checkCode")
    public CommonResponse<Boolean> checkCode(@RequestBody QueryParam param) {
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<BillCodeRuleEntity> list = billCodeRuleService.queryList(param, false);
        if(CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("编码重复！");
        } else {
            return CommonResponse.success("编码可以使用！");
        }
    }

	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			String scope = publishVO.getScope();
			if (StringUtils.isBlank(scope)) {
				return CommonResponse.error("发布数据失败:数据范围不能为空!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BillCodeRuleEntity> baseEntities = null;
			List<BillCodeRuleAttrEntity> ruleAttrEntities = null;
			if ("all".equalsIgnoreCase(scope)) { // 模块下的所有(包括本下)
				QueryParam queryParam = new QueryParam();
				Map<String, Parameter> params = new HashMap<>();
				params.put("billtypeId", new Parameter(QueryParam.EQ,publishVO.getModuleId()));
				queryParam.setParams(params);
				baseEntities = billCodeRuleService.queryList(queryParam, false);
			} else if ("select".equalsIgnoreCase(scope)) { // 选中数据
				if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
					baseEntities = (List<BillCodeRuleEntity>) billCodeRuleService.listByIds(publishVO.getIdList());
				}else{
					return CommonResponse.error("未选中要发布的数据");
				}
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BillCodeRuleEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getRuleCode())) {
						codes.add(entity.getRuleCode());
					}
				}
			}
			if(ids!=null&&ids.size()>0){
		        QueryParam q = new QueryParam();
		        q.getParams().put("billcode_rule_id", new Parameter(QueryParam.IN, ids));
		        q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		        q.getOrderMap().put("elem_order", QueryParam.ASC);
		        List<BillCodeRuleAttrVO> attrs = billCodeRuleAttrService.getListByProperties(q, false);
		        if(attrs!=null&&attrs.size()>0){
		        	ruleAttrEntities = BeanMapper.mapList(attrs, BillCodeRuleAttrEntity.class);
		        }
			}
			/*
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities,ruleAttrEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			*/

			PublishDataVO publishDataVO = new PublishDataVO();
			if(baseEntities!=null && baseEntities.size()>0){
				baseEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
			}
			if(ruleAttrEntities!=null && ruleAttrEntities.size()>0){
				ruleAttrEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
			}
			publishDataVO.setBillCodeRuleEntities(baseEntities);
			publishDataVO.setBillCodeRuleAttrEntities(ruleAttrEntities);
			publishDataVO.setIds(ids);
			publishDataVO.setType("billCodeRule");
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			gson = new GsonBuilder().disableHtmlEscaping().create();
			String paramterStr = gson.toJson(publishDataVO);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				logger.info("发布数据返回的结果：---------------"+result);
				return gson.fromJson(result, CommonResponse.class);
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布参照数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布参照数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
		if (ids == null || ids.isEmpty()) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		for (Long id : ids) {
			idStr = idStr + "'" + id + "',";
		}
		String codeStr = "";
		for (String code : codes) {
			codeStr = codeStr + "'" + code + "',";
		}
		idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
		codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
		String baseTableName = "ejc_support_billcode_rule";
		String ruleAttrTableName = "ejc_support_billcode_rule_attr";
		String deleteRuleAttrSql = " delete from " + ruleAttrTableName + " where billcode_rule_Id in " + idStr + ";";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
		String deleteByCodeSql = " delete from " + baseTableName + " where dr =1 and rule_code in " + codeStr + ";";
		sqlList.add(deleteRuleAttrSql);
		sqlList.add(deleteBaseSql);
		sqlList.add(deleteByCodeSql);
		return sqlList;
	}
	private List<String> getInsertSql(List<BillCodeRuleEntity> baseEntityList, List<BillCodeRuleAttrEntity> ruleAttrEntities) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		List<String> ruleAttrInsertSql = DataTransferUtil.getInsertSql(ruleAttrEntities);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		if (ruleAttrInsertSql != null && !ruleAttrInsertSql.isEmpty()) {
			retList.addAll(ruleAttrInsertSql);
		}
		return retList;
	}
	
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			String scope = publishVO.getScope();
			if (StringUtils.isBlank(scope)) {
				throw new BusinessException("导出脚本失败:数据范围不能为空!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BillCodeRuleEntity> baseEntities = null;
			List<BillCodeRuleAttrEntity> ruleAttrEntities = null;
			if ("all".equalsIgnoreCase(scope)) { // 模块下的所有(包括本下)
				QueryParam queryParam = new QueryParam();
				Map<String, Parameter> params = new HashMap<>();
				params.put("billtypeId", new Parameter(QueryParam.EQ,publishVO.getModuleId()));
				queryParam.setParams(params);
				baseEntities = billCodeRuleService.queryList(queryParam, false);
			} else if ("select".equalsIgnoreCase(scope)) { // 选中数据
				if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
					baseEntities = (List<BillCodeRuleEntity>) billCodeRuleService.listByIds(publishVO.getIdList());
				}else{
					throw new BusinessException("未选中要导出脚本的数据!");
				}
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BillCodeRuleEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getRuleCode())) {
						codes.add(entity.getRuleCode());
					}
				}
			}
			if(ids!=null&&ids.size()>0){
		        QueryParam q = new QueryParam();
		        q.getParams().put("billcode_rule_id", new Parameter(QueryParam.IN, ids));
		        q.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		        q.getOrderMap().put("elem_order", QueryParam.ASC);
		        List<BillCodeRuleAttrVO> attrs = billCodeRuleAttrService.getListByProperties(q, false);
		        if(attrs!=null&&attrs.size()>0){
		        	ruleAttrEntities = BeanMapper.mapList(attrs, BillCodeRuleAttrEntity.class);
		        }
			}
			
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities,ruleAttrEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			StringBuffer fileName = new StringBuffer();
			fileName.append("billType.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}

	@GetMapping(value = "queryBillCodeSnList")
	public CommonResponse<List<BillCodeSNVO>> queryBillCodeSnList(@RequestParam Long id) {
		try {
			List<BillCodeSNVO> list = billCodeRuleService.queryBillCodeSnList(id);
			return CommonResponse.success(list);
		} catch (Exception e) {
			logger.error("查询单据编码规则异常，", e);
			return CommonResponse.error(null != e.getMessage() ? e.getMessage() : "查询单据编码规则失败,");
		}
	}
	/**
	 * 更新流水号
	 *
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/updateLastsn")
	public CommonResponse<String> updateLastsn(@RequestBody BillCodeSNVO vo) {
		billCodeRuleService.updateLastsn(vo);
		return CommonResponse.success("更新流水号成功");
	}

	/**
	 * 更新流水号
	 *
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/updateLastsnList")
	public CommonResponse<String> updateLastsnList(@RequestBody List<BillCodeSNVO> vos) {
		billCodeRuleService.updateLastsnList(vos);
		return CommonResponse.success("更新流水号成功");
	}
}
