/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.billcode.elemproc.impl;

import com.ejianc.foundation.billcode.BillCodeEngineContext;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.billcode.elemproc.itf.IElemProcessor;
import com.ejianc.foundation.billcode.elemproc.result.BillCodeElemInfo;
import com.ejianc.foundation.billcode.model.BillCodeBillVO;
import com.ejianc.foundation.billcode.util.BillCodeProcessUtils;
import com.ejianc.foundation.support.vo.BillCodeRuleAttrVO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysTimeElemProcessor
implements IElemProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SysTimeElemProcessor.class);

    @Override
    public int getCanProcElemType() {
        return 2;
    }

    @Override
    public BillCodeElemInfo procElemInfo(BillCodeRuleAttrVO elemvo, BillCodeBillVO billCodeBillVO) throws BillCodeException {
        Date sysdate = BillCodeEngineContext.getInstance().getSysDateImp().getDate();
        logger.info("-----------------\u5355\u636e\u7f16\u7801\u89c4\u5219\u65f6\u95f4------------");
        logger.info("sysdate:{}", (Object)sysdate);
        String elemSNRefer = BillCodeProcessUtils.getDateElemSNRefer(Integer.valueOf(elemvo.getElemIsRefer()), sysdate);
        logger.info("elemSNRefer:{}", (Object)elemSNRefer);
        String elemSNReferDesc = "";
        if (!elemSNRefer.equals("")) {
            elemSNRefer = "^sysdate^" + elemSNRefer;
            elemSNReferDesc = "#date#" + elemSNRefer.length() + "|";
        }
        String elemProcedValue = BillCodeProcessUtils.formatDate(sysdate, elemvo.getDateElemDisplayFormat());
        logger.info("elemProcedValue:{}", (Object)elemProcedValue);
        BillCodeElemInfo eleminfo = new BillCodeElemInfo();
        eleminfo.setElemSNRefer(elemSNRefer);
        eleminfo.setElemSNReferDesc(elemSNReferDesc);
        eleminfo.setElemValue(elemProcedValue.trim().substring(0, elemvo.getElemLength()));
        eleminfo.setElemLength(elemvo.getElemLength());
        eleminfo.setSysTimeElem(true);
        return eleminfo;
    }
}

