package com.ejianc.foundation.share.service.impl;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@Service
public class MaterialCategoryServiceImpl implements IMaterialCategoryService {

	@Autowired
	private MaterialCategoryMapper materialCategoryMapper;

	@Override
	public List<MaterialCategoryEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String,Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		//放入租户ID进map
		condition.put("tenantId", InvocationInfoProxy.getTenantid());
		List<MaterialCategoryEntity> resultList = materialCategoryMapper.queryList(condition);
		return resultList;
	}

	@Override
	public MaterialCategoryVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialCategoryEntity entity = materialCategoryMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialCategoryEntity entity) {
		materialCategoryMapper.update(entity);
	}

	@Override
	public void save(MaterialCategoryEntity entity) {
		materialCategoryMapper.insert(entity);
	}

	/**
	 * 批量新增
	 *
	 * @param categoryEntityList
	 */
	@Override
	public void insertBatch(List<MaterialCategoryEntity> categoryEntityList) {
		if(ListUtil.isNotEmpty(categoryEntityList)){
			List<MaterialCategoryEntity> toInsert = new ArrayList<>();
			for (MaterialCategoryEntity entity : categoryEntityList){
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(entity);
			}
			if(toInsert.size()>0){
				materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}

	@Override
	public List<MaterialCategoryVO> queryListByPid(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByPid(tenantId, id);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialCategoryMapper.delete(tenantId,id);
	}

	@Override
	public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
		materialCategoryMapper.updateEnabled(enabled,tenantId,innerCode);
	}

	@Override
	public List<MaterialCategoryEntity> queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialCategoryMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialCategoryEntity> queryByName(String name) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialCategoryMapper.queryByName(tenantId, name);
	}

	@Override
	public void insertCategoryListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
	}

	@Override
	public List<MaterialCategoryVO> queryListTree(Map<String, Object> params) {
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public MaterialCategoryVO queryBySourceId(String sourceId) {
		MaterialCategoryEntity entity = materialCategoryMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
		if(entity!=null&&entity.getId()!=null){
			return BeanMapper.map(entity, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryListByInnerCode(Map<String, Object> params) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByInnerCode(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids) {
		List<MaterialCategoryVO> result = new ArrayList<>();
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			Set<Long> keySet = new HashSet<>();
			List<MaterialCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
			Map<Long, MaterialCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
			for(Long id : ids){
				MaterialCategoryVO categoryVO = categoryVOMap.get(id);
				if(categoryVO != null){
					String innerCode = categoryVO.getInnerCode();
					String[] keyArray = innerCode.split("\\|");
					for(String keyStr : keyArray){
						Long key = Long.valueOf(keyStr);
						if(!keySet.contains(key)){
							keySet.add(key);
							result.add(categoryVOMap.get(key));
						}
					}
				}
			}
		}
		return result;
	}

	@Override
	public List<MaterialCategoryVO> queryListByInnerCodes(Map<String, Object> params) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByInnerCodes(params);
		if(materialCategoryList != null && materialCategoryList.size() > 0) {
			return BeanMapper.mapList(materialCategoryList, MaterialCategoryVO.class);
		}
		return null;
	}

	@Override
	public MaterialCategoryVO queryLastCategoryByTime() {
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		List<MaterialCategoryEntity> list = materialCategoryMapper.queryLastCategoryByTime(params);
		return BeanMapper.map(list.get(0), MaterialCategoryVO.class);
	}

	@Override
	public List<MaterialCategoryEntity> exitByCode(String code, Long tenantId, Long id) {
		return materialCategoryMapper.exitByCode(code, tenantId, id);
	}

}
