/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.SupplierGradeEntity;
import com.ejianc.foundation.supplier.bean.SupplierPunishEntity;
import com.ejianc.foundation.supplier.service.ISupplierGradeService;
import com.ejianc.foundation.supplier.service.ISupplierPunishService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplier"})
public class SupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierPunishService punishService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISupplierGradeService gradeService;
    private static final String BILL_CODE = "ZY_SUPPLIER_CODE";
    @Autowired
    private ISupplierService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO saveOrUpdateVO) {
        SupplierEntity entity = (SupplierEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (!Objects.equals(InvocationInfoProxy.getOrgType(), "1") && !Objects.equals(InvocationInfoProxy.getOrgType(), "2")) {
                return CommonResponse.error((String)"\u8bf7\u5207\u6362\u7ec4\u7ec7\u5230\u96c6\u56e2\u6216\u8005\u4e8c\u7ea7\u5355\u4f4d\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
            }
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setGroupBlack(false);
            entity.setBlackOrgIds("");
            entity.setBlackOrgNames("");
            QueryParam queryParam = QueryParam.getInstance();
            queryParam.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getGradeName()));
            List gradeEntities = this.gradeService.queryList(queryParam, false);
            if (ListUtil.isEmpty((List)gradeEntities)) {
                return CommonResponse.error((String)("\u4fdd\u5b58\u4f9b\u5e94\u5546\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u3010" + saveOrUpdateVO.getGradeName() + "\u7ea7\u3011\u4f9b\u5e94\u5546\u7b49\u7ea7\u8bbe\u7f6e\uff01"));
            }
            entity.setYearScore(((SupplierGradeEntity)((Object)gradeEntities.get(0))).getReachScore().add(new BigDecimal("1")));
        }
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("taxNum", new Parameter("eq", (Object)saveOrUpdateVO.getTaxNum()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        List supplierEntities = this.service.queryList(queryParam, false);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            SupplierEntity supplierEntity = (SupplierEntity)((Object)supplierEntities.get(0));
            if ("p".equals(supplierEntity.getPersonal())) {
                return CommonResponse.error((String)("\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + saveOrUpdateVO.getTaxNum() + "\u3011\u7684\u4f9b\u5e94\u5546\u5df2\u88ab\u7ec4\u7ec7\u3010" + supplierEntity.getOrgName() + "\u3011\u5f55\u5165\u4e86\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
            }
            return CommonResponse.error((String)("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u3010" + saveOrUpdateVO.getTaxNum() + "\u3011\u7684\u4f9b\u5e94\u5546\u5df2\u88ab\u7ec4\u7ec7\u3010" + supplierEntity.getOrgName() + "\u3011\u5f55\u5165\u4e86\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
        }
        this.service.saveOrUpdate((Object)entity, false);
        SupplierVO vo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u4f9b\u5e94\u5546\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(Long id) {
        SupplierEntity entity = (SupplierEntity)((Object)this.service.selectById(id));
        SupplierVO vo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierVO supplierVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("taxNum");
        fuzzyFields.add("productionTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productionTypeName");
        fuzzyFields.add("taxNum");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Supplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplierData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productionTypeName");
        fuzzyFields.add("taxNum");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("groupBlack", new Parameter("eq", (Object)false));
        param.getParams().put("blackOrgIds", new Parameter("not_like", (Object)(InvocationInfoProxy.getOrgId() + "")));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refExceptionSupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refExceptionSupplier(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productionTypeName");
        fuzzyFields.add("taxNum");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        if (Objects.equals(InvocationInfoProxy.getOrgType(), "1")) {
            param.getParams().put("groupBlack", new Parameter("eq", (Object)true));
        } else {
            param.getParams().put("blackOrgIds", new Parameter("like", (Object)(InvocationInfoProxy.getOrgId() + "")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class);
        if (!Objects.equals(InvocationInfoProxy.getOrgType(), "1")) {
            records.forEach(supplier -> {
                QueryParam queryParam = QueryParam.getInstance();
                queryParam.getParams().put("supplyId", new Parameter("eq", (Object)supplier.getId()));
                queryParam.getParams().put("applyOrgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                queryParam.getParams().put("pushState", new Parameter("eq", (Object)"2"));
                List punishList = this.punishService.queryList(queryParam, false);
                if (ListUtil.isNotEmpty((List)punishList)) {
                    supplier.setGroupLastTime(((SupplierPunishEntity)((Object)((Object)punishList.get(0)))).getPunishLastTime());
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateAllSupplierGrade"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateAllSupplierGrade() {
        String msg = this.service.updateAllSupplierGrade(null);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u7b49\u7ea7\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/querySupplierByNameOrSocialCreditCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> querySupplierByNameOrSocialCreditCode(String supplierName, String socialCreditCode) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.querySupplierByNameOrSocialCreditCode(supplierName, socialCreditCode));
    }
}

