/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.ContractCheckEntity;
import com.ejianc.foundation.support.service.IContractCheckService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.WpsReturnCodeEnum;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import feign.Response;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/wpscb/"})
public class WpsCbkController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    @Value(value="${wps.domain}")
    private String wpsDomain;
    @Value(value="${wps.appId}")
    private String wpsAppId;
    @Value(value="${wps.appKey}")
    private String wpsAppKey;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${fileDownloadHost:#{NULL}}")
    private String DOWNLOAD_HOST;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private CacheManager cacheManager;
    private final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private final int TIME_OUT = 86400;
    @Autowired
    private IContractCheckService service;

    @GetMapping(value={"getUserToken"})
    public CommonResponse<String> getUserToken() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String cacheKey = InvocationInfoProxy.getUserid() + "::WpsUTK::" + sdf.format(new Date()) + "::WpsUTK::" + Md5Crypt.md5Crypt((byte[])InvocationInfoProxy.getToken().getBytes());
        this.cacheManager.setex(cacheKey, (Serializable)((Object)InvocationInfoProxy.getToken()), 86400);
        return CommonResponse.success((String)"\u83b7\u53d6\u7528\u6237wpsToken\u6210\u529f", (Object)cacheKey);
    }

    @GetMapping(value={"getWpsUrl"})
    public CommonResponse<JSONObject> getWpsUrl(@RequestParam(value="id") Long id) {
        ContractCheckEntity entity = (ContractCheckEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        JSONObject resp = new JSONObject();
        resp.put("appId", (Object)this.wpsAppId);
        resp.put("fileId", (Object)entity.getFileId());
        resp.put("token", this.getUserToken().getData());
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"v3/3rd/files/{fileId}"}, produces={"application/json;charset=UTF-8"})
    public Object getFileInfo(@PathVariable String fileId, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("\u8c03\u7528\u65b9\u6cd5getFileInfo v3/3rd/files/{fileId}  wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        ContractCheckEntity entity = this.service.getByFileId(fileId);
        if (null == entity) {
            entity = (ContractCheckEntity)((Object)this.service.selectById((Serializable)((Object)fileId)));
        }
        if (null == entity) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u6839\u636e\u6587\u4ef6Id\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        CommonResponse attachResp = this.attachmentApi.queryDetail(entity.getFileId().toString());
        if (!attachResp.isSuccess()) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u6839\u636e\u6587\u4ef6Id\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONObject resp = new JSONObject();
        resp.put("data", (Object)this.generateFileInfo((AttachmentVO)attachResp.getData()));
        this.logger.info("\u6839\u636e\u6587\u4ef6Id\uff0c\u8fd4\u56deWPS\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)resp.toJSONString());
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/download"}, produces={"application/json;charset=UTF-8"})
    public Object getFileDownloadInfo(@PathVariable String fileId, HttpServletRequest req) throws Exception {
        return this.getFileVersionDownloadInfo(fileId, null, req);
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/permission"}, produces={"application/json;charset=UTF-8"})
    public Object getUserPermission(@PathVariable String fileId, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("\u8c03\u7528\u65b9\u6cd5 getUserPermission v3/3rd/files/{fileId}/permission  wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        long userId = Long.parseLong(wpsToken.split("::WpsUTK::")[0]);
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u67e5\u8be2\u7528\u6237\u6743\u9650\u4fe1\u606f\u6210\u529f!");
        JSONObject data = new JSONObject();
        data.put("user_id", (Object)Long.toString(userId));
        data.put("read", (Object)1);
        data.put("update", (Object)1);
        data.put("download", (Object)1);
        data.put("rename", (Object)0);
        data.put("history", (Object)0);
        data.put("copy", (Object)0);
        data.put("print", (Object)0);
        data.put("saveas", (Object)0);
        data.put("comment", (Object)0);
        resp.put("data", (Object)data);
        this.logger.info("WPS \u7528\u6237\u6587\u4ef6\u6743\u9650\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)resp.toJSONString());
        return resp.toString();
    }

    private JSONObject generateFileInfo(AttachmentVO file) {
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("id", (Object)file.getId().toString());
        fileInfo.put("name", (Object)file.getFileName());
        fileInfo.put("version", (Object)file.getVersion());
        fileInfo.put("size", (Object)file.getFileSize());
        fileInfo.put("create_time", (Object)file.getCreateTime().getTime());
        fileInfo.put("modify_time", (Object)(null != file.getUpdateTime() ? file.getUpdateTime().getTime() : file.getCreateTime().getTime()));
        fileInfo.put("creator_id", (Object)file.getCreateUserCode());
        fileInfo.put("modifier_id", (Object)(null != file.getUpdateUserCode() ? file.getCreateUserCode() : file.getCreateUserCode()));
        this.changeUserCode2UserId(fileInfo);
        return fileInfo;
    }

    private void changeUserCode2UserId(JSONObject fileInfo) {
        HashSet<String> userCodes = new HashSet<String>();
        userCodes.add(fileInfo.getString("creator_id"));
        userCodes.add(fileInfo.getString("modifier_id"));
        if (!userCodes.isEmpty()) {
            CommonResponse userListResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userListResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u7528\u6237\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)userListResp));
            } else {
                List users = (List)userListResp.getData();
                if (!users.isEmpty()) {
                    Map<String, String> userCodeIdMap = users.stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item.getId().toString()));
                    if (userCodeIdMap.containsKey(fileInfo.getString("creator_id"))) {
                        fileInfo.put("creator_id", (Object)userCodeIdMap.get(fileInfo.getString("creator_id")));
                    }
                    if (userCodeIdMap.containsKey(fileInfo.getString("modifier_id"))) {
                        fileInfo.put("modifier_id", (Object)userCodeIdMap.get(fileInfo.getString("modifier_id")));
                    }
                }
            }
        }
    }

    private JSONObject checkWpsToken(String wpsToken) {
        String userToken;
        if (StringUtils.isBlank((String)wpsToken)) {
            this.logger.info("wpsToke\u4e3a\u7a7a\uff0c\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "token\u4fe1\u606f\u4e3a\u7a7a\uff0c\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String userId = wpsToken.split("::WpsUTK::")[0];
        String authority = this.checkOnLine(userId, userToken = (String)((Object)this.cacheManager.get(wpsToken)));
        if (null == authority) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u7528\u6237\u4f1a\u8bdd\u4fe1\u606f\u5931\u6548\uff01");
        }
        return this.getReturnMsg(WpsReturnCodeEnum.Success, "\u9a8c\u8bc1\u901a\u8fc7", authority);
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/versions"}, produces={"application/json;charset=UTF-8"})
    public Object getFileHistory(@PathVariable String fileId, @RequestParam Integer offset, @RequestParam Integer limit, HttpServletRequest req) {
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("\u8c03\u7528\u65b9\u6cd5getFileHistory v3/3rd/files/{fileId}/versions   wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        ArrayList<JSONObject> fileHistList = new ArrayList<JSONObject>();
        ContractCheckEntity billEditInfo = this.service.getByFileId(fileId);
        if (null == billEditInfo) {
            billEditInfo = (ContractCheckEntity)((Object)this.service.selectById(Long.valueOf(fileId)));
        }
        if (null == billEditInfo) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u6839\u636e\u6587\u4ef6Id\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashSet<String> userCodes = new HashSet<String>();
        CommonResponse attachResp = this.attachmentApi.queryDetail(billEditInfo.getFileId().toString());
        if (!attachResp.isSuccess()) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u6839\u636e\u6587\u4ef6Id\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        AttachmentVO attachmentVO = (AttachmentVO)attachResp.getData();
        JSONObject tmp = new JSONObject();
        tmp.put("id", (Object)billEditInfo.getId().toString());
        tmp.put("name", (Object)attachmentVO.getFileName());
        tmp.put("size", (Object)attachmentVO.getFileSize());
        tmp.put("version", (Object)attachmentVO.getVersion());
        tmp.put("create_time", (Object)attachmentVO.getCreateTime().getTime());
        tmp.put("modify_time", (Object)(null != attachmentVO.getUpdateTime() ? attachmentVO.getUpdateTime().getTime() : attachmentVO.getCreateTime().getTime()));
        tmp.put("creator_id", (Object)attachmentVO.getCreateUserCode());
        tmp.put("modifier_id", (Object)(null != attachmentVO.getUpdateUserCode() ? attachmentVO.getUpdateUserCode() : attachmentVO.getCreateUserCode()));
        userCodes.add(tmp.getString("creator_id"));
        userCodes.add(tmp.getString("modifier_id"));
        fileHistList.add(tmp);
        if (!userCodes.isEmpty()) {
            CommonResponse userListResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[0]));
            if (!userListResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u7528\u6237\u5217\u8868\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)userListResp));
            } else {
                List users = (List)userListResp.getData();
                if (!users.isEmpty()) {
                    Map<String, String> userCodeIdMap = users.stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item.getId().toString()));
                    fileHistList.stream().forEach(item -> {
                        if (userCodeIdMap.containsKey(item.getString("creator_id"))) {
                            item.put("creator_id", userCodeIdMap.get(item.getString("creator_id")));
                        }
                        if (userCodeIdMap.containsKey(item.getString("modifier_id"))) {
                            item.put("modifier_id", userCodeIdMap.get(item.getString("modifier_id")));
                        }
                    });
                }
            }
        }
        resp.put("data", fileHistList);
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/versions/{version}"}, produces={"application/json;charset=UTF-8"})
    public Object fileVersionInfo(@PathVariable String fileId, @PathVariable(value="version") Long version, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("\u8c03\u7528\u65b9\u6cd5fileVersionInfo v3/3rd/files/{fileId}/versions/{version} wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        JSONObject fileInfo = null;
        ContractCheckEntity billEditInfo = this.service.getByFileId(fileId);
        if (null == billEditInfo) {
            billEditInfo = (ContractCheckEntity)((Object)this.service.selectById(Long.valueOf(fileId)));
        }
        if (!(fileInfo = this.getFile(billEditInfo.getFileId().toString())).getBoolean("oprResult").booleanValue()) {
            fileInfo.remove((Object)"oprResult");
            return fileInfo;
        }
        fileInfo.remove((Object)"oprResult");
        fileInfo.put("id", (Object)fileId);
        this.changeUserCode2UserId(fileInfo);
        resp.put("data", (Object)fileInfo);
        this.logger.info("fileVersionInfo: {}", (Object)JSONObject.toJSONString((Object)resp));
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/users"}, produces={"application/json;charset=UTF-8"})
    public Object onLineUsersInfo(@RequestParam(value="user_ids") String[] userIds, HttpServletRequest req) {
        CommonResponse userResp;
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("\u8c03\u7528\u65b9\u6cd5onLineUsersInfo v3/3rd/users  wpsToken: {} userIds={}", (Object)wpsToken, (Object)userIds);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)checkToken.getString("data"));
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, null);
        JSONArray users = new JSONArray();
        if (null != userIds && userIds.length > 0) {
            userResp = this.userApi.queryListByIds(userIds);
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7528\u6237Id-{}\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25, msg-{}", (Object)userIds, (Object)userResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
        } else {
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u53c2\u6570\u7528\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        ((List)userResp.getData()).stream().forEach(user -> {
            JSONObject userInfo = new JSONObject();
            userInfo.put("id", (Object)user.getId().toString());
            userInfo.put("name", (Object)user.getUserName());
            userInfo.put("avatar_url", (Object)(StringUtils.isNotBlank((String)user.getAvator()) ? user.getAvator() : ""));
            users.add((Object)userInfo);
        });
        resp.put("data", (Object)users);
        return resp.toString();
    }

    private String checkOnLine(String userId, String token) {
        this.logger.info("wpscbk check user session online: userId-{}, token-{}", (Object)userId, (Object)token);
        boolean isOnline = this.sessionManager.validateOnlineSession(userId, token);
        if (isOnline) {
            return this.getAuthority(userId, token);
        }
        this.logger.info("wpscbk check user session invalid: userId-{}, token-{}", (Object)userId, (Object)token);
        return null;
    }

    private String getAuthority(String userId, String token) {
        try {
            String sid = "ICOP_SESSION_USER:" + userId;
            String userContextStr = this.sessionManager.getSessionCacheAttribute(sid, token);
            if (StringUtils.isNotBlank((String)userContextStr)) {
                UserContext userContext = (UserContext)JSONObject.parseObject((String)userContextStr, UserContext.class);
                this.logger.debug("wpscbk check user session online: userId-{}, token-{}, userContext-{}", new Object[]{userId, token, JSONObject.toJSONString((Object)userContext)});
                return "userType=" + userContext.getUserType() + ";userCode=" + URLEncoder.encode(userContext.getUserCode(), "UTF-8") + ";userName=" + URLEncoder.encode(userContext.getUserName(), "UTF-8") + ";orgId=" + userContext.getOrgId() + ";orgName=" + URLEncoder.encode(userContext.getOrgName(), "UTF-8") + ";tenantid=" + userContext.getTenantid() + ";token=" + userContext.getToken() + ";u_logints=" + userContext.getU_logints() + ";u_usercode=" + userContext.getU_usercode() + ";u_locale=" + userContext.getU_locale() + ";userId=" + userId;
            }
        }
        catch (Exception e) {
            this.logger.info("wpscbk check user session error: userId-{}, token-{}", new Object[]{userId, token, e});
            return null;
        }
        return null;
    }

    @PostMapping(value={"v3/3rd/files/{fileId}/upload"}, produces={"application/json;charset=UTF-8"})
    public Object saveFile(@PathVariable String fileId, @RequestParam(value="file") MultipartFile file, @RequestParam(value="name") String originalFileNameStr, @RequestParam(value="size") Integer size, @RequestParam(value="manual", required=false) boolean isManual, @RequestParam(value="attachment_size", required=false) Integer attachmentSize, @RequestParam(value="content_type", required=false) String contentType, @RequestParam(value="sha1", required=false) String sha1, HttpServletRequest req) {
        this.logger.info("\u8c03\u7528\u65b9\u6cd5saveFile \u63a5\u6536\u5230\u6a21\u677f\u4fdd\u5b58\u8bf7\u6c42\uff1afileId-{}, size-{}, isManual-{}, originalFileNameStr-{}, attachmentSize-{}, contentType-{},sha1-{}", new Object[]{fileId, size, isManual, originalFileNameStr, attachmentSize, contentType, sha1});
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        String authority = checkToken.getString("data");
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        ContractCheckEntity billEditInfo = this.service.getByFileId(fileId);
        if (null == billEditInfo) {
            billEditInfo = (ContractCheckEntity)((Object)this.service.selectById(Long.valueOf(fileId)));
        }
        if (null == billEditInfo) {
            return this.getReturnMsg(WpsReturnCodeEnum.NotExists, "\u4efb\u52a1\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceType", "ejc_contract_check");
        params.put("sourceId", billEditInfo.getId().toString());
        params.put("billType", "ejc_contract_check");
        params.put("originalFileNameStr", StringUtils.isNotBlank((String)originalFileNameStr) ? originalFileNameStr : file.getOriginalFilename());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", checkToken.getString("data"));
        AttachmentVO attachmentVO = null;
        try {
            String fileUploadRespStr = WpsCbkController.postFile(this.BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file);
            CommonResponse attachmentResp = (CommonResponse)JSONObject.parseObject((String)fileUploadRespStr, CommonResponse.class);
            if (!attachmentResp.isSuccess()) {
                this.logger.error("\u4fdd\u5b58 \u6587\u4ef6\u5931\u8d25 \uff0c\u539f\u56e0\uff1a{}", (Object)attachmentResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
            }
            attachmentVO = (AttachmentVO)((List)attachmentResp.getData()).get(0);
        }
        catch (Exception e) {
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
        }
        this.logger.info("\u6a21\u677f\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
        billEditInfo.setFileId(attachmentVO.getId());
        billEditInfo.setFileName(attachmentVO.getFileName());
        billEditInfo.setFilePath(attachmentVO.getOnlinePath());
        this.service.saveOrUpdate((Object)billEditInfo, false);
        resp.put("data", (Object)this.generateFileInfo(attachmentVO));
        return resp.toString();
    }

    @GetMapping(value={"v3/3rd/files/{fileId}/versions/{version}/download"}, produces={"application/json;charset=UTF-8"})
    public Object getFileVersionDownloadInfo(@PathVariable String fileId, @PathVariable String version, HttpServletRequest req) throws Exception {
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, "\u64cd\u4f5c\u6210\u529f\uff01");
        String wpsToken = req.getHeader("X-Weboffice-Token");
        this.logger.info("\u8c03\u7528\u65b9\u6cd5getFileVersionDownloadInfo v3/3rd/files/{fileId}/versions/{version}/download  wpsToken: {}", (Object)wpsToken);
        ContractCheckEntity billEditInfo = this.service.getByFileId(fileId);
        if (null == billEditInfo) {
            billEditInfo = (ContractCheckEntity)((Object)this.service.selectById(Long.valueOf(fileId)));
        }
        if (null == billEditInfo) {
            return this.getReturnMsg(WpsReturnCodeEnum.NotExists, "\u4efb\u52a1\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        String actualFileId = billEditInfo.getFileId().toString();
        JSONObject data = new JSONObject();
        data.put("url", (Object)((StringUtils.isNotBlank((String)this.DOWNLOAD_HOST) ? this.DOWNLOAD_HOST : this.BASE_HOST) + "ejc-support-web/wpscb/downloadFileByTmpId?fileId=" + actualFileId + "&wpsten=" + URLEncoder.encode(wpsToken, "UTF-8")));
        resp.put("data", (Object)data);
        this.logger.info("\u8fd4\u56deWPS\u6587\u6863\u4e0b\u8f7d\u4fe1\u606f\uff1a{}", (Object)resp.toJSONString());
        return resp.toString();
    }

    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)backState.getCode());
        resp.put("message", (Object)backState.getMessage());
        resp.put("details", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("hint", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("oprResult", (Object)false);
        return resp;
    }

    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg, Object data) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)backState.getCode());
        resp.put("message", (Object)backState.getMessage());
        resp.put("details", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("hint", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("oprResult", (Object)false);
        resp.put("data", data);
        return resp;
    }

    @GetMapping(value={"downloadFileByTmpId"})
    public void downloadFileByTmpId(@RequestParam(value="fileId") String fileId, @RequestParam(value="wpsten") String wpsten, HttpServletResponse response) throws Exception {
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6\u53c2\u6570\uff1afileId-{},wpsten-{}", (Object)fileId, (Object)wpsten);
        String wpsToken = URLDecoder.decode(wpsten, "UTF-8");
        this.logger.info("wpsToken: {}", (Object)wpsToken);
        JSONObject checkToken = this.checkWpsToken(wpsToken);
        if (0 != checkToken.getInteger("code")) {
            throw new BusinessException(checkToken.get((Object)"message").toString());
        }
        String authority = checkToken.getString("data");
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        ContractCheckEntity billEditInfo = this.service.getByFileId(fileId);
        if (null == billEditInfo) {
            billEditInfo = (ContractCheckEntity)((Object)this.service.selectById(Long.valueOf(fileId)));
        }
        if (null == billEditInfo) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6fileId-{} ", (Object)billEditInfo.getFileId());
        InputStream inputStream = null;
        try {
            Response fileResponse = this.attachmentApi.downloadFileById(billEditInfo.getFileId());
            Response.Body body = fileResponse.body();
            inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            response.setHeader("Content-Disposition", ((Collection)fileResponse.headers().get("Content-Disposition")).toString().replace("[", "").replace("]", ""));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int length = 0;
            byte[] temp = new byte[10240];
            while ((length = bufferedInputStream.read(temp)) != -1) {
                bufferedOutputStream.write(temp, 0, length);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JSONObject getFile(String fileId) {
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("oprResult", (Object)true);
        AttachmentVO file = null;
        CommonResponse attachmentResp = this.attachmentApi.queryDetail(fileId);
        if (!attachmentResp.isSuccess()) {
            fileInfo.put("oprResult", (Object)false);
            this.logger.error("\u6839\u636eId-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)fileId, (Object)attachmentResp.getMsg());
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6839\u636eId\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        file = (AttachmentVO)attachmentResp.getData();
        fileInfo.put("name", (Object)file.getFileName());
        fileInfo.put("version", (Object)file.getVersion());
        fileInfo.put("size", (Object)file.getFileSize());
        fileInfo.put("creator_id", (Object)file.getCreateUserCode());
        fileInfo.put("modifier_id", (Object)(null != file.getUpdateUserCode() ? file.getUpdateUserCode() : file.getCreateUserCode()));
        fileInfo.put("create_time", (Object)file.getCreateTime().getTime());
        fileInfo.put("modify_time", (Object)(null != file.getUpdateTime() ? file.getUpdateTime().getTime() : file.getCreateTime().getTime()));
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, MultipartFile file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 30000;
        Integer readTimeout = 30000;
        try {
            HttpResponse res;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file", file.getInputStream(), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getOriginalFilename());
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key2 = null;
                for (String key2 : headers.keySet()) {
                    post.addHeader(key2, headers.get(key2));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }
}

