package com.ejianc.foundation.support.controller;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("publish")
public class PublishController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${canPublish:false}")
    private Boolean canPublish;

    /**
     * 支撑中心相关平台节点是否具有发布按钮权限
     *
     * @return
     */
    @RequestMapping(value = "/canPublish", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> canPublish() {
        return CommonResponse.success("查询详情数据成功！",InvocationInfoProxy.getTenantid() == 999999L && canPublish != null && canPublish);
    }
}
