package com.ejianc.foundation.support.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;

public interface IFaruiService {
	/**
     * 合同审查-上传文档
     * 该接口用于将文档上传到合同审查模块中，添加成功之后，
     * 系统会自动启动文件的解析，并返回对应的文件id用于后续生成审查规则和审查结果。
     * 文件解析有排队机制，如果队列较长，文件可能需要等待一段时间才能解析完成
     * see  <a href="https://tyfarui.biz.aliyun.com/help/openApiJavaExample.url">...</a>
     * */
	CommonResponse<String> createTextFile( String filePath );
	/**
	 * 合同审查-生成规则
	 * 该接口用于合同审查模块的智能规则生成，调用大模型返回合同的审查规则和对应风险。传入合同审查文件的ID、审查立场，会通过sse的方式增量式返回模型生成的审查规则
	 * see  <a href="https://tyfarui.biz.aliyun.com/help/openApiJavaExample.url">...</a>
	 * */
	CommonResponse<JSONObject> generationContractRule( String fileId , String position);
	/**
	 * 合同审查-生成结果
	 * 该接口用于合同审查模块的审查结果生成，调用大模型返回合同的审查结果、审查风险项、建议修改内容等。传入合同审查文件的ID、审查立场、审查规则，
	 * 会通过sse的方式增量式返回模型生成的审查结果
	 * see  <a href="https://tyfarui.biz.aliyun.com/help/openApiJavaExample.url">...</a>
	 * */
	CommonResponse<JSONObject> generationContractResult(String fileId , String position,JSONObject ruleTasks);
}
