package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.service.farui20240628.AsyncClient;
import com.aliyun.sdk.service.farui20240628.models.RunContractRuleGenerationRequest;
import com.aliyun.sdk.service.farui20240628.models.RunContractRuleGenerationResponseBody;
import darabonba.core.RequestConfiguration;
import darabonba.core.ResponseIterable;
import darabonba.core.ResponseIterator;
import darabonba.core.client.ClientOverrideConfiguration;

import java.time.Duration;
import com.aliyun.farui20240628.Client;
import com.aliyun.farui20240628.models.CreateTextFileAdvanceRequest;
import com.aliyun.farui20240628.models.CreateTextFileResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class RunContractRuleGeneration {
    private static String accessKeyId = "LTAI5tJa66Bu3Ar6hGtFuXCX";
    private static String accessKeySecret= "6cPu26lwfefb2gKQP8KUgdGLpZKoOH";
    private static String endpoint = "farui.cn-beijing.aliyuncs.com";
    private static String workspaceId = "llm-8f400hpnfstvw4v7";
    public static void main(String[] args) throws Exception {
        String filePath = "E:\\download\\宁蒗项目混凝土合同.docx";
        String fileId = RunContractRuleGeneration.CreateTextFile(filePath);
        if(fileId!=null){
            System.out.println("开始调用ruleGeneration---------------------------------------------------------");
           RunContractRuleGeneration.ruleGeneration(fileId);
        }
    }
    public static void ruleGeneration(String fileId) throws Exception {
        StaticCredentialProvider provider = StaticCredentialProvider.create(
                Credential.builder()
                        .accessKeyId(accessKeyId)
                        .accessKeySecret(accessKeySecret)
                        .build()
        );

        AsyncClient clientAs = AsyncClient.builder()// Region ID
                .credentialsProvider(provider)
                // Service-level configuration
                .serviceConfiguration(Configuration.create()
                        .setSignatureVersion(SignatureVersion.V3)
                )
                // Client-level configuration rewrite, can set Endpoint, Http request parameters, etc.
                .overrideConfiguration(
                        ClientOverrideConfiguration.create()
                                .setProtocol("HTTPS")
                                .setEndpointOverride(endpoint)
                )
                .build();

        RunContractRuleGenerationRequest.MetaData metaData = RunContractRuleGenerationRequest.MetaData.builder()
                .fileId(fileId).position("1").build();

        RunContractRuleGenerationRequest.Assistant ruleAssistant = RunContractRuleGenerationRequest.Assistant.builder()
                .type("contract_examime")
                .version("1")
                .metaData(metaData)
                .build();

        RequestConfiguration requestConfiguration = RequestConfiguration.create()
                .setConnectTimeout(Duration.ofSeconds(3*60))
                .setResponseTimeout(Duration.ofSeconds(3*60));

        RunContractRuleGenerationRequest runContractRuleGenerationRequest = RunContractRuleGenerationRequest.builder()
                .appId("farui")
                .stream(true)
                .workspaceId(workspaceId).requestConfiguration(requestConfiguration)
                .assistant(ruleAssistant)
                .build();

        ResponseIterable<RunContractRuleGenerationResponseBody> x = clientAs.runContractRuleGenerationWithResponseIterable(runContractRuleGenerationRequest);

        ResponseIterator<RunContractRuleGenerationResponseBody> iterator = x.iterator();
        while (iterator.hasNext()) {
            RunContractRuleGenerationResponseBody event = iterator.next();
            if(event.getSuccess()){
                System.out.println("调用成功--event.getOutput()----"+ JSONObject.toJSONString(event.getOutput()));
                if (event.getOutput().getRuleTaskId()!=null) {
                    System.out.println(event.getOutput().getRuleTaskId());
                }
                if (event.getOutput().getRules()!=null && event.getOutput().getRules().size()>0) {
                    System.out.println(event.getOutput().getRules().get(0).getRuleSequence());
                    System.out.println(event.getOutput().getRules().get(0).getRuleTag());
                    System.out.println(event.getOutput().getRules().get(0).getRuleTitle());
                    System.out.println(event.getOutput().getRules().get(0).getRiskLevel());
                }
            }else {
                System.out.println("调用失败--event.getMessage()----"+JSONObject.toJSONString(event));
            }
        }
    }
    public static String CreateTextFile(String filePath) throws Exception {

        Config config = new Config()
                .setAccessKeyId(accessKeyId)
                .setAccessKeySecret(accessKeySecret)
                .setEndpoint(endpoint)
                .setProtocol("HTTPS");

        Client client = new Client(config);

        CreateTextFileAdvanceRequest createFileAdvanceRequest = new CreateTextFileAdvanceRequest();

        File file = new File(filePath);
        createFileAdvanceRequest.setTextFileName(file.getName()).setTextFileUrlObject(Files.newInputStream(file.toPath()));
        RuntimeOptions runtime = new RuntimeOptions();
        Map<String, String> headers = new HashMap();
        CreateTextFileResponse createFileResponse = client.createTextFileAdvance(workspaceId, createFileAdvanceRequest, headers, runtime);

        System.out.println(createFileResponse.getStatusCode());
        if (createFileResponse.getStatusCode().equals(200)) {
            String fileId = createFileResponse.getBody().getData().getTextFileId();
            System.out.println("CreateTextFile 返回的文件id--------"+fileId);
            return fileId;
        }else {
            System.out.println("CreateTextFile 调用失败--------"+JSONObject.toJSONString(createFileResponse));
        }
        return null;
    }
}
