/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.bean.ContractCheckEntity;
import com.ejianc.foundation.support.service.IContractCheckService;
import com.ejianc.foundation.support.service.IFaruiService;
import com.ejianc.foundation.support.vo.ContractCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contractCheck"})
public class ContractCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractCheckService service;
    @Autowired
    private IFaruiService faruiService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractCheckVO> saveOrUpdate(@RequestBody ContractCheckVO saveOrUpdateVO) {
        ContractCheckEntity entity = (ContractCheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractCheckEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getLogVersion())) {
            entity.setLogVersion("V1");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ContractCheckVO vo = (ContractCheckVO)BeanMapper.map((Object)((Object)entity), ContractCheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractCheckVO> queryDetail(Long id) {
        ContractCheckEntity entity = (ContractCheckEntity)((Object)this.service.selectById(id));
        ContractCheckVO vo = (ContractCheckVO)BeanMapper.map((Object)((Object)entity), ContractCheckVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractCheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractCheckVO contractCheckVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractCheck-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractCheckVO>> refContractCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"pushToFarui"})
    @ResponseBody
    public CommonResponse<String> pushToFarui(String id) {
        ContractCheckEntity entity = (ContractCheckEntity)((Object)this.service.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return CommonResponse.error((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        CommonResponse<String> response = this.faruiService.createTextFile(entity.getFilePath());
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u63a8\u9001\u5931\u8d25\uff01" + response.getMsg()));
        }
        entity.setTextFileId((String)response.getData());
        entity.setState(1);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"generationRule"})
    @ResponseBody
    public CommonResponse<String> generationRule(String id) {
        ContractCheckEntity entity = (ContractCheckEntity)((Object)this.service.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return CommonResponse.error((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        CommonResponse<JSONObject> response = this.faruiService.generationContractRule(entity.getTextFileId(), entity.getPosition() + "");
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u63a8\u9001\u5931\u8d25\uff01" + response.getMsg()));
        }
        entity.setRuleResult(JSONObject.toJSONString((Object)response.getData()));
        entity.setState(2);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"generationContractResult"})
    @ResponseBody
    public CommonResponse<String> generationContractResult(String id) {
        ContractCheckEntity entity = (ContractCheckEntity)((Object)this.service.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return CommonResponse.error((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((CharSequence)entity.getRuleResult())) {
            return CommonResponse.error((String)"\u8bf7\u5148\u751f\u6210\u89c4\u5219\uff01");
        }
        CommonResponse<JSONObject> response = this.faruiService.generationContractResult(entity.getTextFileId(), entity.getPosition() + "", JSONObject.parseObject((String)entity.getRuleResult()));
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u63a8\u9001\u5931\u8d25\uff01" + response.getMsg()));
        }
        entity.setRuleResult(JSONObject.toJSONString((Object)response.getData()));
        entity.setState(2);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01");
    }
}

