/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.farui20240628.Client;
import com.aliyun.farui20240628.models.CreateTextFileAdvanceRequest;
import com.aliyun.farui20240628.models.CreateTextFileResponse;
import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.service.farui20240628.AsyncClient;
import com.aliyun.sdk.service.farui20240628.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.farui20240628.models.RunContractResultGenerationRequest;
import com.aliyun.sdk.service.farui20240628.models.RunContractResultGenerationResponseBody;
import com.aliyun.sdk.service.farui20240628.models.RunContractRuleGenerationRequest;
import com.aliyun.sdk.service.farui20240628.models.RunContractRuleGenerationResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ejianc.foundation.support.service.IFaruiService;
import com.ejianc.framework.core.response.CommonResponse;
import darabonba.core.RequestConfiguration;
import darabonba.core.ResponseIterable;
import darabonba.core.ResponseIterator;
import darabonba.core.client.ClientOverrideConfiguration;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FaruiServiceImpl
implements IFaruiService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${farui.accessKeyId}")
    private String accessKeyId;
    @Value(value="${farui.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${farui.endpoint}")
    private String endpoint;
    @Value(value="${farui.workspaceId}")
    private String workspaceId;

    @Override
    public CommonResponse<String> createTextFile(String filePath) {
        this.logger.info("filePath :{} accessKeyId:{}  workspaceId:{}  endpoint:{}", new Object[]{filePath, this.accessKeyId, this.workspaceId, this.endpoint});
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret).setEndpoint(this.endpoint).setProtocol("HTTPS");
        Client client = null;
        try {
            client = new Client(config);
            CreateTextFileAdvanceRequest createFileAdvanceRequest = new CreateTextFileAdvanceRequest();
            URL url = new URL(filePath);
            String fileName = Paths.get(url.getPath(), new String[0]).getFileName().toString();
            createFileAdvanceRequest.setTextFileName(fileName).setTextFileUrlObject(url.openStream());
            RuntimeOptions runtime = new RuntimeOptions();
            HashMap headers = new HashMap();
            CreateTextFileResponse createFileResponse = client.createTextFileAdvance(this.workspaceId, createFileAdvanceRequest, headers, runtime);
            if (createFileResponse.getStatusCode().equals(200)) {
                this.logger.info("\u4e0a\u4f20\u8fd4\u56de\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)createFileResponse.getBody().getData()));
                if (createFileResponse.getBody().getData().getTextFileId() != null) {
                    return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01", (Object)createFileResponse.getBody().getData().getTextFileId());
                }
            } else {
                this.logger.info("\u4e0a\u4f20\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)createFileResponse));
            }
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return CommonResponse.error((String)"\u4e0a\u4f20\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<JSONObject> generationContractRule(String fileId, String position) {
        this.logger.info("\u5408\u540c\u5ba1\u67e5-\u751f\u6210\u89c4\u5219\u53c2\u6570\uff1afileId :{} position:{}  accessKeyId:{} workspaceId:{}  endpoint:{}", new Object[]{fileId, position, this.accessKeyId, this.workspaceId, this.endpoint});
        try {
            StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(this.accessKeyId).accessKeySecret(this.accessKeySecret).build());
            AsyncClient clientAs = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().credentialsProvider((ICredentialProvider)provider)).serviceConfiguration(Configuration.create().setSignatureVersion(SignatureVersion.V3))).overrideConfiguration(ClientOverrideConfiguration.create().setProtocol("HTTPS").setEndpointOverride(this.endpoint))).build();
            RunContractRuleGenerationRequest.MetaData metaData = RunContractRuleGenerationRequest.MetaData.builder().fileId(fileId).position(position).build();
            RunContractRuleGenerationRequest.Assistant ruleAssistant = RunContractRuleGenerationRequest.Assistant.builder().type("contract_examime").version("1").metaData(metaData).build();
            RequestConfiguration requestConfiguration = RequestConfiguration.create().setConnectTimeout(Duration.ofSeconds(180L)).setResponseTimeout(Duration.ofSeconds(180L));
            RunContractRuleGenerationRequest runContractRuleGenerationRequest = ((RunContractRuleGenerationRequest.Builder)RunContractRuleGenerationRequest.builder().appId("farui").stream(Boolean.valueOf(true)).workspaceId(this.workspaceId).requestConfiguration(requestConfiguration)).assistant(ruleAssistant).build();
            ResponseIterable x = clientAs.runContractRuleGenerationWithResponseIterable(runContractRuleGenerationRequest);
            ResponseIterator iterator = x.iterator();
            JSONObject jsonObject = new JSONObject();
            JSONArray rules = new JSONArray();
            while (iterator.hasNext()) {
                this.logger.info("--generationContractRule--event----");
                RunContractRuleGenerationResponseBody event = (RunContractRuleGenerationResponseBody)iterator.next();
                if (event.getSuccess().booleanValue()) {
                    this.logger.info("event.getOutput().getRules()==" + JSONObject.toJSONString((Object)event.getOutput()));
                    if (event.getOutput().getRuleTaskId() != null) {
                        jsonObject.put("ruleTaskId", (Object)event.getOutput().getRuleTaskId());
                    }
                    if (event.getOutput().getRules() == null || event.getOutput().getRules().isEmpty()) continue;
                    JSONObject role = new JSONObject();
                    role.put("ruleSequence", (Object)((RunContractRuleGenerationResponseBody.Rules)event.getOutput().getRules().get(0)).getRuleSequence());
                    role.put("ruleTag", (Object)((RunContractRuleGenerationResponseBody.Rules)event.getOutput().getRules().get(0)).getRuleTag());
                    role.put("ruleTitle", (Object)((RunContractRuleGenerationResponseBody.Rules)event.getOutput().getRules().get(0)).getRuleTitle());
                    role.put("riskLevel", (Object)((RunContractRuleGenerationResponseBody.Rules)event.getOutput().getRules().get(0)).getRiskLevel());
                    rules.add((Object)role);
                    continue;
                }
                this.logger.info("\u751f\u6210\u89c4\u5219\u5931\u8d25\uff01event.getOutput().getRules()==" + JSONObject.toJSONString((Object)event));
            }
            if (!rules.isEmpty()) {
                jsonObject.put("rules", (Object)rules);
                return CommonResponse.success((Object)jsonObject);
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u751f\u6210\u89c4\u5219\u5931\u8d25\uff01" + e.getMessage()));
        }
        return CommonResponse.error((String)"\u751f\u6210\u89c4\u5219\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<JSONObject> generationContractResult(String fileId, String position, JSONObject ruleTasks) {
        if (ruleTasks == null) {
            return CommonResponse.error((String)"\u751f\u6210\u7ed3\u679c\u5931\u8d25\uff01\u89c4\u5219\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        try {
            String ruleTaskId = ruleTasks.getString("ruleTaskId");
            if (StringUtils.isEmpty((String)ruleTaskId)) {
                return CommonResponse.error((String)"\u751f\u6210\u7ed3\u679c\u5931\u8d25\uff01\u89c4\u5219\u4efb\u52a1ID\u4e3a\u7a7a\uff01");
            }
            StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(this.accessKeyId).accessKeySecret(this.accessKeySecret).build());
            AsyncClient client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().credentialsProvider((ICredentialProvider)provider)).serviceConfiguration(Configuration.create().setSignatureVersion(SignatureVersion.V3))).overrideConfiguration(ClientOverrideConfiguration.create().setProtocol("HTTPS").setEndpointOverride(this.endpoint))).build();
            JSONArray ruleArr = ruleTasks.getJSONArray("rules");
            if (ruleArr == null || ruleArr.isEmpty()) {
                return CommonResponse.error((String)"\u751f\u6210\u7ed3\u679c\u5931\u8d25\uff01\u89c4\u5219\u5217\u8868\u4e3a\u7a7a\uff01");
            }
            ArrayList<RunContractResultGenerationRequest.Rules> rules = new ArrayList<RunContractResultGenerationRequest.Rules>();
            for (Object o : ruleArr) {
                JSONObject ruleObject = (JSONObject)o;
                RunContractResultGenerationRequest.Rules rule = RunContractResultGenerationRequest.Rules.builder().ruleSequence(ruleObject.getString("ruleSequence")).ruleTag(ruleObject.getString("ruleTag")).ruleTitle(ruleObject.getString("ruleTitle")).riskLevel(ruleObject.getString("riskLevel")).build();
                rules.add(rule);
            }
            RunContractResultGenerationRequest.MetaData metaData = RunContractResultGenerationRequest.MetaData.builder().fileId(fileId).position(position).ruleTaskId(ruleTaskId).rules(rules).build();
            RunContractResultGenerationRequest.Assistant assistant = RunContractResultGenerationRequest.Assistant.builder().type("contract_examime").metaData(metaData).version("1").build();
            RunContractResultGenerationRequest request = RunContractResultGenerationRequest.builder().appId("farui").stream(Boolean.valueOf(true)).workspaceId(this.workspaceId).assistant(assistant).build();
            ResponseIterable x = client.runContractResultGenerationWithResponseIterable(request);
            ResponseIterator iterator = x.iterator();
            while (iterator.hasNext()) {
                this.logger.info("----event----");
                RunContractResultGenerationResponseBody event = (RunContractResultGenerationResponseBody)iterator.next();
                if (!event.getSuccess().booleanValue()) continue;
                this.logger.info(event.toMap().toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

