package com.ejianc.foundation.support.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.ContractCheckEntity;
import com.ejianc.foundation.support.service.IContractCheckService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.WpsReturnCodeEnum;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import feign.Response;
import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * wps回调服务控制器
 *
 * @author CJ
 * @Description: wps回调服务控制器
 * @date 2021/11/10 15:35
 */
@RestController
@RequestMapping("/wpscb/")
public class WpsCbkController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired

    @Value("${wps.domain}")
    private String wpsDomain;

    @Value("${wps.appId}")
    private String wpsAppId;

    @Value("${wps.appKey}")
    private String wpsAppKey;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${fileDownloadHost:#{NULL}}")
    private String DOWNLOAD_HOST;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private CacheManager cacheManager;

    private final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private final int TIME_OUT = 60 * 60 * 24;

    @Autowired
    private IContractCheckService service;


    @GetMapping(value = "getUserToken")
    public CommonResponse<String> getUserToken() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        String cacheKey = InvocationInfoProxy.getUserid() +
                "::WpsUTK::"+sdf.format(new Date()) + "::WpsUTK::" +Md5Crypt.md5Crypt(InvocationInfoProxy.getToken().getBytes());
        cacheManager.setex(cacheKey, InvocationInfoProxy.getToken(), TIME_OUT);
        return CommonResponse.success("获取用户wpsToken成功", cacheKey);
    }


    /**
     * 拼接wps初始化 文件访问url信息
     *
     * @param id Id
     * @return
     */
    @GetMapping(value = "getWpsUrl")
    public CommonResponse<JSONObject> getWpsUrl(@RequestParam(value = "id") Long id) {
        ContractCheckEntity entity = service.selectById(id);
        if(entity == null){
            return CommonResponse.error("任务不存在");
        }
        JSONObject resp = new JSONObject();
        resp.put("appId", wpsAppId);
        resp.put("fileId", entity.getFileId());
        resp.put("token", getUserToken().getData());
        return CommonResponse.success(resp);
    }


    /**
     * 根据文件Id获取文件信息
     *
     * @param fileId
     * @param req
     * @return
     */
    @GetMapping(value = "v3/3rd/files/{fileId}", produces = { "application/json;charset=UTF-8" })
    public Object getFileInfo(@PathVariable String fileId, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("调用方法getFileInfo v3/3rd/files/{fileId}  wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        ContractCheckEntity entity = service.getByFileId(fileId);
        if(null == entity) {
            entity = service.selectById(fileId);
        }
        if(null == entity){
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "根据文件Id获取文件信息失败！");
        }
        InvocationInfoProxy.setExtendAttribute("authority", checkToken.getString("data"));
        CommonResponse<AttachmentVO> attachResp = attachmentApi.queryDetail(entity.getFileId().toString());
        if(!attachResp.isSuccess()) {
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "根据文件Id获取文件信息失败！");
        }
        JSONObject resp = new JSONObject();
        resp.put("data", generateFileInfo(attachResp.getData()));
        logger.info("根据文件Id，返回WPS文件信息：{}", resp.toJSONString());
        return resp.toString();
    }


    /**
     * 根据文件Id获取文件信息
     *
     * @param fileId
     * @param req
     * @return
     */
    @GetMapping(value = "v3/3rd/files/{fileId}/download", produces = { "application/json;charset=UTF-8" })
    public Object getFileDownloadInfo(@PathVariable String fileId, HttpServletRequest req) throws Exception {
       return getFileVersionDownloadInfo(fileId, null, req);
    }

    @GetMapping(value = "v3/3rd/files/{fileId}/permission", produces = { "application/json;charset=UTF-8" })
    public Object getUserPermission(@PathVariable String fileId, HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("调用方法 getUserPermission v3/3rd/files/{fileId}/permission  wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute("authority", checkToken.getString("data"));

        long userId = Long.parseLong(wpsToken.split("::WpsUTK::")[0]);

        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "查询用户权限信息成功!");
        JSONObject data = new JSONObject();
        data.put("user_id", Long.toString(userId)); //此处返回userCode调整为userId因为如果userCode中含有非数字 字母wps会报错
        data.put("read", 1); //是否具有预览权限，0-无 1-有
        data.put("update", 1); //是否具有编辑权限，0-无 1-有
        data.put("download", 1); //是否具有下载文档权限，0-无 1-有
        data.put("rename", 0); //是否具有重命名文档权限，0-无 1-有
        data.put("history", 0);//是否具有查看文档历史记录权限，0-无 1-有
        data.put("copy", 0);//是否具有拷贝文档内容权限，0-无 1-有
        data.put("print", 0);//是否具有打印文档权限，0-无 1-有
        data.put("saveas", 0);//是否具有另存当前文档权限，0-无 1-有
        data.put("comment", 0);//是否具有评论文档权限，0-无 1-有
        resp.put("data", data);
        logger.info("WPS 用户文件权限返回信息：{}", resp.toJSONString());
        return resp.toString();
    }

    private JSONObject generateFileInfo(AttachmentVO file) {
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("id", file.getId().toString());
        fileInfo.put("name", file.getFileName());
        fileInfo.put("version", file.getVersion());
        fileInfo.put("size", file.getFileSize());
        fileInfo.put("create_time", file.getCreateTime().getTime());
        fileInfo.put("modify_time", null != file.getUpdateTime() ? file.getUpdateTime().getTime() : file.getCreateTime().getTime());
        fileInfo.put("creator_id", file.getCreateUserCode());
        fileInfo.put("modifier_id", null != file.getUpdateUserCode() ? file.getCreateUserCode() : file.getCreateUserCode());

        changeUserCode2UserId(fileInfo);

        return fileInfo;
    }

    private void changeUserCode2UserId(JSONObject fileInfo) {
        Set<String> userCodes = new HashSet<>();
        userCodes.add(fileInfo.getString("creator_id"));
        userCodes.add(fileInfo.getString("modifier_id"));
        if(!userCodes.isEmpty()) {
            CommonResponse<List<UserVO>> userListResp = userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if(!userListResp.isSuccess()) {
                logger.error("查询用户列表信息失败，{}", JSONObject.toJSONString(userListResp));
            } else {
                List<UserVO> users = userListResp.getData();
                if(!users.isEmpty()) {
                    Map<String, String> userCodeIdMap = users.stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item.getId().toString()));
                    if(userCodeIdMap.containsKey(fileInfo.getString("creator_id"))) {
                        fileInfo.put("creator_id", userCodeIdMap.get(fileInfo.getString("creator_id")));
                    }
                    if(userCodeIdMap.containsKey(fileInfo.getString("modifier_id"))) {
                        fileInfo.put("modifier_id", userCodeIdMap.get(fileInfo.getString("modifier_id")));
                    }
                }
            }
        }
    }


    private JSONObject checkWpsToken(String wpsToken) {
        if(StringUtils.isBlank(wpsToken)) {
            logger.info("wpsToke为空，获取文件信息失败！");
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "token信息为空，获取文件信息失败！");
        }
        String userId = wpsToken.split("::WpsUTK::")[0];
        String userToken = cacheManager.get(wpsToken);

        String authority = checkOnLine(userId, userToken);
        if(null == authority) {
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "用户会话信息失效！");
        }
        return getReturnMsg(WpsReturnCodeEnum.Success, "验证通过", authority);
    }

    /**
     * 获取当前文档所有历史版本的文件信息
     *
     * @param fileId 实际附件Id
     * @return
     */
    @GetMapping(value = "v3/3rd/files/{fileId}/versions", produces = { "application/json;charset=UTF-8" })
    public Object getFileHistory(@PathVariable String fileId,
                                 @RequestParam Integer offset,
                                 @RequestParam Integer limit,
                                 HttpServletRequest req) {
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");

        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("调用方法getFileHistory v3/3rd/files/{fileId}/versions   wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute("authority", checkToken.getString("data"));
        List<JSONObject> fileHistList = new ArrayList<>();

        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo  = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo){
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "根据文件Id获取文件信息失败！");
        }
        Set<String> userCodes = new HashSet<>();
        CommonResponse<AttachmentVO> attachResp = attachmentApi.queryDetail(billEditInfo.getFileId().toString());
        if(!attachResp.isSuccess()) {
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "根据文件Id获取文件信息失败！");
        }
        AttachmentVO attachmentVO = attachResp.getData();
        JSONObject tmp = new JSONObject();
        tmp.put("id", billEditInfo.getId().toString());
        tmp.put("name", attachmentVO.getFileName());
        tmp.put("size", attachmentVO.getFileSize());
        tmp.put("version", attachmentVO.getVersion());
        tmp.put("create_time", attachmentVO.getCreateTime().getTime());
        tmp.put("modify_time", null != attachmentVO.getUpdateTime() ? attachmentVO.getUpdateTime().getTime() : attachmentVO.getCreateTime().getTime());
        tmp.put("creator_id", attachmentVO.getCreateUserCode());
        tmp.put("modifier_id", null != attachmentVO.getUpdateUserCode() ? attachmentVO.getUpdateUserCode() : attachmentVO.getCreateUserCode());
        userCodes.add(tmp.getString("creator_id"));
        userCodes.add(tmp.getString("modifier_id"));
        fileHistList.add(tmp);

        if(!userCodes.isEmpty()) {
            CommonResponse<List<UserVO>> userListResp = userApi.queryUserByUserCodes(userCodes.toArray(new String[0]));
            if(!userListResp.isSuccess()) {
                logger.error("查询用户列表信息失败，{}", JSONObject.toJSONString(userListResp));
            } else {
                List<UserVO> users = userListResp.getData();
                if(!users.isEmpty()) {
                    Map<String, String> userCodeIdMap = users.stream().collect(Collectors.toMap(UserVO::getUserCode, item -> item.getId().toString()));
                    fileHistList.stream().forEach(item -> {
                        if(userCodeIdMap.containsKey(item.getString("creator_id"))) {
                            item.put("creator_id", userCodeIdMap.get(item.getString("creator_id")));
                        }
                        if(userCodeIdMap.containsKey(item.getString("modifier_id"))) {
                            item.put("modifier_id", userCodeIdMap.get(item.getString("modifier_id")));
                        }
                    });
                }
            }
        }

        resp.put("data", fileHistList);

        return resp.toString();
    }

    /**
     * 根据指定文件信息
     *
     * @param version 版本号
     * @param fileId 实际附件Id
     * @return
     * @throws Exception
     */
    @GetMapping(value = "v3/3rd/files/{fileId}/versions/{version}", produces = { "application/json;charset=UTF-8" })
    public Object fileVersionInfo(@PathVariable String fileId,
                                  @PathVariable("version") Long version,
                                  HttpServletRequest req) {

        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("调用方法fileVersionInfo v3/3rd/files/{fileId}/versions/{version} wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute("authority", checkToken.getString("data"));
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");
        //文件信息
        JSONObject fileInfo = null;

        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        fileInfo = getFile(billEditInfo.getFileId().toString());

        if(!fileInfo.getBoolean("oprResult")) {
            //获取文件信息失败
            fileInfo.remove("oprResult");
            return fileInfo;
        }
        fileInfo.remove("oprResult");

        //文件Id,字符串长度小于40，和 URL 中的fileid必须一致
        fileInfo.put("id", fileId);

        changeUserCode2UserId(fileInfo);
        resp.put("data", fileInfo);
        logger.info("fileVersionInfo: {}", JSONObject.toJSONString(resp));
        return resp.toString();
    }


    @GetMapping(value = "v3/3rd/users", produces = { "application/json;charset=UTF-8" })
    public Object onLineUsersInfo(@RequestParam(value = "user_ids") String[] userIds,
                                  HttpServletRequest req) {
        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("调用方法onLineUsersInfo v3/3rd/users  wpsToken: {} userIds={}", wpsToken,userIds);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        InvocationInfoProxy.setExtendAttribute("authority", checkToken.getString("data"));

        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, null);
        JSONArray users = new JSONArray();

        if(null != userIds && userIds.length > 0) {
            CommonResponse<List<UserVO>> userResp = userApi.queryListByIds(userIds);
            if(!userResp.isSuccess()) {
                logger.error("根据用户Id-{}查询用户信息失败, msg-{}", userIds, userResp.getMsg());
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "获取用户信息失败！");
            } else {
                userResp.getData().stream().forEach(user -> {
                    JSONObject userInfo = new JSONObject();
                    //用户id
                    userInfo.put("id", user.getId().toString());
                    //用户名称
                    userInfo.put("name", user.getUserName());
                    //用户头像
                    userInfo.put("avatar_url", StringUtils.isNotBlank(user.getAvator()) ? user.getAvator() : "");
                    users.add(userInfo);
                });
            }
        } else {
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "参数用户Id列表为空！");
        }
        resp.put("data", users);
        return resp.toString();
    }

    private String checkOnLine(String userId, String token) {
        logger.info("wpscbk check user session online: userId-{}, token-{}", userId, token);
        boolean isOnline = sessionManager.validateOnlineSession(userId, token);
        if(isOnline) {
           return getAuthority(userId, token);
        }
        logger.info("wpscbk check user session invalid: userId-{}, token-{}", userId, token);
        return  null;
    }

    private String getAuthority(String userId, String token) {
        try {
            String sid = SESSION_PREFIX + userId;
            String userContextStr = sessionManager.getSessionCacheAttribute(sid, token);
            if(StringUtils.isNotBlank(userContextStr)) {
                UserContext userContext = JSONObject.parseObject(userContextStr, UserContext.class);

                logger.debug("wpscbk check user session online: userId-{}, token-{}, userContext-{}", userId, token, JSONObject.toJSONString(userContext));
                return "userType="+userContext.getUserType() +
                        ";userCode="+URLEncoder.encode(userContext.getUserCode(), "UTF-8") +
                        ";userName="+URLEncoder.encode(userContext.getUserName(), "UTF-8") +
                        ";orgId="+userContext.getOrgId() +
                        ";orgName="+URLEncoder.encode(userContext.getOrgName(),"UTF-8") +
                        ";tenantid="+userContext.getTenantid() +
                        ";token="+userContext.getToken() +
                        ";u_logints="+userContext.getU_logints() +
                        ";u_usercode="+userContext.getU_usercode() +
                        ";u_locale="+userContext.getU_locale() +
                        ";userId="+userId;
            }
        } catch (Exception e) {
            logger.info("wpscbk check user session error: userId-{}, token-{}", userId, token, e);
            return null;
        }
        return null;
    }

    /**
     * 三段提交第一阶段
     * 准备上传阶段
     * 说明：三阶段保存的第一步主要用于 WebOffice 与接入方进行参数协商，目前主要协商摘要算法。
     *
     * 接口: GET /v3/3rd/files/:file_id/upload/prepare
     * @return
     */
    @GetMapping(value = "v3/3rd/files/{fileId}/upload/prepare", produces = { "application/json;charset=UTF-8" })
    public Object prepare(@PathVariable String fileId, HttpServletRequest req) {
        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo) {
            return getReturnMsg(WpsReturnCodeEnum.NotExists, "任务单据不存在！");
        }
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");
        JSONObject data = new JSONObject();
        data.put("digest_types",new String[]{"md5"});
        resp.put("data", data);
        return resp.toString();
    }


    /**
     * 三段提交第二阶段
     * 获取上传地址
     * 接口: POST /v3/3rd/files/:file_id/upload/address
     * 字段	位置	必须	类型	说明
     * file_id	Path	是	string	文档 ID
     * name	Body	是	string	文档名称
     * size	Body	是	integer	文档大小，单位 byte
     * digest	Body	是	map<string, string>	文档校验和，key 为算法，value 为结果值
     * is_manual	Body	是	boolean	是否手动保存，即用户手动 ctrl/cmd + s 或点击保存版本触发的保存，区别于定时触发的自动保存
     * attachment_size	Body	否	integer	文档内包含的附件的大小，单位 byte
     * content_type	Body	否	string	文档的 MIME 类型
     * 说明：三阶段保存第二步主要用于获取上传地址，WebOffice 将上传保存后的文档到该地址。此外，回调中也会带上本次保存的一些额外信息，如文档大小，手动/自动保存等。
     * @return
     */
    @PostMapping(value = "v3/3rd/files/{fileId}/upload/address", produces = { "application/json;charset=UTF-8" })
    public Object address(@PathVariable String fileId,@RequestBody JSONObject param, HttpServletRequest req) {
        logger.info("wpscbk upload address: fileId-{}, param-{}", fileId, param);
        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo) {
            return getReturnMsg(WpsReturnCodeEnum.NotExists, "任务单据不存在！");
        }
        Map<String,String> params = new HashMap<>();
        params.put("sourceType", "ejc_contract_check");
        params.put("sourceId", billEditInfo.getId().toString());
        params.put("billType", "ejc_contract_check");
        params.put("originalFileNameStr", param.getString("name"));
        Map<String,String> headers = new HashMap<>();
        headers.put("authority", checkToken.getString("data"));

        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");
        JSONObject data = new JSONObject();
        data.put("headers",headers);
        data.put("params",params);
        data.put("method","PUT");
        data.put("url", BASE_HOST +"ejc-file-web/attachment/upload");
        resp.put("data", data);
        return resp.toString();
    }

    /**
     * 三段提交第三阶段
     * 上传完成后，回调通知上传结果
     * 接口: POST /v3/3rd/files/:file_id/upload/complete
     * file_id	Path	是	string	文档 ID
     * request	Body	是	Object	获取上传地址时相同的请求
     * name	Request	是	string	文档名称
     * size	Request	是	integer	文档大小，单位 byte
     * digest	Request	是	map<string, string>	文档校验和，key 为算法，value 为结果值
     * is_manual	Request	是	boolean	是否手动保存，即用户手动 ctrl/cmd + s 或点击保存版本触发的保存，区别于定时触发的自动保存
     * attachment_size	Request	否	integer	文档内包含的附件的大小，单位 byte
     * content_type	Request	否	string	文档的 MIME 类型
     * response	Body	是	Object	上传文档完成后，存储服务返回的 HTTP Response
     * status_code	Response	是	integer	上传文档时，存储服务返回的 HTTP Response Status
     * headers	Response	否	map<string, string>	上传文档时，存储服务返回的 HTTP Response Header
     * body	Response	否	[]byte	上传文档时，存储服务返回的 HTTP Response Body 的 base64 编码
     * send_back_params	Body	否	map<string, string>	获取上传地址时，要求原样带回的额外参数
     * 说明：WebOffice 在将新版本文件上传到指定地址后，将会回调通知接入方
     * @return
     */
    @PostMapping(value = "v3/3rd/files/{fileId}/upload/complete", produces = { "application/json;charset=UTF-8" })
    public Object complete(@PathVariable String fileId,@RequestBody JSONObject param, HttpServletRequest req) {
        logger.info("wpscbk upload address: fileId-{}, param-{}", fileId, param);
        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo) {
            return getReturnMsg(WpsReturnCodeEnum.NotExists, "任务单据不存在！");
        }
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");
        AttachmentVO attachmentVO = null;
        try {
            //获取响应体的body字符串
            String fileUploadRespStr = param.getString("response");
            CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
            if(!attachmentResp.isSuccess()) {
                logger.error("保存 文件失败 ，原因：{}", attachmentResp.getMsg());
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
            }
            attachmentVO = attachmentResp.getData().get(0);
        } catch (Exception e) {
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
        }
        logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));
        billEditInfo.setFileId(attachmentVO.getId());
        billEditInfo.setFileName(attachmentVO.getFileName());
        billEditInfo.setFilePath(attachmentVO.getOnlinePath());
        service.saveOrUpdate(billEditInfo,false);
        resp.put("data", generateFileInfo(attachmentVO));
        return resp.toString();
    }

    /**
     * 模板文件版本保存
     *
     * @param fileId 文件Id
     * @param file 待保存的模板文件
     * @param originalFileNameStr 附件原始名称
     * @param size 文档大小，单位 byte
     * @param isManual 是否手动保存，即用户手动 ctrl/cmd + s 或点击保存版本触发的保存，区别于定时触发的自动保存
     * @param attachmentSize 文档内包含的附件的大小，单位 byte
     * @param contentType 文档的 MIME 类型
     * @param sha1 文档校验和，采用 sha1 算法
     * @return
     */
    @PostMapping(value = "v3/3rd/files/{fileId}/upload", produces = { "application/json;charset=UTF-8" })
    public Object saveFile(@PathVariable String fileId,
                           @RequestParam("file") MultipartFile file,
                           @RequestParam(value = "name") String originalFileNameStr,
                           @RequestParam(value = "size") Integer size,
                           @RequestParam(value = "manual", required = false) boolean isManual,
                           @RequestParam(value = "attachment_size", required = false) Integer attachmentSize,
                           @RequestParam(value = "content_type", required = false) String contentType,
                           @RequestParam(value = "sha1", required = false) String sha1,
                           HttpServletRequest req) {


        logger.info("调用方法saveFile 接收到模板保存请求：fileId-{}, size-{}, isManual-{}, originalFileNameStr-{}, attachmentSize-{}, contentType-{},sha1-{}",
                fileId, size, isManual, originalFileNameStr, attachmentSize, contentType, sha1);
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");

        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            return checkToken.toJSONString();
        }
        String authority = checkToken.getString("data");
        InvocationInfoProxy.setExtendAttribute("authority", authority);

        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo) {
            return getReturnMsg(WpsReturnCodeEnum.NotExists, "任务单据不存在！");
        }
        Map<String,String> params = new HashMap<>();
        params.put("sourceType", "ejc_contract_check");
        params.put("sourceId", billEditInfo.getId().toString());
        params.put("billType", "ejc_contract_check");
        params.put("originalFileNameStr", StringUtils.isNotBlank(originalFileNameStr) ? originalFileNameStr : file.getOriginalFilename());
        Map<String,String> headers = new HashMap<>();
        headers.put("authority", checkToken.getString("data"));
        AttachmentVO attachmentVO = null;
        try {
            //保存新的模板文件
            String fileUploadRespStr = postFile(BASE_HOST +"ejc-file-web/attachment/upload", params, headers, file);
            CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
            if(!attachmentResp.isSuccess()) {
                logger.error("保存 文件失败 ，原因：{}", attachmentResp.getMsg());
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
            }
            attachmentVO = attachmentResp.getData().get(0);
        } catch (Exception e) {
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
        }
        logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));
        billEditInfo.setFileId(attachmentVO.getId());
        billEditInfo.setFileName(attachmentVO.getFileName());
        billEditInfo.setFilePath(attachmentVO.getOnlinePath());
        service.saveOrUpdate(billEditInfo,false);
        resp.put("data", generateFileInfo(attachmentVO));
        return resp.toString();
    }

    @GetMapping(value = "v3/3rd/files/{fileId}/versions/{version}/download", produces = { "application/json;charset=UTF-8" })
    public Object getFileVersionDownloadInfo(@PathVariable String fileId,
                                             @PathVariable String version,
                                             HttpServletRequest req) throws Exception {
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, "操作成功！");
        String wpsToken = req.getHeader("X-Weboffice-Token");
        logger.info("调用方法getFileVersionDownloadInfo v3/3rd/files/{fileId}/versions/{version}/download  wpsToken: {}", wpsToken);

        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo) {
            return getReturnMsg(WpsReturnCodeEnum.NotExists, "任务单据不存在！");
        }
        String actualFileId = billEditInfo.getFileId().toString();

        JSONObject data= new JSONObject();
        data.put("url", (StringUtils.isNotBlank(DOWNLOAD_HOST) ? DOWNLOAD_HOST : BASE_HOST) + "ejc-support-web/wpscb/downloadFileByTmpId?fileId="+ actualFileId +"&wpsten="+URLEncoder.encode(wpsToken, "UTF-8"));
        resp.put("data", data);
        logger.info("返回WPS文档下载信息：{}", resp.toJSONString());
        return resp.toString();
    }

    /**
     * 拼接返回信息
     *
     * @param backState 返回状态
     * @param customMsg 自定义错误信息
     * @return
     */
    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg) {
        JSONObject resp = new JSONObject();
        resp.put("code", backState.getCode());
        resp.put("message", backState.getMessage());
        resp.put("details", StringUtils.isNotBlank(customMsg) ? customMsg : backState.getDetails());
        resp.put("hint", StringUtils.isNotBlank(customMsg) ? customMsg : backState.getDetails());
        resp.put("oprResult", false);

        return resp;
    }
    /**
     * 拼接返回信息
     *
     * @param backState 返回状态
     * @param customMsg 自定义信息
     * @return
     */
    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg, Object data) {
        JSONObject resp = new JSONObject();
        resp.put("code", backState.getCode());
        resp.put("message", backState.getMessage());
        resp.put("details", StringUtils.isNotBlank(customMsg) ? customMsg : backState.getDetails());
        resp.put("hint", StringUtils.isNotBlank(customMsg) ? customMsg : backState.getDetails());
        resp.put("oprResult", false);
        resp.put("data", data);

        return resp;
    }

    /**
     * 根据模板Id、或者文件Id下载对应模板文件
     *
     * @param fileId
     * @param
     */
    @GetMapping(value = "downloadFileByTmpId")
    public void downloadFileByTmpId(@RequestParam(value = "fileId") String fileId,
                                    @RequestParam(value = "wpsten") String wpsten,
                                    HttpServletResponse response) throws Exception {
        logger.info("下载文件参数：fileId-{},wpsten-{}", fileId, wpsten);

        String wpsToken = URLDecoder.decode(wpsten, "UTF-8");
        logger.info("wpsToken: {}", wpsToken);
        JSONObject checkToken = checkWpsToken(wpsToken);
        if(0 != checkToken.getInteger("code")) {
            throw new BusinessException(checkToken.get("message").toString());
        }
        String authority = checkToken.getString("data");
        InvocationInfoProxy.setExtendAttribute("authority", authority);

        //根据文件Id获取编辑信息
        ContractCheckEntity billEditInfo  = service.getByFileId(fileId);
        if(null == billEditInfo) {
            billEditInfo = service.selectById(Long.valueOf(fileId));
        }
        if(null == billEditInfo) {
            throw new BusinessException("单据不存在！");
        }
        logger.info("下载文件fileId-{} ", billEditInfo.getFileId());
        InputStream inputStream = null;
        try {
            Response fileResponse = attachmentApi.downloadFileById(billEditInfo.getFileId());
            Response.Body body = fileResponse.body();
            inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            response.setHeader("Content-Disposition", fileResponse.headers().get("Content-Disposition").toString().replace("[","").replace("]",""));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(response.getOutputStream());
            int length = 0;
            byte[] temp = new byte[1024 * 10];
            while ((length = bufferedInputStream.read(temp)) != -1) {
                bufferedOutputStream.write(temp, 0, length);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 根据 Id查询 附件信息
     *
     * @return
     */
    private JSONObject getFile(String fileId) {
        //文件信息
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("oprResult", true);
        AttachmentVO file = null;
        CommonResponse<AttachmentVO> attachmentResp = attachmentApi.queryDetail(fileId);
        if(!attachmentResp.isSuccess()) {
            fileInfo.put("oprResult", false);
            logger.error("根据Id-{}获取对应文件信息失败，{}", fileId, attachmentResp.getMsg());
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "根据Id获取对应文件信息失败！");
        }
        file = attachmentResp.getData();
        //文件名(必须带文件后缀)
        fileInfo.put("name", file.getFileName());
        //当前版本号,必须大于 0，同时位数小于 11
        fileInfo.put("version", file.getVersion());
        //文件大小，单位为B(文件真实大小，否则会出现异常)
        fileInfo.put("size", file.getFileSize());
        // 创建者编码 ，字符串长度小于40
        fileInfo.put("creator_id", file.getCreateUserCode());
        //修改者编码，字符串长度小于40
        fileInfo.put("modifier_id", null != file.getUpdateUserCode() ? file.getUpdateUserCode() : file.getCreateUserCode());
        fileInfo.put("create_time", file.getCreateTime().getTime());
        fileInfo.put("modify_time", null != file.getUpdateTime() ? file.getUpdateTime().getTime() : file.getCreateTime().getTime());
        return fileInfo;
    }
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, MultipartFile file) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 30000;
        Integer readTimeout = 30000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file",
                    file.getInputStream(), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getOriginalFilename());
            for(String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient)client).execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient)client).execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }
        return result;
    }

}
