package com.ejianc.foundation.support.service.impl;

import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.support.mapper.ContractCheckMapper;
import com.ejianc.foundation.support.bean.ContractCheckEntity;
import com.ejianc.foundation.support.service.IContractCheckService;

import java.util.List;

/**
 * 合同法律审查单
 * 
 * @author generator
 * 
 */
@Service("contractCheckService")
public class ContractCheckServiceImpl extends BaseServiceImpl<ContractCheckMapper, ContractCheckEntity> implements IContractCheckService{

    @Override
    public ContractCheckEntity getByFileId(String fileId) {
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("fileId", new Parameter(QueryParam.EQ, fileId));
        List<ContractCheckEntity> list = queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }
}
