package com.ejianc.foundation.share.bean;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目
 * 
 * @author generator
 * 
 */
 @TableName("ejc_project")
public class ProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

	@TableField(value = "bill_state")
	private Integer billState;

	@TableField(value = "org_id")
    private Long orgId; // 上级组织
	@TableField(value = "org_name")
    private String orgName; // 上级组织名称

	@TableField(value = "state")
	private Integer state; // 状态标识（1：启用，0：停用）
	
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 所属项目部Id
    
    @TableField(value="bill_code")
    private String billCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_alias")
    private Long projectAlias; // 项目别名
    @TableField(value="project_alias_name")
    private String projectAliasName; // 项目别名
    @TableField(value="construction_unit")
    private Long constructionUnit; // 建设单位
    @TableField(value="construction_unit_name")
    private String constructionUnitName; // 建设单位名称
    @TableField(value="project_type")
    private String projectType; // 项目类型
    
    @TableField(value="promoter_nature")
    private Long promoterNature; // 发包人性质
    @TableField(value="promoter_nature_name")
    private String promoterNatureName; // 发包人性质名称
    @TableField(value="promoter_social_credit_code")
    private String promoterSocialCreditCode; // 统一社会信用代码
    @TableField(value="promoter_adress")
    private String promoterAdress; // 发包人地址
    @TableField(value="promoter_legal")
    private String promoterLegal; // 法人代表
    @TableField(value="promoter_telephone")
    private String promoterTelephone; // 法人电话
    
    @TableField(value="design_unit")
    private String designUnit; // 设计单位
    @TableField(value="supervision_unit")
    private String supervisionUnit; // 监理单位
    @TableField(value="contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value="contractual_model_name")
    private String contractualModelName; // 承包模式名称
    @TableField(value="investment_source")
    private Long investmentSource; // 投资来源
    @TableField(value="investment_source_name")
    private String investmentSourceName; // 投资来源名称
    @TableField(value="type")
    private Long type; // 建筑类型
    @TableField(value="type_name")
    private String typeName; // 建筑类型名称
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="end_date")
    private Date endDate; // 竣工日期
    @TableField(value="actual_start_date")
    private Date actualStartDate; // 实际开工日期
    @TableField(value="base_type")
    private String baseType; // 基础类型
    @TableField(value="structure_type")
    private String structureType; // 结构类型
    @TableField(value="built_area")
    private String builtArea; // 建筑面积(地上/地下)

    @TableField(value="built_all_area")
    private String builtAllArea; // 建筑总面积
    @TableField(value="built_height")
    private BigDecimal builtHeight; // 建筑高度(地上/地下）
    @TableField(value="layer_number")
    private String layerNumber; // 层数(地上/地下)
    @TableField(value="prefabrication_rate")
    private BigDecimal prefabricationRate; // 预制率
    @TableField(value="assembly_rate")
    private BigDecimal assemblyRate; // 装配率
    @TableField(value="epc_contract_scope")
    private String epcContractScope; // 总包合同范围
    @TableField(value="specify_subcontract_sscope")
    private String specifySubcontractSscope; // 指定分包合同范围
    @TableField(value="leader")
    private Long leader; // 项目负责人
    @TableField(value="leader_contact_information")
    private String leaderContactInformation; // 负责人联系方式
    @TableField(value="integrated_code")
    private String integratedCode; // 一体化编码
    @TableField(value="duration")
    private Integer duration; // 工期
    @TableField(value="contractor_unit")
    private Long contractorUnit; // 承包单位
    @TableField(value="control_price")
    private BigDecimal controlPrice; // 控制价
    @TableField(value="quality_agreement")
    private Long qualityAgreement; // 质量约定
    @TableField(value="project_scale")
    private String projectScale; // 工程规模
    @TableField(value="price_method")
    private String priceMethod; // 计价方式
    @TableField(value="project_bidding_profit")
    private BigDecimal projectBiddingProfit; // 项目投标利润率
    @TableField(value="consortium_won_bid")
    private String consortiumWonBid; // 联合体中标
    @TableField(value="investment_project")
    private String investmentProject; // 融投资带动项目
    @TableField(value="quota_price_downward_rate")
    private BigDecimal quotaPriceDownwardRate; // 定额计价下浮率
    @TableField(value="build")
    private Long build; // 施工单位
    @TableField(value="contracting_type")
    private String contractingType; // 承包类型
    @TableField(value="sign_unit")
    private Long signUnit; // 签约单位
    @TableField(value="sign_date")
    private Date signDate; // 签约日期
    @TableField(value="project_category")
    private Long projectCategory; // 项目类别
    @TableField(value="sign_status")
    private Long signStatus; // 签约状态
    @TableField(value="bidding_form")
    private Long biddingForm; // 招标形式
    @TableField(value="notification_award_date")
    private Date notificationAwardDate; // 中标通知书日期
    @TableField(value="project_location")
    private String projectLocation; // 工程地点
    @TableField(value="project_area")
    private String projectArea; // 工程键值
    @TableField(value="duration_description")
    private String durationDescription; // 工期描述
    @TableField(value="job_content")
    private String jobContent; // 工作内容
    @TableField(value="actual_end_date")
    private Date actualEndDate; // 实际竣工日期
    @TableField(value="safe_civilized_construction_requirement")
    private String safeCivilizedConstructionRequirement; // 安全(文明)施工要求
    @TableField(value="price_adjustment_process_time")
    private String priceAdjustmentProcessTime; // 认价或价格调整的流程与时间
    @TableField(value="project_control_level")
    private Long projectControlLevel; // 项目管控级别
    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    @TableField(value = "status")
    private String status;

    @TableField(value = "area")
    private String area; //项目地区
    @TableField(value = "lat")
    private String lat; //纬度
    @TableField(value = "lng")
    private String lng; //经度
    
    /************项目工程标价*************/
    @TableField(value="project_bid_win_price")
    private BigDecimal projectBidWinPrice; // 工程中标价(元)
    @TableField(value="civil_engineering")
    private BigDecimal civilEngineering; // 土建(元)
    @TableField(value="fix")
    private BigDecimal fix; // 安装(元)
    @TableField(value="water_supply_drainage")
    private BigDecimal waterSupplyDrainage; // 给排水(元)
    @TableField(value="strong_current")
    private BigDecimal strongCurrent; // 强电(元)
    @TableField(value="heate_ventilation")
    private BigDecimal heateVentilation; // 暖通(元)
    @TableField(value="fix_other")
    private BigDecimal fixOther; // 其它(元)
    @TableField(value="decorate")
    private BigDecimal decorate; // 装饰(元)
    @TableField(value="other")
    private BigDecimal other; // 其它(元)
    /************项目工程标价*************/

    /************项目合同额*************/
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同额(元)
    @TableField(value="self_construction_contract_amount")
    private BigDecimal selfConstructionContractAmount; // 自施合同额(元)
    @TableField(value="belong")
    private String belong; // 属于
    /************项目合同额*************/


    /************项目补充信息*************/
    @TableField(value="project_status")
    private String projectStatus; // 项目状态
    @TableField(value="project_num")
    private Integer projectNum; // 项目序号
    @TableField(value="pc_factory")
    private Boolean pcFactory; // 是否PC厂
    @TableField(value="graphic_progress")
    private String graphicProgress; // 形象进度
    @TableField(value="project_nature")
    private String projectNature; // 项目性质
    @TableField(value="provisional_amount")
    private BigDecimal provisionalAmount; // 暂列金金额
    @TableField(value="has_construction_permit")
    private Boolean hasConstructionPermit; // 是/否办理施工许可证
    @TableField(value="permit_explain")
    private String permitExplain; // 未办理施工许可证说明
    @TableField(value="contract_nodes")
    private String contractNodes; // 合同过程重大节点
    @TableField(value="establish_project_department")
    private Boolean establishProjectDepartment; // 是/否建立项目经理部
    @TableField(value="project_department_explain")
    private String projectDepartmentExplain; // 未建立项目经理部情况说明
    @TableField(value="management_person_num")
    private Integer managementPersonNum; // 管理人员数量
    @TableField(value="labor_person_num")
    private Integer laborPersonNum; // 劳务人员数量
    @TableField(value="contract_goal")
    private String contractGoal; // 合同创优目标
    @TableField(value = "plan_start_date",fill = FieldFill.UPDATE)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期
    @TableField(value = "plan_end_date",fill = FieldFill.UPDATE)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期'
    @TableField(value="plan_duration")
    private Integer planDuration; // 计划工期（日历天）
    /************项目补充信息*************/
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectAlias() {
        return projectAlias;
    }

    public void setProjectAlias(Long projectAlias) {
        this.projectAlias = projectAlias;
    }
    public String getProjectAliasName() {
		return projectAliasName;
	}

	public void setProjectAliasName(String projectAliasName) {
		this.projectAliasName = projectAliasName;
	}

    public Long getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }

    public String getSupervisionUnit() {
        return supervisionUnit;
    }

    public void setSupervisionUnit(String supervisionUnit) {
        this.supervisionUnit = supervisionUnit;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Long getInvestmentSource() {
        return investmentSource;
    }

    public void setInvestmentSource(Long investmentSource) {
        this.investmentSource = investmentSource;
    }
  
    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public String getBaseType() {
        return baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }
  
    public String getStructureType() {
        return structureType;
    }

    public void setStructureType(String structureType) {
        this.structureType = structureType;
    }

    public String getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(String builtArea) {
        this.builtArea = builtArea;
    }

    public BigDecimal getBuiltHeight() {
        return builtHeight;
    }

    public void setBuiltHeight(BigDecimal builtHeight) {
        this.builtHeight = builtHeight;
    }

    public String getLayerNumber() {
        return layerNumber;
    }

    public void setLayerNumber(String layerNumber) {
        this.layerNumber = layerNumber;
    }

    public BigDecimal getPrefabricationRate() {
        return prefabricationRate;
    }

    public void setPrefabricationRate(BigDecimal prefabricationRate) {
        this.prefabricationRate = prefabricationRate;
    }

    public BigDecimal getAssemblyRate() {
        return assemblyRate;
    }

    public void setAssemblyRate(BigDecimal assemblyRate) {
        this.assemblyRate = assemblyRate;
    }

    public String getEpcContractScope() {
        return epcContractScope;
    }

    public void setEpcContractScope(String epcContractScope) {
        this.epcContractScope = epcContractScope;
    }

    public String getSpecifySubcontractSscope() {
        return specifySubcontractSscope;
    }

    public void setSpecifySubcontractSscope(String specifySubcontractSscope) {
        this.specifySubcontractSscope = specifySubcontractSscope;
    }

    public Long getLeader() {
        return leader;
    }

    public void setLeader(Long leader) {
        this.leader = leader;
    }

    public String getLeaderContactInformation() {
        return leaderContactInformation;
    }

    public void setLeaderContactInformation(String leaderContactInformation) {
        this.leaderContactInformation = leaderContactInformation;
    }

    public String getIntegratedCode() {
        return integratedCode;
    }

    public void setIntegratedCode(String integratedCode) {
        this.integratedCode = integratedCode;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public BigDecimal getControlPrice() {
        return controlPrice;
    }

    public void setControlPrice(BigDecimal controlPrice) {
        this.controlPrice = controlPrice;
    }
    
    public Long getQualityAgreement() {
        return qualityAgreement;
    }

    public void setQualityAgreement(Long qualityAgreement) {
        this.qualityAgreement = qualityAgreement;
    }

    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }

    public String getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getSelfConstructionContractAmount() {
        return selfConstructionContractAmount;
    }

    public void setSelfConstructionContractAmount(BigDecimal selfConstructionContractAmount) {
        this.selfConstructionContractAmount = selfConstructionContractAmount;
    }

    public BigDecimal getProjectBiddingProfit() {
        return projectBiddingProfit;
    }

    public void setProjectBiddingProfit(BigDecimal projectBiddingProfit) {
        this.projectBiddingProfit = projectBiddingProfit;
    }

    public String getConsortiumWonBid() {
        return consortiumWonBid;
    }

    public void setConsortiumWonBid(String consortiumWonBid) {
        this.consortiumWonBid = consortiumWonBid;
    }

    public String getInvestmentProject() {
        return investmentProject;
    }

    public void setInvestmentProject(String investmentProject) {
        this.investmentProject = investmentProject;
    }

    public BigDecimal getQuotaPriceDownwardRate() {
        return quotaPriceDownwardRate;
    }

    public void setQuotaPriceDownwardRate(BigDecimal quotaPriceDownwardRate) {
        this.quotaPriceDownwardRate = quotaPriceDownwardRate;
    }

    public Long getBuild() {
        return build;
    }

    public void setBuild(Long build) {
        this.build = build;
    }

    public String getContractingType() {
        return contractingType;
    }

    public void setContractingType(String contractingType) {
        this.contractingType = contractingType;
    }

    public Long getSignUnit() {
        return signUnit;
    }

    public void setSignUnit(Long signUnit) {
        this.signUnit = signUnit;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Long getProjectCategory() {
        return projectCategory;
    }

    public void setProjectCategory(Long projectCategory) {
        this.projectCategory = projectCategory;
    }

    public Long getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Long signStatus) {
        this.signStatus = signStatus;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getNotificationAwardDate() {
        return notificationAwardDate;
    }

    public void setNotificationAwardDate(Date notificationAwardDate) {
        this.notificationAwardDate = notificationAwardDate;
    }

    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }

    public String getDurationDescription() {
        return durationDescription;
    }

    public void setDurationDescription(String durationDescription) {
        this.durationDescription = durationDescription;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public String getSafeCivilizedConstructionRequirement() {
        return safeCivilizedConstructionRequirement;
    }

    public void setSafeCivilizedConstructionRequirement(String safeCivilizedConstructionRequirement) {
        this.safeCivilizedConstructionRequirement = safeCivilizedConstructionRequirement;
    }
    
    public String getPriceAdjustmentProcessTime() {
        return priceAdjustmentProcessTime;
    }

    public void setPriceAdjustmentProcessTime(String priceAdjustmentProcessTime) {
        this.priceAdjustmentProcessTime = priceAdjustmentProcessTime;
    }

	public BigDecimal getProjectBidWinPrice() {
		return projectBidWinPrice;
	}

	public void setProjectBidWinPrice(BigDecimal projectBidWinPrice) {
		this.projectBidWinPrice = projectBidWinPrice;
	}

	public BigDecimal getCivilEngineering() {
		return civilEngineering;
	}

	public void setCivilEngineering(BigDecimal civilEngineering) {
		this.civilEngineering = civilEngineering;
	}

	public BigDecimal getFix() {
		return fix;
	}

	public void setFix(BigDecimal fix) {
		this.fix = fix;
	}

	public BigDecimal getWaterSupplyDrainage() {
		return waterSupplyDrainage;
	}

	public void setWaterSupplyDrainage(BigDecimal waterSupplyDrainage) {
		this.waterSupplyDrainage = waterSupplyDrainage;
	}

	public BigDecimal getStrongCurrent() {
		return strongCurrent;
	}

	public void setStrongCurrent(BigDecimal strongCurrent) {
		this.strongCurrent = strongCurrent;
	}

	public BigDecimal getHeateVentilation() {
		return heateVentilation;
	}

	public void setHeateVentilation(BigDecimal heateVentilation) {
		this.heateVentilation = heateVentilation;
	}

	public BigDecimal getFixOther() {
		return fixOther;
	}

	public void setFixOther(BigDecimal fixOther) {
		this.fixOther = fixOther;
	}

	public BigDecimal getDecorate() {
		return decorate;
	}

	public void setDecorate(BigDecimal decorate) {
		this.decorate = decorate;
	}

	public BigDecimal getOther() {
		return other;
	}

	public void setOther(BigDecimal other) {
		this.other = other;
	}

	public BigDecimal getContractAmount() {
		return contractAmount;
	}

	public void setContractAmount(BigDecimal contractAmount) {
		this.contractAmount = contractAmount;
	}

	public String getBelong() {
		return belong;
	}

	public void setBelong(String belong) {
		this.belong = belong;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getContractualModelName() {
		return contractualModelName;
	}

	public void setContractualModelName(String contractualModelName) {
		this.contractualModelName = contractualModelName;
	}

	public String getInvestmentSourceName() {
		return investmentSourceName;
	}

	public void setInvestmentSourceName(String investmentSourceName) {
		this.investmentSourceName = investmentSourceName;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public Long getPromoterNature() {
		return promoterNature;
	}

	public void setPromoterNature(Long promoterNature) {
		this.promoterNature = promoterNature;
	}

	public String getPromoterNatureName() {
		return promoterNatureName;
	}

	public void setPromoterNatureName(String promoterNatureName) {
		this.promoterNatureName = promoterNatureName;
	}

	public String getPromoterSocialCreditCode() {
		return promoterSocialCreditCode;
	}

	public void setPromoterSocialCreditCode(String promoterSocialCreditCode) {
		this.promoterSocialCreditCode = promoterSocialCreditCode;
	}

	public String getPromoterAdress() {
		return promoterAdress;
	}

	public void setPromoterAdress(String promoterAdress) {
		this.promoterAdress = promoterAdress;
	}

	public String getPromoterLegal() {
		return promoterLegal;
	}

	public void setPromoterLegal(String promoterLegal) {
		this.promoterLegal = promoterLegal;
	}

	public String getPromoterTelephone() {
		return promoterTelephone;
	}

	public void setPromoterTelephone(String promoterTelephone) {
		this.promoterTelephone = promoterTelephone;
	}

	public String getProjectType() {
		return projectType;
	}

	public void setProjectType(String projectType) {
		this.projectType = projectType;
	}

	public String getProjectArea() {
		return projectArea;
	}

	public void setProjectArea(String projectArea) {
		this.projectArea = projectArea;
	}

	public Long getProjectControlLevel() {
		return projectControlLevel;
	}

	public void setProjectControlLevel(Long projectControlLevel) {
		this.projectControlLevel = projectControlLevel;
	}

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getBuiltAllArea() {
        return builtAllArea;
    }

    public void setBuiltAllArea(String builtAllArea) {
        this.builtAllArea = builtAllArea;
    }

    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public Boolean getPcFactory() {
        return pcFactory;
    }

    public void setPcFactory(Boolean pcFactory) {
        this.pcFactory = pcFactory;
    }

    public String getGraphicProgress() {
        return graphicProgress;
    }

    public void setGraphicProgress(String graphicProgress) {
        this.graphicProgress = graphicProgress;
    }

    public String getProjectNature() {
        return projectNature;
    }

    public void setProjectNature(String projectNature) {
        this.projectNature = projectNature;
    }

    public BigDecimal getProvisionalAmount() {
        return provisionalAmount;
    }

    public void setProvisionalAmount(BigDecimal provisionalAmount) {
        this.provisionalAmount = provisionalAmount;
    }

    public Boolean getHasConstructionPermit() {
        return hasConstructionPermit;
    }

    public void setHasConstructionPermit(Boolean hasConstructionPermit) {
        this.hasConstructionPermit = hasConstructionPermit;
    }

    public String getPermitExplain() {
        return permitExplain;
    }

    public void setPermitExplain(String permitExplain) {
        this.permitExplain = permitExplain;
    }

    public String getContractNodes() {
        return contractNodes;
    }

    public void setContractNodes(String contractNodes) {
        this.contractNodes = contractNodes;
    }

    public Boolean getEstablishProjectDepartment() {
        return establishProjectDepartment;
    }

    public void setEstablishProjectDepartment(Boolean establishProjectDepartment) {
        this.establishProjectDepartment = establishProjectDepartment;
    }

    public String getProjectDepartmentExplain() {
        return projectDepartmentExplain;
    }

    public void setProjectDepartmentExplain(String projectDepartmentExplain) {
        this.projectDepartmentExplain = projectDepartmentExplain;
    }

    public Integer getManagementPersonNum() {
        return managementPersonNum;
    }

    public void setManagementPersonNum(Integer managementPersonNum) {
        this.managementPersonNum = managementPersonNum;
    }

    public Integer getLaborPersonNum() {
        return laborPersonNum;
    }

    public void setLaborPersonNum(Integer laborPersonNum) {
        this.laborPersonNum = laborPersonNum;
    }

    public String getContractGoal() {
        return contractGoal;
    }

    public void setContractGoal(String contractGoal) {
        this.contractGoal = contractGoal;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public Integer getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(Integer planDuration) {
        this.planDuration = planDuration;
    }
}
