package com.ejianc.foundation.billcode.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.billcode.engine.persistence.IBillCodeEngineService;
import com.ejianc.foundation.billcode.engine.persistence.vo.BillCodeSNVO;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

/**
 * 并发大了抗不住，只能异步处理了
 *
 * @author hupeng 2018年7月6日
 *
 */
@Component
public class BillcodeSNReferQueue implements InitializingBean {

    private static final Log logger = LogFactory.getFactory().getInstance(BillcodeSNReferQueue.class);

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IBillCodeEngineService billCodeEngineService;

    public static final String MESSAGE_KEY = "billcodesnrefer:queue";
    private volatile int count = 0;

    @Override
    public void afterPropertiesSet() throws Exception {
        BillcodeSNReferThread thread = new BillcodeSNReferThread();
        thread.start();
    }

    public class BillcodeSNReferThread extends Thread {

        @Override
        public void run() {
            Jedis jedis = null;
            try {
                jedis = jedisPool.getResource();
                while (true) {
                    String message = jedis.rpop(MESSAGE_KEY);
                    if (message != null) {
                        count++;
                        BillCodeSNVO billCodeSNVO = (BillCodeSNVO) JSON.parseObject(message, BillCodeSNVO.class);
                        logger.error("第" + count + "次写入数据库最大流水号");
                        handle(billCodeSNVO);
                    }
                    Thread.sleep(300);
                }

            } catch (JedisException e) {
                throw new JedisException(e);
            } catch (InterruptedException e) {
                logger.error("流水号异步入库失败", e);
            } finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }

    private void handle(BillCodeSNVO billCodeSNVO) {
        if (null == billCodeSNVO.getId()) {
            BillCodeSNVO dBBillCodeSNVO	=this.billCodeEngineService.querySNVO(billCodeSNVO.getRuleId(), billCodeSNVO.getMarkStr(), billCodeSNVO.getTenantId());
            if (dBBillCodeSNVO==null) {
                this.billCodeEngineService.insertSNVO(billCodeSNVO);
            }else{
                this.billCodeEngineService.updateSNVO(dBBillCodeSNVO.getRuleId(), billCodeSNVO.getMarkStr(), billCodeSNVO.getLastsn(), billCodeSNVO.getTenantId());
            }
        } else {
            this.billCodeEngineService.updateSNVO(billCodeSNVO.getRuleId(), billCodeSNVO.getMarkStr(), billCodeSNVO.getLastsn(), billCodeSNVO.getTenantId());
        }
    }
}
