package com.ejianc.foundation.support.controller.api;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.bean.BillParamCustomEntity;
import com.ejianc.foundation.support.bean.BillParamEntity;
import com.ejianc.foundation.support.bean.ParamRegisterSetEntity;
import com.ejianc.foundation.support.service.IBillParamCustomService;
import com.ejianc.foundation.support.service.IBillParamService;
import com.ejianc.foundation.support.service.IParamRegisterSetService;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/api/param/config/")
public class ParamConfigApi {

	@Autowired
	private IParamRegisterSetService iParamRegisterSetService;
	@Autowired
	private IBillParamService billParamService;
	@Autowired
	private IBillParamCustomService billParamCustomService;
	@Autowired
	private IOrgApi iOrgApi;
	private final static String paramWarnControl = "P-N5f1Bc0150";

	@RequestMapping(value = "getByCode", method=RequestMethod.GET)
	public CommonResponse<ParamRegisterSetVO> getByCode(@RequestParam(value="code") String code) {
		ParamRegisterSetEntity entity = iParamRegisterSetService.getByCode(code);
		if(entity == null){
			return CommonResponse.error("该参数尚未配置！");
		}
		ParamRegisterSetVO vo = BeanMapper.map(entity,ParamRegisterSetVO.class);
		return CommonResponse.success(vo);
	}

	@RequestMapping(value = "getByCodeAllTenantId", method=RequestMethod.GET)
	public CommonResponse<List<ParamRegisterSetVO>> getByCodeAllTenantId(@RequestParam(value="code") String code) {
		List<ParamRegisterSetEntity> entityList = iParamRegisterSetService.getByCodeAllTenantId(code);
		if(entityList == null){
			return CommonResponse.error("该参数尚未配置！");
		}
		List<ParamRegisterSetVO> vo = BeanMapper.mapList(entityList,ParamRegisterSetVO.class);
		return CommonResponse.success(vo);
	}

	@Deprecated
	@RequestMapping(value = "getBillParamByCode", method=RequestMethod.GET)
	public CommonResponse<BillParamVO> getBillParamByCode(@RequestParam(value="code") String code) {
		QueryParam param = new QueryParam();
		param.getParams().put("code", new Parameter(QueryParam.EQ, code));
		List<BillParamEntity> setEntities = billParamService.queryList(param,false);
		if(ListUtil.isNotEmpty(setEntities)){
			param = new QueryParam();
			BillParamEntity billParamEntity = setEntities.get(0);
			param.getParams().put("pid", new Parameter(QueryParam.EQ, billParamEntity.getId()));
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			List<BillParamCustomEntity> sutEntities = billParamCustomService.queryList(param,false);
			if(ListUtil.isNotEmpty(sutEntities)){
				BillParamCustomEntity customEntity = sutEntities.get(0);
				billParamEntity.setControlType(customEntity.getControlType());
				billParamEntity.setRoleValue(customEntity.getRoleValue());
			}
		}else {
			return CommonResponse.error("该参数未发布或者没有定义！");
		}
		BillParamVO vo = BeanMapper.map(setEntities.get(0),BillParamVO.class);
		return CommonResponse.success(vo);
	}

	@RequestMapping(value = "getBillParamByCodeAndOrgId", method=RequestMethod.GET)
	public CommonResponse<List<BillParamVO>> getBillParamByCodeAndOrgId(@RequestParam(value="code") String code,@RequestParam(value="orgId") Long orgId) {

		QueryParam param = new QueryParam();
		param.getParams().put("code", new Parameter(QueryParam.EQ, code));
		List<BillParamEntity> setEntities = null;
		List<BillParamVO> res = new ArrayList<>();
		/**
		 * 利用平台参数来指定查询单据设置的方式
		 * 参数值1：查询本上第一个设置了参数的设置
		 * 参数值2：查询本上所有设置了参数的设置
		 * */
		ParamRegisterSetEntity entity = iParamRegisterSetService.getByCode(paramWarnControl);
		if(entity == null ||"1".equals(entity.getValueData())){
			CommonResponse<OrgVO> response = iOrgApi.getOneById(orgId);
			if(!response.isSuccess() || response.getData() == null){
				return CommonResponse.error("未查询到预警设置组织");
			}
			OrgVO orgVO = response.getData();
			String innerCode = orgVO.getInnerCode();
			String[] parentIds = innerCode.split("\\|");
			for (int i = parentIds.length - 1; i >= 0; i--) {
				/** 反向查找 */
				Long pOrgId = Long.parseLong(parentIds[i]);
				param.getParams().put("orgId", new Parameter(QueryParam.EQ, pOrgId));
				setEntities = billParamService.queryList(param,false);
				if(ListUtil.isNotEmpty(setEntities)){
					break;
				}
			}
			if(ListUtil.isEmpty(setEntities)){
				/** 查询默认的 */
				param.getParams().put("tenantId", new Parameter(QueryParam.EQ, "999999"));
				param.getParams().put("orgId", new Parameter(QueryParam.EQ, null));
				setEntities = billParamService.queryList(param,false);
			}
		}else {
			ComplexParam complexParam = new ComplexParam();
			complexParam.setLogic(ComplexParam.AND);
			ComplexParam c1 = new ComplexParam();
			c1.setLogic(ComplexParam.OR);
			c1.getParams().put("tenantId", new Parameter(QueryParam.EQ, "999999"));
			c1.getParams().put("orgId", new Parameter(QueryParam.EQ, null));
			CommonResponse<List<OrgVO>> response = iOrgApi.findParentsByOrgId(orgId);
			if(!response.isSuccess() || ListUtil.isEmpty(response.getData())){
				return CommonResponse.error("查询本上组织出错");
			}
			ComplexParam c2 = new ComplexParam();
			c2.setLogic(ComplexParam.OR);
			c2.getParams().put("orgId", new Parameter(QueryParam.IN, response.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
			complexParam.getComplexParams().add(c1);
			complexParam.getComplexParams().add(c2);
			param.getComplexParams().add(complexParam);
			setEntities = billParamService.queryList(param,false);
		}
		if(ListUtil.isNotEmpty(setEntities)){
			param = new QueryParam();
			param.getParams().put("code", new Parameter(QueryParam.EQ, code));
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, "999999"));
			param.getParams().put("orgId", new Parameter(QueryParam.EQ, null));
			List<BillParamEntity> baseSet = billParamService.queryList(param,false);
			if(ListUtil.isEmpty(baseSet)){
				return CommonResponse.error("该参数未发布或者没有定义！");
			}

			param = new QueryParam();
			param.getParams().put("pid", new Parameter(QueryParam.EQ, baseSet.get(0).getId()));
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			List<BillParamCustomEntity> customEntities = billParamCustomService.queryList(param,false);
			BillParamEntity billParamEntity = null;
			if(ListUtil.isEmpty(customEntities)){
				/** 没有设置值，就取默认值,作为租户根组织数据 */
				billParamEntity = baseSet.get(0);
				OrgVO baseOrg = iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid()).getData();
				billParamEntity.setOrgId(baseOrg.getId());
				billParamEntity.setOrgName(baseOrg.getName());
			}

			param = new QueryParam();
			param.getParams().put("pid", new Parameter(QueryParam.IN, setEntities.stream().map(BillParamEntity::getId).collect(Collectors.toList())));
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			customEntities = billParamCustomService.queryList(param,false);
			if(ListUtil.isNotEmpty(customEntities)){
				if(billParamEntity != null){
					res.add(BeanMapper.map(billParamEntity,BillParamVO.class));
				}
				for (BillParamCustomEntity customEntity : customEntities) {
					for (BillParamEntity paramEntity : setEntities) {
						if(paramEntity.getId().equals(customEntity.getPid())){
							billParamEntity = paramEntity;
							break;
						}
					}
					billParamEntity.setControlType(customEntity.getControlType());
					billParamEntity.setRoleValue(customEntity.getRoleValue());
					if(billParamEntity.getOrgId() == null){
						OrgVO baseOrg = iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid()).getData();
						billParamEntity.setOrgId(baseOrg.getId());
						billParamEntity.setOrgName(baseOrg.getName());
					}
					res.add(BeanMapper.map(billParamEntity,BillParamVO.class));
				}
			}else {
				res.add(BeanMapper.map(billParamEntity,BillParamVO.class));
			}
		}else {
			return CommonResponse.error("该参数未发布或者没有定义！");
		}
		/** 排序后输出，方便业务使用 */
		res.sort(Comparator.comparing(BillParamVO::getRoleValue));
		return CommonResponse.success(res);
	}
}
