package com.ejianc.foundation.support.controller;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.support.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.billcode.BillCodeException;
import com.ejianc.foundation.support.bean.BillTypeEntity;
import com.ejianc.foundation.support.service.IBillCodeGenerator;
import com.ejianc.foundation.support.service.IBillTypeService;
import com.ejianc.foundation.support.service.IModuleService;
import com.ejianc.foundation.util.DataTransferUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 单据类型controller
 * 
 * @author guominga
 *
 */
@RestController
@RequestMapping("/billtype/")
public class BillTypeController implements Serializable {
	private Gson gson = new Gson();

	private static final long serialVersionUID = 1L;
	private static final String BILLTYPE_BILL_CODE = "SUPPORT_BILLTYPE";

	// 日志
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeService billTypeService;
	@Autowired
	private IBillCodeGenerator generator;
	@Autowired
	private IModuleService moduleService;
	@Autowired
	private EnvironmentTools environmentTools;

	/**
	 * 新增或者修改
	 * 
	 * @param billTypeVo
	 * @return
	 * @throws BillCodeException 
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody BillTypeVO billTypeVo) throws BillCodeException {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(billTypeVo.getId() != null && billTypeVo.getId() > 0) {
			BillTypeVO uniqueBean = billTypeService.queryDetail(billTypeVo.getId());
			uniqueBean.setBillCode(billTypeVo.getBillCode());
			uniqueBean.setBillName(billTypeVo.getBillName());
			uniqueBean.setMetadataId(billTypeVo.getMetadataId());
			if(StringUtils.isNotBlank(billTypeVo.getMetadataName())) {
				uniqueBean.setMetadataName(billTypeVo.getMetadataName());
			}
			
			BillTypeEntity billTypeEntity = BeanMapper.map(uniqueBean, BillTypeEntity.class);
			billTypeService.saveOrUpdate(billTypeEntity, false);
			
			return CommonResponse.success("修改成功");
		}else{
			String billCode = generator.generateBillCodeById(BILLTYPE_BILL_CODE, tenantId);
			billTypeVo.setBillCode(billCode);
			BillTypeEntity billTypeEntity = BeanMapper.map(billTypeVo, BillTypeEntity.class);
			billTypeService.saveOrUpdate(billTypeEntity, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询单据类型详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BillTypeVO> queryDetail(@RequestParam Long id) {
		BillTypeVO billTypeVo = billTypeService.queryDetail(id);
		return CommonResponse.success(billTypeVo);
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		billTypeService.delete(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getOrderMap().put("createTime", "desc");
		IPage<BillTypeEntity> pageData = billTypeService.queryPage(queryParam, false);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}

	/**
	 * 查询当前租户下整棵模块-单据类型树
	 *
	 * @return
	 */
	@GetMapping("/billTypeTree")
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> getBillTypeTree() {
		try {
			return CommonResponse.success(billTypeService.getBillTypeTree());
		} catch (Exception e) {
			logger.error("查询编码类型树异常,", e);
			return CommonResponse.error("查询编码类型树失败", e);
		}
	}
	/**
	 * 根据所传单据类型编码查询单据树-单据类型树
	 *
	 * @return
	 */
	@GetMapping("/billTypeTreeByCode")
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> billTypeTreeByCode(@RequestParam String codes) {
		try {
			return CommonResponse.success(billTypeService.getBillTypeTreeByCodes(codes));
		} catch (Exception e) {
			logger.error("查询编码类型树异常,", e);
			return CommonResponse.error("查询编码类型树失败", e);
		}
	}

	/**
	 * 参照查询（树表或表）
	 * 
	 * @param queryParam
	 * @return
	 */
   @GetMapping("pageListRef")
   public CommonResponse<IPage<BillTypeEntity>> loadReferModuleList(
			@RequestParam(defaultValue = "1") int pageNumber,
			@RequestParam(defaultValue = "10") int pageSize,
			@RequestParam(required=false) String relyCondition,
			@RequestParam(required=false) String searchText,
			@RequestParam(required=false) String condition
			) {
		QueryParam queryParam = new QueryParam();
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
//		queryParam .getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if(StringUtils.isNotBlank(searchText)){
			queryParam .getParams().put("billName", new Parameter(QueryParam.LIKE, searchText));
		}
    	if(StringUtils.isNotBlank(condition)){
    		JSONObject json = JSONObject.parseObject(condition);
    		//当为表参照时适配
    		if(json.get("moduleId")!=null){
    			Long moduleId = Long.parseLong(json.get("moduleId").toString());
    			queryParam.getParams().put("moduleId", new Parameter("eq",moduleId));
    		}
    	}
    	if(StringUtils.isNotBlank(relyCondition)){
    		//当为树表参照时适配（以树节点为主）
    		Long moduleId = Long.parseLong(relyCondition.split("=")[1]);
    		queryParam.getParams().put("moduleId", new Parameter("eq",moduleId));
    	}
		queryParam.getOrderMap().put("createTime", "desc");
		IPage<BillTypeEntity> pageData = billTypeService.queryPage(queryParam, false);
		return CommonResponse.success(pageData);
   }
   
   /**
    * 元数据参照
    * 
    * @param refCode
    * @return
    */
   @GetMapping("/findByCode")
   @ResponseBody
   public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
	   ReferVO refer = new ReferVO();
	   List<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
	   ReferShowfieldVO idHeader = new ReferShowfieldVO();
	   ReferShowfieldVO entityHeader = new ReferShowfieldVO();
	   ReferShowfieldVO displayHeader = new ReferShowfieldVO();
	   ReferShowfieldVO entityFullHeader = new ReferShowfieldVO();
	   
	   switch(refCode){
		case "metadata-treegrid":
			refer.setRefCode("metadata-treegrid");
			refer.setRefName("元数据");
			refer.setRefType("treegrid");
			refer.setTreerelyurl(environmentTools.getBaseHost()+"ejc-metadata-web/project/queryProjectTree");
			refer.setDataurl(environmentTools.getBaseHost()+"ejc-metadata-web/cls/referClsPage");
			refer.setIdField("id");
			refer.setCodeField("entityName");
			refer.setNameField("displayName");
			refer.setRelyfield("projectId");
			refer.setId(new Date().getTime());
			
			idHeader.setId(1l);
			idHeader.setName("主键");
			idHeader.setCode("id");
			idHeader.setHidden(true);
			idHeader.setShowOrder(1);
			idHeader.setType("string");
			gridHeaders.add(idHeader);
			entityHeader.setId(2l);
			entityHeader.setName("实体名称");
			entityHeader.setCode("entityName");
			entityHeader.setHidden(false);
			entityHeader.setShowOrder(1);
			entityHeader.setType("string");
			gridHeaders.add(entityHeader);
			displayHeader.setId(3l);
			displayHeader.setName("显示名称");
			displayHeader.setCode("displayName");
			displayHeader.setHidden(false);
			displayHeader.setShowOrder(1);
			displayHeader.setType("string");
			gridHeaders.add(displayHeader);
			entityFullHeader.setId(4l);
			entityFullHeader.setName("实体全名");
			entityFullHeader.setCode("entityFullName");
			entityFullHeader.setHidden(false);
			entityFullHeader.setShowOrder(1);
			entityFullHeader.setType("string");
			gridHeaders.add(entityFullHeader);
			refer.setGridheaders(gridHeaders);
			break;
		}
		
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", refer);
		return CommonResponse.success(refer);
	   
   }
	
	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			String scope = publishVO.getScope();
			if (StringUtils.isBlank(scope)) {
				return CommonResponse.error("发布数据失败:数据范围不能为空!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BillTypeEntity> baseEntities = null;
			if ("all".equalsIgnoreCase(scope)) { // 模块下的所有(包括本下)
				QueryParam queryParam = new QueryParam();
				List<ModuleVO> moduleVOs = moduleService.queryAllChildrenByPid(publishVO.getModuleId());
				List<Long> moduleIds = new ArrayList<>();
				for(ModuleVO vo : moduleVOs){
					moduleIds.add(vo.getId());
				}
				Map<String, Parameter> params = new HashMap<>();
				params.put("moduleId", new Parameter("in",moduleIds));
				queryParam.setParams(params);
				baseEntities = billTypeService.queryList(queryParam, false);
			} else if ("select".equalsIgnoreCase(scope)) { // 选中数据
				if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
					baseEntities = (List<BillTypeEntity>) billTypeService.listByIds(publishVO.getIdList());
				}else{
					return CommonResponse.error("未选中要发布的数据");
				}
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BillTypeEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getBillCode())) {
						codes.add(entity.getBillCode());
					}
				}
			}
			/*
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			*/
			PublishDataVO publishDataVO = new PublishDataVO();
			if(baseEntities!=null && baseEntities.size()>0){
				baseEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
			}
			publishDataVO.setIds(ids);
			publishDataVO.setBillTypeEntities(baseEntities);
			publishDataVO.setType("billType");
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			gson = new GsonBuilder().disableHtmlEscaping().create();
			String paramterStr = gson.toJson(publishDataVO);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				String result = ReferHttpClientUtils.postByJson(url, paramterStr);
				logger.info("发布数据返回的结果：---------------"+result);
				return gson.fromJson(result, CommonResponse.class);
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布参照数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布参照数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
		if (ids == null || ids.isEmpty()) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		for (Long id : ids) {
			idStr = idStr + "'" + id + "',";
		}
		String codeStr = "";
		for (String code : codes) {
			codeStr = codeStr + "'" + code + "',";
		}
		idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
		codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
		String baseTableName = "ejc_support_billtype";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
		String deleteByCodeSql = " delete from " + baseTableName + " where dr =1 and bill_code in " + codeStr + ";";
		sqlList.add(deleteBaseSql);
		sqlList.add(deleteByCodeSql);
		return sqlList;
	}
	private List<String> getInsertSql(List<BillTypeEntity> baseEntityList) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		return retList;
	}
	
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			String scope = publishVO.getScope();
			if (StringUtils.isBlank(scope)) {
				throw new BusinessException("导出脚本失败:数据范围不能为空!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BillTypeEntity> baseEntities = null;
			if ("all".equalsIgnoreCase(scope)) { // 模块下的所有(包括本下)
				QueryParam queryParam = new QueryParam();
				List<ModuleVO> moduleVOs = moduleService.queryAllChildrenByPid(publishVO.getModuleId());
				List<Long> moduleIds = new ArrayList<>();
				for(ModuleVO vo : moduleVOs){
					moduleIds.add(vo.getId());
				}
				Map<String, Parameter> params = new HashMap<>();
				params.put("moduleId", new Parameter("in",moduleIds));
				queryParam.setParams(params);
				baseEntities = billTypeService.queryList(queryParam, false);
			} else if ("select".equalsIgnoreCase(scope)) { // 选中数据
				if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
					baseEntities = (List<BillTypeEntity>) billTypeService.listByIds(publishVO.getIdList());
				}else{
					throw new BusinessException("未选中要导出脚本的数据!");
				}
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BillTypeEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getBillCode())) {
						codes.add(entity.getBillCode());
					}
				}
			}
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids, codes);
			List<String> insertSql = getInsertSql(baseEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			
			StringBuffer fileName = new StringBuffer();
			fileName.append("billType.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}
}
