package com.ejianc.foundation.supplier.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 供应商评价模板
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zy_supplier_comment_modle")
public class SupplierCommentModleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="supply_type")
    private String supplyType; // 供应商类别
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供应商类别
    @TableField(value="name")
    private String name; // 模板名称
    @TableField(value="create_org_id")
    private Long createOrgId; // 创建单位
    @TableField(value="create_org")
    private String createOrg; // 创建单位
    @TableField(value="create_user")
    private String createUser; // 创建人
    @TableField(value="comment_type")
    private String commentType; // 评价类别:process过程评价，thing事件评价，year年度评价
    @TableField(value="code")
    private String code; // 
    @TableField(value="state")
    private Boolean state; // 状态
    @TableField(value="create_date")
    private Date createDate; // 创建日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="supplierComModleContentService")//此处有pid="xxx"，默认值pid="pid"
    private List<SupplierComModleContentEntity> supplierComModleContentList = new ArrayList<>(); // 供应商评价模板内容
    

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(Long createOrgId) {
        this.createOrgId = createOrgId;
    }
    public String getCreateOrg() {
        return createOrg;
    }

    public void setCreateOrg(String createOrg) {
        this.createOrg = createOrg;
    }
    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }
    public String getCommentType() {
        return commentType;
    }

    public void setCommentType(String commentType) {
        this.commentType = commentType;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Boolean getState() {
        return state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    
    public List<SupplierComModleContentEntity> getSupplierComModleContentList() {
        return supplierComModleContentList;
    }

    public void setSupplierComModleContentList(List<SupplierComModleContentEntity> supplierComModleContentList) {
        this.supplierComModleContentList = supplierComModleContentList;
    }
}
