package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/customerApi/")
public class CustomerApi {

    @Autowired
    private ICustomerService customerService;

    @GetMapping("findOneByName")
    public CommonResponse<CustomerVO> findOneByName(@RequestParam(value = "name") String name,
                                                    @RequestParam(value = "tenantId") Long tenantId) {
        CustomerVO vo = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter(QueryParam.EQ, name));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

        List<CustomerEntity> list = customerService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), CustomerVO.class);
        }

        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据客户Id查询客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("queryById")
    CommonResponse<CustomerVO> detailById(@RequestParam(value = "id") Long id) {
        CustomerVO vo = customerService.queryDetail(id);
        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 同步
     * @param
     * @return
     */
    @RequestMapping(value = "syncCustomer",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CustomerVO> syncCustomer(@RequestBody CustomerVO customerVO) {
        CustomerVO vo = customerService.syncCustomer(customerVO);
        return CommonResponse.success("同步成功！", vo);
    }

}
