package com.ejianc.business.targetcost.api;

import com.ejianc.business.targetcost.hystrix.DutyHystrix;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


@FeignClient(name = "ejc-targetcost-web", url = "${common.env.feign-client-url}", path = "ejc-targetcost-web", fallback = DutyHystrix.class)
public interface IDutyApi {

    /**
     * 查询目标成本单据
     *
     * @param
     * @return
     */
    @PostMapping(value = "/api/duty/queryDuty")
    CommonResponse<List<Map<String, Object>>> queryDuty();

    /**
     * 查询物料档案明细汇总数量 取最新已生效
     *
     * @param
     * @return
     */
    @PostMapping(value = "/api/duty/queryDoc")
    CommonResponse<Map<Long, BigDecimal>> queryDoc(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查询费用明细汇总预估分类总量
     *
     * @param
     * @return
     */
    @PostMapping(value = "/api/duty/querySumPreTypeAmount")
    CommonResponse<Map<Long, BigDecimal>> querySumPreTypeAmount(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查询目标成本
     *
     * @param projectId docType 分类（档案）类型：1劳务分包方案、2专业分包档案、3物料档案、4设备档案、5成本科目
     * @return
     */
    @PostMapping(value = "/api/duty/queryDocDutyDetailItem")
    CommonResponse<Map<Long, DutyDetailItemVO>> queryDocDutyDetailItem(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "docType") Integer docType);


    /**
     * 根据档案主键集合查询目标成本价
     *
     * @return
     */
    @GetMapping(value = "/api/duty/queryPriceByDocIds")
    CommonResponse<Map<Long, BigDecimal>> queryPriceByDocIds(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "docType") Integer docType, @RequestParam(value = "docIds") List<Long> docIds);

    /**
     * 根据租赁档案主键集合查询目标成本价
     *
     * @return
     */
    @GetMapping(value = "/api/duty/queryPriceByRentDocIds")
    CommonResponse<Map<Long, BigDecimal>> queryPriceByRentDocIds(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "docType") Integer docType, @RequestParam(value = "docIds") List<Long> docIds);


    /**
     * 查询当前项目是否存在目标责任成本
     *
     * @return
     */
    @GetMapping(value = "/api/duty/queryDutyByProjectId")
    CommonResponse<Boolean> queryDutyByProjectId(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查询项目是否存在目标责任成本
     *
     * @return
     */
    @PostMapping(value = "/api/duty/queryExtInfoByProjectIds")
    CommonResponse<List<Long>> queryDutyByProjectIds(@RequestBody List<Long> projectIds);
}
