package com.ejianc.business.costinspection.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本巡检整改通知单
 * 
 * @author generator
 * 
 */
public class RectificationNoticeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String billCode; // 通知单编号
    private Integer billState; // 审批状态
    private String memo; // 备注
    private Long trackingId; // 跟踪单
    private String trackingCode; // 跟踪单编号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date inspectionTime; // 巡检时间
    private Long rectificationLeaderId; // 整改负责人
    private String rectificationLeader; // 整改负责人名称
    private Long rectificationPublisherId; // 整改单下发人
    private String rectificationPublisherName; // 整改单下发人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date rectificationNoticeTime; // 下发整改通知单时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date rectificationFinishTime; // 限时整改日期
    private List<RectificationNoticeContentVO> rectificationNoticeContentList = new ArrayList<>(); // 巡检整改回复子表


    public List<RectificationNoticeContentVO> getRectificationNoticeContentList() {
        return rectificationNoticeContentList;
    }

    public void setRectificationNoticeContentList(List<RectificationNoticeContentVO> rectificationNoticeContentList) {
        this.rectificationNoticeContentList = rectificationNoticeContentList;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="site_tracking")
    public Long getTrackingId() {
        return trackingId;
    }
    @ReferDeserialTransfer
    public void setTrackingId(Long trackingId) {
        this.trackingId = trackingId;
    }
    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getRectificationLeaderId() {
        return rectificationLeaderId;
    }
    @ReferDeserialTransfer
    public void setRectificationLeaderId(Long rectificationLeaderId) {
        this.rectificationLeaderId = rectificationLeaderId;
    }
    public String getRectificationLeader() {
        return rectificationLeader;
    }

    public void setRectificationLeader(String rectificationLeader) {
        this.rectificationLeader = rectificationLeader;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getRectificationPublisherId() {
        return rectificationPublisherId;
    }
    @ReferDeserialTransfer
    public void setRectificationPublisherId(Long rectificationPublisherId) {
        this.rectificationPublisherId = rectificationPublisherId;
    }
    public String getRectificationPublisherName() {
        return rectificationPublisherName;
    }

    public void setRectificationPublisherName(String rectificationPublisherName) {
        this.rectificationPublisherName = rectificationPublisherName;
    }
    public Date getRectificationNoticeTime() {
        return rectificationNoticeTime;
    }

    public void setRectificationNoticeTime(Date rectificationNoticeTime) {
        this.rectificationNoticeTime = rectificationNoticeTime;
    }
    public Date getRectificationFinishTime() {
        return rectificationFinishTime;
    }

    public void setRectificationFinishTime(Date rectificationFinishTime) {
        this.rectificationFinishTime = rectificationFinishTime;
    }
    
}
