package com.ejianc.business.costinspection.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本交底
 * 
 * @author generator
 * 
 */
public class DisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String billCode; // 单据编码
    private Integer billState; // 审批状态
    private String memo; // 备注
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date inspectionTime; // 立项时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date disclosureTime; // 交底时间
    private String projectLeaderId; // 交底人
    private String projectLeader; // 交底人名称
    private String costCommunicatId; // 受交底人
    private String costCommunicatName; // 受交底人名称
    private String disclosureType; // 交底形式
    private String disclosureContent; // 交底形式
    private Long applyId; // 申请单id
    private String applyCode; // 申请单编号
    private String disclosureOrTrain; // 交底、培训


    public String getDisclosureOrTrain() {
        return disclosureOrTrain;
    }

    public void setDisclosureOrTrain(String disclosureOrTrain) {
        this.disclosureOrTrain = disclosureOrTrain;
    }

    @ReferSerialTransfer(referCode="ref-disclosure-apply")
    public Long getApplyId() {
        return applyId;
    }
    @ReferDeserialTransfer
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }
    public Date getDisclosureTime() {
        return disclosureTime;
    }

    public void setDisclosureTime(Date disclosureTime) {
        this.disclosureTime = disclosureTime;
    }

    //@ReferSerialTransfer(referCode = "idm-user")
    public String getProjectLeaderId() {
        return projectLeaderId;
    }
    //@ReferDeserialTransfer
    public void setProjectLeaderId(String projectLeaderId) {
        this.projectLeaderId = projectLeaderId;
    }
    public String getProjectLeader() {
        return projectLeader;
    }

    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    public String getCostCommunicatId() {
        return costCommunicatId;
    }

    public void setCostCommunicatId(String costCommunicatId) {
        this.costCommunicatId = costCommunicatId;
    }
    public String getCostCommunicatName() {
        return costCommunicatName;
    }

    public void setCostCommunicatName(String costCommunicatName) {
        this.costCommunicatName = costCommunicatName;
    }
    public String getDisclosureType() {
        return disclosureType;
    }

    public void setDisclosureType(String disclosureType) {
        this.disclosureType = disclosureType;
    }
    public String getDisclosureContent() {
        return disclosureContent;
    }

    public void setDisclosureContent(String disclosureContent) {
        this.disclosureContent = disclosureContent;
    }
    
}
