package com.ejianc.business.targetcost.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.roadbridge.vo.*;
import com.ejianc.foundation.share.api.*;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class RoadbridgeHandler extends ConversionBaseHandler implements IConversioneHandler {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IShareEquipmentApi equipmentApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        RoadbridgeDutyVO roadbridgeDutyVO = (RoadbridgeDutyVO) baseVO;
        DutyEntity dutyEntity = BeanMapper.map(roadbridgeDutyVO, DutyEntity.class);
        dutyEntity.setFirstImportId(roadbridgeDutyVO.getBaseDutyId());
        dutyEntity.setImportId(roadbridgeDutyVO.getId());
        dutyEntity.setMemo(roadbridgeDutyVO.getProjectProfile());
        dutyEntity.setImportType(ConversionEnum.云南路桥.getCode());

        for (DutyPlansVO plansVO : roadbridgeDutyVO.getDutyPlansList()) {
            if("不可预见费".equals(plansVO.getPlansDetailName())){
                dutyEntity.setUnExceptMny(plansVO.getPlansPlanMny());
            }else if("税金".equals(plansVO.getPlansDetailName())){
                dutyEntity.setTax(plansVO.getPlansPlanMny());
            }
        }

        handlerHead(dutyEntity, isEff, baseVO);

        return CommonResponse.success("导入转换目标成本单据成功！");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        deleteDuty(importId);
        return CommonResponse.success("删除目标成本单据成功！");
    }

    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        RoadbridgeDutyVO roadbridgeDutyVO = (RoadbridgeDutyVO) baseVO;

        ExecutorService threadPool = Executors.newFixedThreadPool(5);

        //200-1300章
        Callable<DutyEntity> twoCallable = new TwoChangeCallable(labsubApi, prosubApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> twoFuture = threadPool.submit(twoCallable);

        //主要材料费
        Callable<DutyEntity> materialCallable = new MaterialChangeCallable(materialApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> materialFuture = threadPool.submit(materialCallable);

        //周转材料费
        Callable<DutyEntity> rmatCallable = new RmatChangeCallable(materialApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> rmatFuture = threadPool.submit(rmatCallable);

        //机械设备费
        Callable<DutyEntity> equipCallable = new EquipChangeCallable(equipmentApi, roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> equipFuture = threadPool.submit(equipCallable);

        //其他页签
        Callable<DutyEntity> othCallable = new OtherChangeCallable(roadbridgeDutyVO, dutyEntity, feeVO);
        Future<DutyEntity> othFuture = threadPool.submit(othCallable);

        List<DutyEntity> dutyList = new ArrayList<>();
        try {
            dutyList.add(twoFuture.get());
            dutyList.add(materialFuture.get());
            dutyList.add(rmatFuture.get());
            dutyList.add(equipFuture.get());
            dutyList.add(othFuture.get());
        } catch (Exception e) {
            logger.error("查询数据异常", e);
            throw new BusinessException("路桥导入转换失败！");
        } finally {
            threadPool.shutdown();
        }

        return dutyList;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        //间接费
        boolean jjfFlag = false;
        //其他工程费
        boolean qtgcfFlag = false;
        //100章费用
        boolean hunFlag = false;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if ("间接费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                jjfFlag = true;
            }
            if ("其他工程费".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                qtgcfFlag = true;
            }
            if ("100章费用".equals(detailVO.getName()) && null == detailVO.getParentId()) {
                hunFlag = true;
            }
        }
        if (!jjfFlag) {
            throw new BusinessException("费用模板中未配置【间接费】的费用项，无法转换！");
        }
        if (!qtgcfFlag) {
            throw new BusinessException("费用模板中未配置【其他工程费】的费用项，无法转换！");
        }
        if (!hunFlag) {
            throw new BusinessException("费用模板中未配置【100章费用】的费用项，无法转换！");
        }
    }

    class TwoChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareLabsubApi shareLabsubApi;
        private IShareProsubApi shareProsubApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public TwoChangeCallable(IShareLabsubApi shareLabsubApi, IShareProsubApi shareProsubApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareLabsubApi = shareLabsubApi;
            this.shareProsubApi = shareProsubApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //先判断费用模板有无关联人工费和专业分包费
            //人工费
            Long rgfId = null;
            //专业分包费
            Long zyfbId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238533").equals(detailVO.getFeePropId())) {
                    rgfId = detailVO.getId();
                }
                if (Long.valueOf("546645586985238540").equals(detailVO.getFeePropId())) {
                    zyfbId = detailVO.getId();
                }
            }
            if (null == rgfId) {
                throw new BusinessException("费用模板中未配置【人工费】的费用项，无法转换！");
            }
            if (null == zyfbId) {
                throw new BusinessException("费用模板中未配置【专业分包费】的费用项，无法转换！");
            }
            //人工费下的主键集合
            Set<Long> rgfSet = new HashSet<>();
            //专业分包费下的主键集合
            Set<Long> zyfbSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(rgfId))) {
                    rgfSet.add(detailVO.getId());
                }
                if (detailVO.getInnerCode().contains(String.valueOf(zyfbId))) {
                    zyfbSet.add(detailVO.getId());
                }
            }
            //其他人工费
            Long qtrgfId = null;
            //其他专业分包费
            Long qtzyfbId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) && rgfSet.contains(detailVO.getId())) {
                    qtrgfId = detailVO.getId();
                }
                if (Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) && zyfbSet.contains(detailVO.getId())) {
                    qtzyfbId = detailVO.getId();
                }
            }
            if (null == qtrgfId) {
                throw new BusinessException("费用模板中未配置【其他人工费】的费用项，无法转换！");
            }
            if (null == qtzyfbId) {
                throw new BusinessException("费用模板中未配置【其他专业分包费】的费用项，无法转换！");
            }

            List<String> codeList = new ArrayList<>();
            List<DutyTwoVO> addList = new ArrayList<>();
            for (DutyTwoVO twoVO : roadbridgeDutyVO.getDutyTwoList()) {
                if (null != twoVO.getLeafFlag() && twoVO.getLeafFlag()) {
                    if (twoVO.getTwoDetailCode().startsWith("GL")) {
                        if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals(twoVO.getTwoJxPrice(), BigDecimal.ZERO)) {
                            //机械费和人工费都有值，需要拆分成两行，并且把另一种单价置空
                            if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals(twoVO.getTwoRgPrice(), BigDecimal.ZERO)) {
                                DutyTwoVO dutyTwoVO = BeanMapper.map(twoVO, DutyTwoVO.class);
                                dutyTwoVO.setTwoJxPrice(null);
                                addList.add(dutyTwoVO);
                                codeList.add(dutyTwoVO.getTwoDetailCode());
                            }
                            twoVO.setTwoRgPrice(null);
                            twoVO.setTwoDetailCode(twoVO.getTwoDetailCode().replace("GL", "GJ"));
                        }
                        codeList.add(twoVO.getTwoDetailCode());
                    } else if (twoVO.getTwoDetailCode().startsWith("GZ")) {
                        codeList.add(twoVO.getTwoDetailCode());
                    } else {
                        if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals(twoVO.getTwoJxPrice(), BigDecimal.ZERO)) {
                            //机械费和人工费都有值，需要拆分成两行，并且把另一种单价置空
                            if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals(twoVO.getTwoRgPrice(), BigDecimal.ZERO)) {
                                DutyTwoVO dutyTwoVO = BeanMapper.map(twoVO, DutyTwoVO.class);
                                dutyTwoVO.setTwoJxPrice(null);
                                addList.add(dutyTwoVO);
                                codeList.add(dutyTwoVO.getTwoDetailCode());
                            }
                            twoVO.setTwoRgPrice(null);
                            twoVO.setTwoDetailCode(twoVO.getTwoDetailCode().replace("GL", "GJ"));
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(addList)) {
                roadbridgeDutyVO.getDutyTwoList().addAll(addList);
            }

            //200-1300章
            CommonResponse<List<LabsubCategoryVO>> labCtyResponse = shareLabsubApi.queryCategoryListByIds(new ArrayList<>());
            //劳务分包分类的内码map
            Map<Long, String> labCtyInnerCodeMap = new HashMap<>();
            if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(labCtyResponse.getData())) {
                labCtyInnerCodeMap = labCtyResponse.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
            }

            Map<String, LabsubItemVO> labSubMap = new HashMap<>();
            CommonResponse<List<LabsubItemVO>> labItemResponse = shareLabsubApi.queryItemListByCodes(codeList);
            if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty(labItemResponse.getData())) {
                labSubMap = labItemResponse.getData().stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }

            CommonResponse<List<ProsubCategoryVO>> proCtyResponse = shareProsubApi.queryCategoryListByIds(new ArrayList<>());
            //专业分包分类的内码map
            Map<Long, String> proCtyInnerCodeMap = new HashMap<>();
            if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(proCtyResponse.getData())) {
                proCtyInnerCodeMap = proCtyResponse.getData().stream().collect(Collectors.toMap(ProsubCategoryVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
            }

            Map<String, ProsubItemVO> proSubMap = new HashMap<>();
            CommonResponse<List<ProsubItemVO>> proItemResponse = shareProsubApi.queryItemListByCodes(codeList);

            if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty(proItemResponse.getData())) {
                proSubMap = proItemResponse.getData().stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }

            for (DutyTwoVO twoVO : roadbridgeDutyVO.getDutyTwoList()) {
                if (null == twoVO.getLeafFlag() || !twoVO.getLeafFlag()) {
                    continue;
                }
                if ((null == twoVO.getTwoRgPrice() || ComputeUtil.equals(twoVO.getTwoRgPrice(), BigDecimal.ZERO))
                        && (null == twoVO.getTwoJxPrice() || ComputeUtil.equals(twoVO.getTwoJxPrice(), BigDecimal.ZERO))
                        && (null == twoVO.getTwoSubPrice() || ComputeUtil.equals(twoVO.getTwoSubPrice(), BigDecimal.ZERO))) {
                    continue;
                }
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (twoVO.getTwoDetailCode().startsWith("GL") || twoVO.getTwoDetailCode().startsWith("GJ")) {
                        //匹配到档案
                        if (labSubMap.containsKey(twoVO.getTwoDetailCode())) {
                            LabsubItemVO labsubItemVO = labSubMap.get(twoVO.getTwoDetailCode());
                            String innerCode = labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                            //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“人工费”下的
                            if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                    || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                    && rgfSet.contains(detailEntity.getFeeDetailId()))) {
                                List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                                itemEntity.setId(IdWorker.getId());
                                itemEntity.setCode(labsubItemVO.getTrawlingCode());
                                itemEntity.setName(labsubItemVO.getTrawlingName());
                                itemEntity.setPriceType(labsubItemVO.getPriceType());
                                itemEntity.setJobContent(labsubItemVO.getJobContent());
                                itemEntity.setUnitName(labsubItemVO.getUnitName());
                                //目标成本综合单价 -【人工费】不为空或0
                                if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals(twoVO.getTwoRgPrice(), BigDecimal.ZERO)) {
                                    itemEntity.setPrice(twoVO.getTwoRgPrice());
                                    itemEntity.setTaxPrice(twoVO.getTwoRgPrice());
                                    itemEntity.setAmount(twoVO.getTwoNum());
                                    itemEntity.setMny(twoVO.getTwoRgMny());
                                    itemEntity.setTaxMny(twoVO.getTwoRgMny());
                                    itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                                    itemEntity.setCategoryInnerCode(innerCode);
                                    itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                                    itemEntity.setDocType(DocTypeEnum.劳务分包档案.getCode());
                                    itemEntity.setDocId(labsubItemVO.getId());
                                    itemList.add(itemEntity);
                                    detailEntity.setDutyDetailItemList(itemList);
                                } else if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals(twoVO.getTwoJxPrice(), BigDecimal.ZERO)) {
                                    itemEntity.setPrice(twoVO.getTwoJxPrice());
                                    itemEntity.setTaxPrice(twoVO.getTwoJxPrice());
                                    itemEntity.setAmount(twoVO.getTwoNum());
                                    itemEntity.setMny(twoVO.getTwoJxMny());
                                    itemEntity.setTaxMny(twoVO.getTwoJxMny());
                                    itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                                    itemEntity.setCategoryInnerCode(innerCode);
                                    itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                                    itemEntity.setDocType(DocTypeEnum.劳务分包档案.getCode());
                                    itemEntity.setDocId(labsubItemVO.getId());
                                    itemList.add(itemEntity);
                                    detailEntity.setDutyDetailItemList(itemList);
                                }
                            }
                        } else if (detailEntity.getFeeDetailId().equals(qtrgfId)) {//匹配不到档案且子表为“其他人工费”
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(twoVO.getTwoDetailCode());
                            itemEntity.setName(twoVO.getTwoDetailName());
                            itemEntity.setUnitName(twoVO.getTwoUnitName());
                            //目标成本综合单价 -【人工费】不为空或0
                            if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals(twoVO.getTwoRgPrice(), BigDecimal.ZERO)) {
                                itemEntity.setPrice(twoVO.getTwoRgPrice());
                                itemEntity.setTaxPrice(twoVO.getTwoRgPrice());
                                itemEntity.setAmount(twoVO.getTwoNum());
                                itemEntity.setMny(twoVO.getTwoRgMny());
                                itemEntity.setTaxMny(twoVO.getTwoRgMny());
                                itemEntity.setDocType(6);
                                itemList.add(itemEntity);
                                detailEntity.setDutyDetailItemList(itemList);
                            } else if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals(twoVO.getTwoJxPrice(), BigDecimal.ZERO)) {
                                itemEntity.setPrice(twoVO.getTwoJxPrice());
                                itemEntity.setTaxPrice(twoVO.getTwoJxPrice());
                                itemEntity.setAmount(twoVO.getTwoNum());
                                itemEntity.setMny(twoVO.getTwoJxMny());
                                itemEntity.setTaxMny(twoVO.getTwoJxMny());
                                itemEntity.setDocType(6);
                                itemList.add(itemEntity);
                                detailEntity.setDutyDetailItemList(itemList);
                            }
                        }
                    } else if (twoVO.getTwoDetailCode().startsWith("GZ") && (null != twoVO.getTwoSubPrice() && !ComputeUtil.equals(twoVO.getTwoSubPrice(), BigDecimal.ZERO))) {
                        //匹配到档案
                        if (proSubMap.containsKey(twoVO.getTwoDetailCode())) {
                            ProsubItemVO prosubItemVO = proSubMap.get(twoVO.getTwoDetailCode());
                            String innerCode = proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                            if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                    || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                    && rgfSet.contains(detailEntity.getFeeDetailId()))) {
                                List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                                DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                                itemEntity.setId(IdWorker.getId());
                                itemEntity.setCode(prosubItemVO.getTrawlingCode());
                                itemEntity.setName(prosubItemVO.getTrawlingName());
                                itemEntity.setPriceType(prosubItemVO.getPriceType());
                                itemEntity.setJobContent(prosubItemVO.getJobContent());
                                itemEntity.setUnitName(prosubItemVO.getUnitName());
                                itemEntity.setPrice(twoVO.getTwoSubPrice());
                                itemEntity.setTaxPrice(twoVO.getTwoSubPrice());
                                itemEntity.setAmount(twoVO.getTwoNum());
                                itemEntity.setMny(twoVO.getTwoSubMny());
                                itemEntity.setTaxMny(twoVO.getTwoSubMny());
                                itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                                itemEntity.setCategoryInnerCode(innerCode);
                                itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                                itemEntity.setDocType(DocTypeEnum.专业分包档案.getCode());
                                itemEntity.setDocId(prosubItemVO.getId());
                                itemList.add(itemEntity);
                                detailEntity.setDutyDetailItemList(itemList);
                            }
                        } else if (detailEntity.getFeeDetailId().equals(qtzyfbId)) {//匹配不到档案且子表为“其他专业分包费”
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(twoVO.getTwoDetailCode());
                            itemEntity.setName(twoVO.getTwoDetailName());
                            itemEntity.setUnitName(twoVO.getTwoUnitName());
                            itemEntity.setPrice(twoVO.getTwoSubPrice());
                            itemEntity.setTaxPrice(twoVO.getTwoSubPrice());
                            itemEntity.setAmount(twoVO.getTwoNum());
                            itemEntity.setMny(twoVO.getTwoSubMny());
                            itemEntity.setTaxMny(twoVO.getTwoSubMny());
                            itemEntity.setDocType(6);
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(twoVO.getTwoDetailCode());
                        itemEntity.setName(twoVO.getTwoDetailName());
                        itemEntity.setUnitName(twoVO.getTwoUnitName());
                        if (null != twoVO.getTwoRgPrice() && !ComputeUtil.equals(twoVO.getTwoRgPrice(), BigDecimal.ZERO) && detailEntity.getFeeDetailId().equals(qtrgfId)) {
                            itemEntity.setPrice(twoVO.getTwoRgPrice());
                            itemEntity.setTaxPrice(twoVO.getTwoRgPrice());
                            itemEntity.setAmount(twoVO.getTwoNum());
                            itemEntity.setMny(twoVO.getTwoRgMny());
                            itemEntity.setTaxMny(twoVO.getTwoRgMny());
                            itemEntity.setDocType(6);
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        } else if (null != twoVO.getTwoJxPrice() && !ComputeUtil.equals(twoVO.getTwoJxPrice(), BigDecimal.ZERO) && detailEntity.getFeeDetailId().equals(qtrgfId)) {
                            itemEntity.setPrice(twoVO.getTwoJxPrice());
                            itemEntity.setTaxPrice(twoVO.getTwoJxPrice());
                            itemEntity.setAmount(twoVO.getTwoNum());
                            itemEntity.setMny(twoVO.getTwoJxMny());
                            itemEntity.setTaxMny(twoVO.getTwoJxMny());
                            itemEntity.setDocType(6);
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        } else if (null != twoVO.getTwoSubPrice() && !ComputeUtil.equals(twoVO.getTwoSubPrice(), BigDecimal.ZERO) && detailEntity.getFeeDetailId().equals(qtzyfbId)) {
                            itemEntity.setPrice(twoVO.getTwoSubPrice());
                            itemEntity.setTaxPrice(twoVO.getTwoSubPrice());
                            itemEntity.setAmount(twoVO.getTwoNum());
                            itemEntity.setMny(twoVO.getTwoSubMny());
                            itemEntity.setTaxMny(twoVO.getTwoSubMny());
                            itemEntity.setDocType(6);
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    }
                }
            }
            return dutyEntity;
        }
    }

    class MaterialChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public MaterialChangeCallable(IShareMaterialApi shareMaterialApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }


        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            Map<Long, String> matCtyLongInnerMap = new HashMap<>();
            Map<String, String> matCtyStringInnerMap = new HashMap<>();
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);

            //先判断费用模板有无关联材料费
            //材料费
            Long clfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238535").equals(detailVO.getFeePropId())) {
                    clfId = detailVO.getId();
                }
            }
            if (null == clfId) {
                throw new BusinessException("费用模板中未配置【材料费】的费用项，无法转换！");
            }
            //材料费下的主键集合
            Set<Long> clfSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(clfId))) {
                    clfSet.add(detailVO.getId());
                }
            }
            //其他材料费
            Long qtclfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) && clfSet.contains(detailVO.getId())) {
                    qtclfId = detailVO.getId();
                }
            }
            if (null == qtclfId) {
                throw new BusinessException("费用模板中未配置【其他材料费】的费用项，无法转换！");
            }

            List<String> codeList = roadbridgeDutyVO.getDutyMaterialList().stream().filter(materialVO -> StringUtils.isNotBlank(materialVO.getMaterialCode())).map(DutyMaterialVO::getMaterialCode).collect(Collectors.toList());

            CommonResponse<List<MaterialVO>> matResponse = shareMaterialApi.queryMaterialListByCodes(codeList);

            Map<String, MaterialVO> matMap = new HashMap<>();
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
                matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }

            int num = 1;
            for (DutyMaterialVO dutyMaterialVO : roadbridgeDutyVO.getDutyMaterialList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (StringUtils.isNotBlank(dutyMaterialVO.getMaterialCode())) {
                        if (matMap.containsKey(dutyMaterialVO.getMaterialCode())) {
                            MaterialVO materialVO = matMap.get(dutyMaterialVO.getMaterialCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = response.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else {
                            if (!matCtyStringInnerMap.containsKey(dutyMaterialVO.getMaterialCode())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryByCode(dutyMaterialVO.getMaterialCode());
                                if (response.isSuccess() && null != response.getData()) {
                                    MaterialCategoryVO categoryVO = response.getData();
                                    matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                    matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                                }
                            }
                        }
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(dutyMaterialVO.getMaterialCode()) && matMap.containsKey(dutyMaterialVO.getMaterialCode())) {
                        MaterialVO materialVO = matMap.get(dutyMaterialVO.getMaterialCode());
                        String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && clfSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(materialVO.getCode());
                            itemEntity.setName(materialVO.getName());
                            itemEntity.setModel(materialVO.getSpec());
                            itemEntity.setUnitId(materialVO.getUnitId());
                            itemEntity.setUnitName(materialVO.getUnitName());
                            itemEntity.setPrice(dutyMaterialVO.getMaterialPrice());
                            itemEntity.setTaxPrice(dutyMaterialVO.getMaterialPrice());
                            itemEntity.setAmount(dutyMaterialVO.getMaterialNum());
                            itemEntity.setMny(dutyMaterialVO.getMaterialMny());
                            itemEntity.setTaxMny(dutyMaterialVO.getMaterialMny());
                            itemEntity.setCategoryId(materialVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(materialVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
                            itemEntity.setDocId(materialVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (StringUtils.isNotBlank(dutyMaterialVO.getMaterialCode()) && matCtyStringInnerMap.containsKey(dutyMaterialVO.getMaterialCode())) {//匹配到分类
                        String innerCode = matCtyStringInnerMap.get(dutyMaterialVO.getMaterialCode());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && clfSet.contains(detailEntity.getFeeDetailId()))) {
                            detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), dutyMaterialVO.getMaterialNum()));
                            detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), dutyMaterialVO.getMaterialMny()));
                            detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), dutyMaterialVO.getMaterialMny()));
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtclfId)) {//匹配不到档案且子表为“其他材料费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(dutyMaterialVO.getMaterialCode())) {
                            itemEntity.setCode(String.valueOf(num));
                            num++;
                        } else {
                            itemEntity.setCode(dutyMaterialVO.getMaterialCode());
                        }
                        itemEntity.setName(dutyMaterialVO.getMaterialName());
                        itemEntity.setUnitName(dutyMaterialVO.getMaterialUnitName());
                        itemEntity.setPrice(dutyMaterialVO.getMaterialPrice());
                        itemEntity.setTaxPrice(dutyMaterialVO.getMaterialPrice());
                        itemEntity.setAmount(dutyMaterialVO.getMaterialNum());
                        itemEntity.setMny(dutyMaterialVO.getMaterialMny());
                        itemEntity.setTaxMny(dutyMaterialVO.getMaterialMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
            return dutyEntity;
        }
    }

    class RmatChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareMaterialApi shareMaterialApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public RmatChangeCallable(IShareMaterialApi shareMaterialApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareMaterialApi = shareMaterialApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }


        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            Map<Long, String> matCtyLongInnerMap = new HashMap<>();
            Map<String, String> matCtyStringInnerMap = new HashMap<>();
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //先判断费用模板有无关联周转材材料费
            //周转材材料费
            Long zzcId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238537").equals(detailVO.getFeePropId())) {
                    zzcId = detailVO.getId();
                }
            }
            if (null == zzcId) {
                throw new BusinessException("费用模板中未配置【周转材料费】的费用项，无法转换！");
            }
            //周转材材料费下的主键集合
            Set<Long> zzcSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(zzcId))) {
                    zzcSet.add(detailVO.getId());
                }
            }
            //其他周转材材料费
            Long qtzzcId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238538").equals(detailVO.getFeePropId()) && zzcSet.contains(detailVO.getId())) {
                    qtzzcId = detailVO.getId();
                }
            }
            if (null == qtzzcId) {
                throw new BusinessException("费用模板中未配置【其他周转材料费】的费用项，无法转换！");
            }

            List<String> codeList = roadbridgeDutyVO.getDutyRmatList().stream().filter(dutyRmatVO -> StringUtils.isNotBlank(dutyRmatVO.getRmatCode())).map(DutyRmatVO::getRmatCode).collect(Collectors.toList());

            CommonResponse<List<MaterialVO>> matResponse = shareMaterialApi.queryMaterialListByCodes(codeList);
            Map<String, MaterialVO> matMap = new HashMap<>();
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
                matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
            }

            int num = 1;
            for (DutyRmatVO rmatVO : roadbridgeDutyVO.getDutyRmatList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (StringUtils.isNotBlank(rmatVO.getRmatCode())) {
                        if (matMap.containsKey(rmatVO.getRmatCode())) {
                            MaterialVO materialVO = matMap.get(rmatVO.getRmatCode());
                            if (!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryById(materialVO.getCategoryId());
                                MaterialCategoryVO categoryVO = response.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        } else {
                            if (!matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {
                                CommonResponse<MaterialCategoryVO> response = shareMaterialApi.queryCategoryByCode(rmatVO.getRmatCode());
                                if (response.isSuccess() && null != response.getData()) {
                                    MaterialCategoryVO categoryVO = response.getData();
                                    matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                    matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                                }
                            }
                        }
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && matMap.containsKey(rmatVO.getRmatCode())) {
                        MaterialVO materialVO = matMap.get(rmatVO.getRmatCode());
                        String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && zzcSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(materialVO.getCode());
                            itemEntity.setName(materialVO.getName());
                            itemEntity.setModel(materialVO.getSpec());
                            itemEntity.setUnitId(materialVO.getUnitId());
                            itemEntity.setUnitName(materialVO.getUnitName());
                            itemEntity.setPrice(rmatVO.getRmatPrice());
                            itemEntity.setTaxPrice(rmatVO.getRmatPrice());
                            itemEntity.setAmount(rmatVO.getRmatNum());
                            itemEntity.setMny(rmatVO.getRmatCostMny());
                            itemEntity.setTaxMny(rmatVO.getRmatCostMny());
                            itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                            itemEntity.setCategoryId(materialVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(materialVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
                            itemEntity.setDocId(materialVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (StringUtils.isNotBlank(rmatVO.getRmatCode()) && matCtyStringInnerMap.containsKey(rmatVO.getRmatCode())) {//匹配到分类
                        String innerCode = matCtyStringInnerMap.get(rmatVO.getRmatCode());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“周转材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && zzcSet.contains(detailEntity.getFeeDetailId()))) {
                            detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), rmatVO.getRmatNum()));
                            detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), rmatVO.getRmatCostMny()));
                            detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), rmatVO.getRmatCostMny()));
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtzzcId)) {//匹配不到档案且子表为“其他周转材料费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(rmatVO.getRmatCode())) {
                            itemEntity.setCode(String.valueOf(num));
                            num++;
                        } else {
                            itemEntity.setCode(rmatVO.getRmatCode());
                        }
                        itemEntity.setName(rmatVO.getRmatName());
                        itemEntity.setUnitName(rmatVO.getRmatUnitName());
                        itemEntity.setRmatRentMonth(rmatVO.getRmatRentMonth());
                        itemEntity.setPrice(rmatVO.getRmatPrice());
                        itemEntity.setTaxPrice(rmatVO.getRmatPrice());
                        itemEntity.setAmount(rmatVO.getRmatNum());
                        itemEntity.setMny(rmatVO.getRmatCostMny());
                        itemEntity.setTaxMny(rmatVO.getRmatCostMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
            return dutyEntity;
        }
    }

    class EquipChangeCallable implements Callable<DutyEntity> {

        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private IShareEquipmentApi shareEquipmentApi;
        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public EquipChangeCallable(IShareEquipmentApi shareEquipmentApi, RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.shareEquipmentApi = shareEquipmentApi;
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            RequestContextHolder.setRequestAttributes(context);
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //机械设备费
            Long jxfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238542").equals(detailVO.getFeePropId())) {
                    jxfId = detailVO.getId();
                }
            }
            if (null == jxfId) {
                throw new BusinessException("费用模板中未配置【机械设备费】的费用项，无法转换！");
            }
            //机械设备费下的主键集合
            Set<Long> jxfSet = new HashSet<>();
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (detailVO.getInnerCode().contains(String.valueOf(jxfId))) {
                    jxfSet.add(detailVO.getId());
                }
            }
            //其他机械设备费
            Long qtjxfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if (Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) && jxfSet.contains(detailVO.getId())) {
                    qtjxfId = detailVO.getId();
                }
            }
            if (null == qtjxfId) {
                throw new BusinessException("费用模板中未配置【其他机械设备费】的费用项，无法转换！");
            }

            CommonResponse<List<EquipmentCategoryVO>> equipCtyResponse = shareEquipmentApi.queryCategoryListByIds(new ArrayList<>());
            Map<Long, String> equipCtyLongInnerMap = new HashMap<>();
            Map<String, String> equipCtyStringInnerMap = new HashMap<>();
            for (EquipmentCategoryVO categoryVO : equipCtyResponse.getData()) {
                equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
            }


            List<String> codeList = roadbridgeDutyVO.getDutyEquipmentList().stream().filter(dutyEquipmentVO -> StringUtils.isNotBlank(dutyEquipmentVO.getEquipmentCode())).map(DutyEquipmentVO::getEquipmentCode).collect(Collectors.toList());

            CommonResponse<List<EquipmentVO>> equipResponse = shareEquipmentApi.queryEquipmentListByCodes(codeList);
            logger.error(JSONObject.toJSONString(codeList));
            logger.error(JSONObject.toJSONString(equipResponse));
            Map<String, EquipmentVO> equipMap = new HashMap<>();
            if (equipResponse.isSuccess() && CollectionUtils.isNotEmpty(equipResponse.getData())) {
                equipMap = equipResponse.getData().stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
            }

            int num = 1;
            for (DutyEquipmentVO dutyEquipmentVO : roadbridgeDutyVO.getDutyEquipmentList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    //匹配到档案
                    if (StringUtils.isNotBlank(dutyEquipmentVO.getEquipmentCode()) && equipMap.containsKey(dutyEquipmentVO.getEquipmentCode())) {
                        EquipmentVO equipmentVO = equipMap.get(dutyEquipmentVO.getEquipmentCode());
                        String innerCode = equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                            List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                            DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                            itemEntity.setId(IdWorker.getId());
                            itemEntity.setCode(equipmentVO.getCode());
                            itemEntity.setName(equipmentVO.getName());
                            itemEntity.setModel(equipmentVO.getSpec());
                            itemEntity.setUnitId(equipmentVO.getUnitId());
                            itemEntity.setUnitName(equipmentVO.getUnitName());
                            itemEntity.setPrice(dutyEquipmentVO.getEquipmentPrice());
                            itemEntity.setTaxPrice(dutyEquipmentVO.getEquipmentPrice());
                            itemEntity.setAmount(dutyEquipmentVO.getEquipmentNum());
                            itemEntity.setMny(dutyEquipmentVO.getEquipmentCostMny());
                            itemEntity.setTaxMny(dutyEquipmentVO.getEquipmentCostMny());
                            itemEntity.setRmatRentMonth(dutyEquipmentVO.getEquipmentRentMonth());
                            itemEntity.setCategoryId(equipmentVO.getCategoryId());
                            itemEntity.setCategoryInnerCode(innerCode);
                            itemEntity.setCategoryName(equipmentVO.getCategoryName());
                            itemEntity.setDocType(DocTypeEnum.设备档案.getCode());
                            itemEntity.setDocId(equipmentVO.getId());
                            itemList.add(itemEntity);
                            detailEntity.setDutyDetailItemList(itemList);
                        }
                    } else if (StringUtils.isNotBlank(dutyEquipmentVO.getEquipmentCode()) && equipCtyStringInnerMap.containsKey(dutyEquipmentVO.getEquipmentCode())) {//匹配到分类
                        String innerCode = equipCtyStringInnerMap.get(dutyEquipmentVO.getEquipmentCode());
                        //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                        if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                                || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                                && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                            detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), dutyEquipmentVO.getEquipmentNum()));
                            detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), dutyEquipmentVO.getEquipmentCostMny()));
                            detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), dutyEquipmentVO.getEquipmentCostMny()));
                        }
                    } else if (detailEntity.getFeeDetailId().equals(qtjxfId)) {//匹配不到档案且子表为“其他机械设备费”
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        if (StringUtils.isBlank(dutyEquipmentVO.getEquipmentCode())) {
                            itemEntity.setCode(String.valueOf(num));
                        } else {
                            itemEntity.setCode(dutyEquipmentVO.getEquipmentCode());
                        }
                        itemEntity.setName(dutyEquipmentVO.getEquipmentName());
                        itemEntity.setUnitName(dutyEquipmentVO.getEquipmentUnitName());
                        itemEntity.setPrice(dutyEquipmentVO.getEquipmentPrice());
                        itemEntity.setTaxPrice(dutyEquipmentVO.getEquipmentPrice());
                        itemEntity.setAmount(dutyEquipmentVO.getEquipmentNum());
                        itemEntity.setMny(dutyEquipmentVO.getEquipmentCostMny());
                        itemEntity.setTaxMny(dutyEquipmentVO.getEquipmentCostMny());
                        itemEntity.setRmatRentMonth(dutyEquipmentVO.getEquipmentRentMonth());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                if (StringUtils.isBlank(dutyEquipmentVO.getEquipmentCode())) {
                    num++;
                }
            }
            return dutyEntity;
        }
    }

    class OtherChangeCallable implements Callable<DutyEntity> {

        private RoadbridgeDutyVO roadbridgeDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;

        public OtherChangeCallable(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO) {
            this.roadbridgeDutyVO = roadbridgeDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
        }

        @Override
        public DutyEntity call() {
            DutyEntity dutyEntity = BeanMapper.map(baseDutyEntity, DutyEntity.class);
            //间接费
            dealJjfData(roadbridgeDutyVO, dutyEntity, feeVO);
            //其他工程费
            dealOtherData(roadbridgeDutyVO, dutyEntity, feeVO);
            //100章费用
            dealOneData(roadbridgeDutyVO, dutyEntity, feeVO);
            return dutyEntity;
        }

        private void dealJjfData(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //先判断费用模板有无关联间接费
            //间接费
            Long jjfId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("间接费".equals(detailVO.getName())) {
                    jjfId = detailVO.getId();
                }
            }
            int num = 1;
            for (DutyJjfVO jjfVO : roadbridgeDutyVO.getDutyJjfList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(jjfId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(String.valueOf(num));
                        itemEntity.setName(jjfVO.getJjfName());
                        itemEntity.setUnitName(jjfVO.getJjfUnitName());
                        itemEntity.setSubjectName(jjfVO.getSubjectName());
                        itemEntity.setMny(jjfVO.getJjfMny());
                        itemEntity.setTaxMny(jjfVO.getJjfMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealOtherData(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //其他工程费
            Long otherId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("其他工程费".equals(detailVO.getName())) {
                    otherId = detailVO.getId();
                }
            }
            int num = 1;
            for (DutyOtherVO otherVO : roadbridgeDutyVO.getDutyOtherList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(otherId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(String.valueOf(num));
                        itemEntity.setName(otherVO.getOtherName());
                        itemEntity.setUnitName(otherVO.getOtherUnitName());
                        itemEntity.setSubjectName(otherVO.getSubjectName());
                        itemEntity.setMny(otherVO.getOtherMny());
                        itemEntity.setTaxMny(otherVO.getOtherMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
                num++;
            }
        }

        private void dealOneData(RoadbridgeDutyVO roadbridgeDutyVO, DutyEntity dutyEntity, FeeVO feeVO) {
            //100章费用
            Long oneId = null;
            for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
                if ("100章费用".equals(detailVO.getName())) {
                    oneId = detailVO.getId();
                }
            }
            for (DutyOneVO oneVO : roadbridgeDutyVO.getDutyOneList()) {
                for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                    if (!detailEntity.getLeafFlag()) {
                        continue;
                    }
                    if (detailEntity.getFeeDetailId().equals(oneId)) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(oneVO.getOneDetailCode());
                        itemEntity.setName(oneVO.getOneDetailName());
                        itemEntity.setUnitName(oneVO.getOneUnitName());
                        itemEntity.setMny(oneVO.getOneDutyMny());
                        itemEntity.setTaxMny(oneVO.getOneDutyMny());
                        itemEntity.setDocType(6);
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }
            }
        }
    }

}
