package com.ejianc.business.build.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.build.vo.BuildPlansVO;
import com.ejianc.business.build.vo.BuildRgcostVO;
import com.ejianc.business.build.vo.BuildSubVO;
import com.ejianc.business.build.vo.BuildMaterialVO;
import com.ejianc.business.build.vo.BuildRmatVO;
import com.ejianc.business.build.vo.BuildEquipmentVO;
import com.ejianc.business.build.vo.BuildSafeVO;
import com.ejianc.business.build.vo.BuildTemporaryVO;
import com.ejianc.business.build.vo.BuildMeasureVO;
import com.ejianc.business.build.vo.BuildManageVO;
import com.ejianc.business.build.vo.BuildFeesVO;
import com.ejianc.business.build.vo.BuildOtherVO;

/**
 * 房建-目标责任成本
 *
 * @author generator
 *
 */
public class BuildDutyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String unitsName; // 建设单位
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private String billCode; // 单据编码
    private String name; // 目标责任成本名称
    private Long feeId; // 费用模板主键
    private String feeName; // 费用模板名称
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编号
    private String wbsName; // 核算对象名称
    private BigDecimal mny; // 目标成本金额(无税)
    private BigDecimal taxMny; // 目标成本金额
    private BigDecimal beforeMny; // 变更前金额(无税)
    private BigDecimal beforeTaxMny; // 变更前金额
    private Integer convertFlag; // 转换状态 1-是 0-否
    private Boolean latestFlag; // 是否最新版本
    private Boolean enableState; // 是否生效
    private String memo; // 备注
    private Integer dutyVersion; // 目标责任成本版本
    private Long lastDutyId; // 上一版本主键
    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    private Integer billState; // 审批状态
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer beforeDutyVersion; // 历史版本号
    private Date oneTime; // 第一版本创建时间
    private Long baseDutyId; // 原始版本主键
    private String projectCode; // 项目编码

    private List<BuildPlansVO> buildPlansList = new ArrayList<>(); // 房建-目标成本-计划汇总表
    private List<BuildRgcostVO> buildRgcostList = new ArrayList<>(); // 房建-人工费
    private List<BuildSubVO> buildSubList = new ArrayList<>(); // 房建-专业分包
    private List<BuildMaterialVO> buildMaterialList = new ArrayList<>(); // 房建-主要材料
    private List<BuildRmatVO> buildRmatList = new ArrayList<>(); // 房建-周转材
    private List<BuildEquipmentVO> buildEquipmentList = new ArrayList<>(); // 房建-机械设备费
    private List<BuildSafeVO> buildSafeList = new ArrayList<>(); // 房建-安全文明施工费
    private List<BuildTemporaryVO> buildTemporaryList = new ArrayList<>(); // 房建-临时设施费
    private List<BuildMeasureVO> buildMeasureList = new ArrayList<>(); // 房建-其他措施费
    private List<BuildManageVO> buildManageList = new ArrayList<>(); // 房建-现场管理费
    private List<BuildFeesVO> buildFeesList = new ArrayList<>(); // 房建-规费
    private List<BuildOtherVO> buildOtherList = new ArrayList<>(); // 房建-其他费用

    private List<BuildDutyRecordVO> recordList = new ArrayList<>(); // 房建-目标成本-变更记录表

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getUnitsName() {
        return unitsName;
    }

    public void setUnitsName(String unitsName) {
        this.unitsName = unitsName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode = "tc-fee")
    public Long getFeeId() {
        return feeId;
    }
    @ReferDeserialTransfer
    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }
    @ReferSerialTransfer(referCode="subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }
    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }
    public Integer getConvertFlag() {
        return convertFlag;
    }

    public void setConvertFlag(Integer convertFlag) {
        this.convertFlag = convertFlag;
    }
    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }
    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }
    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseDutyId() {
        return baseDutyId;
    }

    public void setBaseDutyId(Long baseDutyId) {
        this.baseDutyId = baseDutyId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

     public List<BuildPlansVO> getBuildPlansList() {
        return buildPlansList;
     }

     public void setBuildPlansList(List<BuildPlansVO> buildPlansList) {
        this.buildPlansList = buildPlansList;
     }
     public List<BuildRgcostVO> getBuildRgcostList() {
        return buildRgcostList;
     }

     public void setBuildRgcostList(List<BuildRgcostVO> buildRgcostList) {
        this.buildRgcostList = buildRgcostList;
     }
     public List<BuildSubVO> getBuildSubList() {
        return buildSubList;
     }

     public void setBuildSubList(List<BuildSubVO> buildSubList) {
        this.buildSubList = buildSubList;
     }
     public List<BuildMaterialVO> getBuildMaterialList() {
        return buildMaterialList;
     }

     public void setBuildMaterialList(List<BuildMaterialVO> buildMaterialList) {
        this.buildMaterialList = buildMaterialList;
     }
     public List<BuildRmatVO> getBuildRmatList() {
        return buildRmatList;
     }

     public void setBuildRmatList(List<BuildRmatVO> buildRmatList) {
        this.buildRmatList = buildRmatList;
     }
     public List<BuildEquipmentVO> getBuildEquipmentList() {
        return buildEquipmentList;
     }

     public void setBuildEquipmentList(List<BuildEquipmentVO> buildEquipmentList) {
        this.buildEquipmentList = buildEquipmentList;
     }
     public List<BuildSafeVO> getBuildSafeList() {
        return buildSafeList;
     }

     public void setBuildSafeList(List<BuildSafeVO> buildSafeList) {
        this.buildSafeList = buildSafeList;
     }
     public List<BuildTemporaryVO> getBuildTemporaryList() {
        return buildTemporaryList;
     }

     public void setBuildTemporaryList(List<BuildTemporaryVO> buildTemporaryList) {
        this.buildTemporaryList = buildTemporaryList;
     }
     public List<BuildMeasureVO> getBuildMeasureList() {
        return buildMeasureList;
     }

     public void setBuildMeasureList(List<BuildMeasureVO> buildMeasureList) {
        this.buildMeasureList = buildMeasureList;
     }
     public List<BuildManageVO> getBuildManageList() {
        return buildManageList;
     }

     public void setBuildManageList(List<BuildManageVO> buildManageList) {
        this.buildManageList = buildManageList;
     }
     public List<BuildFeesVO> getBuildFeesList() {
        return buildFeesList;
     }

     public void setBuildFeesList(List<BuildFeesVO> buildFeesList) {
        this.buildFeesList = buildFeesList;
     }
     public List<BuildOtherVO> getBuildOtherList() {
        return buildOtherList;
     }

     public void setBuildOtherList(List<BuildOtherVO> buildOtherList) {
        this.buildOtherList = buildOtherList;
     }

    public List<BuildDutyRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<BuildDutyRecordVO> recordList) {
        this.recordList = recordList;
    }
}
