package com.ejianc.business.targetcost.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.*;
import com.ejianc.business.targetcost.mapper.DutyMapper;
import com.ejianc.business.targetcost.mapper.FinishMapper;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import jdk.nashorn.internal.runtime.options.LoggingOption;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 目标成本完工统计
 *
 * @author generator
 *
 */
@Service("finishService")
public class FinishServiceImpl extends BaseServiceImpl<FinishMapper, FinishEntity> implements IFinishService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFinishService service;
    @Autowired
    private IFeeService feeService;
    @Autowired
    private IFinishDetailItemService finishDetailItemService;
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private DutyMapper dutyMapper;
    @Autowired
    private IFinishDetailService finishDetailService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IFeeDetailService feeDetailService;

    private static final String BILL_CODE = "FINISH_CODE";

    @Override
    public FinishVO queryFinishDetail(Long projectId, boolean hasChildren) {
        FinishVO vo = new FinishVO();
        BigDecimal totalMny = new BigDecimal(0);
        BigDecimal totalTaxMny = new BigDecimal(0);
        BigDecimal yiBai = new BigDecimal(100);
        BigDecimal zero = new BigDecimal(0);
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getProjectId, projectId);
        queryWrapper.eq(DutyEntity::getEnableState, 1);
        queryWrapper.eq(DutyEntity::getGatherFlag, 1);
        queryWrapper.in(DutyEntity::getBillState, 1,3);
        queryWrapper.eq(DutyEntity::getDr, 0);
        DutyEntity dutyEntity = dutyService.getOne(queryWrapper, false);
        if (null == dutyEntity){
            throw new BusinessException("该项目下没有目标成本，请切换项目");
        }
        DutyVO dutyVO = BeanMapper.map(dutyEntity, DutyVO.class);
        DutyVO dutyVO1 = dutyService.queryDetail(dutyVO.getId(),false);
        LambdaQueryWrapper<FinishEntity> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(FinishEntity::getProjectId, projectId);
        queryWrapper1.eq(FinishEntity::getBillState, 0);
        queryWrapper1.eq(FinishEntity::getDr, 0);
        List<FinishEntity> finishEntities1 = super.list(queryWrapper1);
        if (CollectionUtils.isNotEmpty(finishEntities1)){
            throw new BusinessException("当前项目存在自由态的目标成本完工统计单据，不允许再次新增");
        }
        LambdaQueryWrapper<FinishEntity> query = new LambdaQueryWrapper<>();
        query.eq(FinishEntity::getProjectId, projectId);
        query.eq(FinishEntity::getDr, 0);
        List<FinishEntity> finishEntities = super.list(query);
        List<FinishVO> finishVOList = new ArrayList<>();
        for (int i=0; i<finishEntities.size(); i++){
            FinishVO finishVO = this.queryDetail(finishEntities.get(i).getId(), true);
            finishVOList.add(finishVO);
            if(finishEntities.get(i).getFinishDate() != null){
                vo.setFinishDate(finishEntities.get(i).getFinishDate());
            }
        }
        // 判断是否是该项目第一次制单
        if (finishVOList.size()==0){
            vo.setTotalTaxMny(zero);
            vo.setTaxMny(zero);
            vo.setRatio(zero);
            vo.setName(dutyVO1.getName());
            vo.setMny(dutyVO1.getMny());
            vo.setTaxMny(dutyVO1.getTaxMny());
            vo.setFeeId(dutyVO1.getFeeId());
            vo.setFeeName(dutyVO1.getFeeName());
            vo.setProjectName(dutyVO1.getProjectName());
            vo.setOrgId(dutyVO1.getOrgId());
            vo.setOrgName(dutyVO1.getOrgName());
            vo.setOrgCode(dutyVO1.getOrgCode());
            vo.setFinishDetailList(BeanMapper.mapList(dutyVO1.getDutyDetailList(), FinishDetailVO.class));
            for (int i=0; i<vo.getFinishDetailList().size(); i++){
                vo.getFinishDetailList().get(i).setFinishDetailItemList(vo.getFinishDetailList().get(i).getDutyDetailItemList());
                for (int m=0; m<vo.getFinishDetailList().get(i).getFinishDetailItemList().size(); m++){
                    for (int n=0; n<vo.getFinishDetailList().get(i).getDutyDetailItemList().size(); n++){
                        vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setDutyItemId(vo.getFinishDetailList().get(i).getDutyDetailItemList().get(m).getId());
                        break;
                    }
                }
            }
        }else {
            for (int i=0; i<finishVOList.size(); i++){
                vo.setName(finishVOList.get(i).getName());
                vo.setMny(finishVOList.get(i).getMny());
                vo.setTaxMny(finishVOList.get(i).getTaxMny());
                vo.setFeeId(finishVOList.get(i).getFeeId());
                vo.setFeeName(finishVOList.get(i).getFeeName());
                vo.setProjectName(finishVOList.get(i).getProjectName());
                vo.setOrgId(finishVOList.get(i).getOrgId());
                vo.setOrgName(finishVOList.get(i).getOrgName());
                vo.setOrgCode(finishVOList.get(i).getOrgCode());
                totalMny = ComputeUtil.safeAdd(totalMny,finishVOList.get(i).getFinishMny());
                vo.setTotalMny(totalMny);
                totalTaxMny = ComputeUtil.safeAdd(totalTaxMny,finishVOList.get(i).getFinishTaxMny());
                vo.setTotalTaxMny(totalTaxMny);
                vo.setRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(totalTaxMny,finishVOList.get(i).getTaxMny()),yiBai));
                vo.setFinishDetailList(finishVOList.get(i).getFinishDetailList());
            }
            vo.setFinishDetailList(BeanMapper.mapList(dutyVO1.getDutyDetailList(), FinishDetailVO.class));
            for (int i=0; i<vo.getFinishDetailList().size(); i++){
                vo.getFinishDetailList().get(i).setFinishDetailItemList(vo.getFinishDetailList().get(i).getDutyDetailItemList());
                for (int m=0; m<vo.getFinishDetailList().get(i).getFinishDetailItemList().size(); m++){
                    for (int n=0; n<vo.getFinishDetailList().get(i).getDutyDetailItemList().size(); n++){
                        vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setDutyItemId(vo.getFinishDetailList().get(i).getDutyDetailItemList().get(m).getId());
                        break;
                    }
                }
            }
        }
        BigDecimal a = BigDecimal.ZERO;
        BigDecimal b = BigDecimal.ZERO;
        BigDecimal c = BigDecimal.ZERO;
        int d = 0;
        for (int i=0; i<vo.getFinishDetailList().size(); i++){
            // 此时为平铺，将孙表赋值
            vo.getFinishDetailList().get(i).setFinishDetailItemList(vo.getFinishDetailList().get(i).getDutyDetailItemList());
            // 循环孙表用于查询FeeDetailId
            for (int m=0; m<vo.getFinishDetailList().get(i).getFinishDetailItemList().size(); m++){
                // 根据FeeDetailId查询孙表
                LambdaQueryWrapper<FinishDetailItemEntity> finishDetailItemEntity = new LambdaQueryWrapper<>();
                finishDetailItemEntity.eq(FinishDetailItemEntity::getDutyItemId, vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getDutyItemId());
                finishDetailItemEntity.eq(FinishDetailItemEntity::getDr, 0);
                List<FinishDetailItemEntity> finishDetailItemEntities = finishDetailItemService.list(finishDetailItemEntity);
                for (int n=0; n<finishDetailItemEntities.size(); n++){
                    // 返回的孙表FeeDetailId和数据库孙表的FeeDetailId相同时，则将孙表的数据累加并赋给返回值
                    if (vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getDutyItemId().equals(finishDetailItemEntities.get(n).getDutyItemId())){
                        // 判断m是否变化， m每变化一次， 即循环过一条页面孙表， 不等于即m变化
                        // 该判断 m=0，d=0；若m=1，d=0，即m变化， 让d+1
                        if (m != d ){
                            a = BigDecimal.ZERO;
                            b = BigDecimal.ZERO;
                            c = BigDecimal.ZERO;
                            d++;
                        }
                        // 有些孙表字段为空， 所以增加判断
                        if (finishDetailItemEntities.get(n).getFinishAmount()!=null){
                            a = ComputeUtil.safeAdd(a,finishDetailItemEntities.get(n).getFinishAmount());
                            // 根据FeeDetailId指定赋值， 如果写在if外边， 会将空值的孙表单据也赋值
                            vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setTotalFinishAmount(a);
                        }
                        if (finishDetailItemEntities.get(n).getFinishTaxMny()!=null){
                            b = ComputeUtil.safeAdd(b,finishDetailItemEntities.get(n).getFinishTaxMny());
                            vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setTotalTaxMny(b);
                        }
                        if (finishDetailItemEntities.get(n).getFinishMny()!=null){
                            c = ComputeUtil.safeAdd(c,finishDetailItemEntities.get(n).getFinishMny());
                            vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setTotalMny(c);
                        }
                        // 孙表两个剩余金额计算
                        if (vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getTotalMny()==null){
                            vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setTotalMny(BigDecimal.ZERO);
                        }
                        if (vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getTotalTaxMny()==null){
                            vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setTotalTaxMny(BigDecimal.ZERO);
                        }
                        vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setSurplusMny(ComputeUtil.safeSub(vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getMny(),vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getTotalMny()));
                        vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).setSurplusTaxMny(ComputeUtil.safeSub(vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getTaxMny(),vo.getFinishDetailList().get(i).getFinishDetailItemList().get(m).getTotalTaxMny()));
                    }
                }
            }
        }
        // 子表转树形
        vo.setFinishDetailList(TreeNodeBUtil.buildTree(vo.getFinishDetailList()));
        return vo;
    }

    @Override
    public FinishVO queryDetail(Long id, boolean hasChildren) {
        FinishEntity entity = service.selectById(id);

        FeeVO feeVO = feeService.queryDetail(entity.getFeeId(), false);
        Map<Long, List<FeeDetailVO>> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(feeVO.getFeeDetailList())) {
            for(FeeDetailVO detailVO : feeVO.getFeeDetailList()){
                if(detailVO.getSelfRelatedFlag()){
                    map.put(detailVO.getId(), detailVO.getRelatedList());
                }
            }
        }

        //遍历成本明细,查询费用明细业务范围
        List<FinishDetailEntity> finishDetailEntityList = entity.getFinishDetailList();
        for (FinishDetailEntity finishDetailEntity : finishDetailEntityList) {
            finishDetailEntity.setTid(finishDetailEntity.getId().toString());
            finishDetailEntity.setTpid(finishDetailEntity.getParentId()!= null&&finishDetailEntity.getParentId()>0?finishDetailEntity.getParentId().toString():"");
            List<FinishDetailItemEntity> finishDetailScopeEntityList = finishDetailItemService.findByFinishDetailId(finishDetailEntity.getId());
            finishDetailEntity.setFinishDetailItemList(finishDetailScopeEntityList);

            if(map.containsKey(finishDetailEntity.getFeeDetailId())){
                finishDetailEntity.setRelatedDetailList(map.get(finishDetailEntity.getFeeDetailId()));
            }
        }

        FinishVO vo = BeanMapper.map(entity, FinishVO.class);
        for (int m=0; m<vo.getFinishDetailList().size(); m++){
            for (int n=0; n<vo.getFinishDetailList().get(m).getFinishDetailItemList().size(); n++){
                vo.getFinishDetailList().get(m).getFinishDetailItemList().get(n).setSurplusMny(ComputeUtil.safeSub(vo.getFinishDetailList().get(m).getFinishDetailItemList().get(n).getMny(),vo.getFinishDetailList().get(m).getFinishDetailItemList().get(n).getTotalMny()));
                vo.getFinishDetailList().get(m).getFinishDetailItemList().get(n).setSurplusTaxMny(ComputeUtil.safeSub(vo.getFinishDetailList().get(m).getFinishDetailItemList().get(n).getTaxMny(),vo.getFinishDetailList().get(m).getFinishDetailItemList().get(n).getTotalTaxMny()));
            }
        }
        if(hasChildren){
            vo.setFinishDetailList(TreeNodeBUtil.buildTree(vo.getFinishDetailList()));
        }

        return vo;
    }

    @Override
    public CommonResponse<FinishVO> saveOrUpdate(FinishVO finishVO) {
        // 将子表和孙表的id置空
        BigDecimal newFinishMny = new BigDecimal(0);
        BigDecimal newFinishTaxMny = new BigDecimal(0);
        if(CollectionUtils.isNotEmpty(finishVO.getFinishDetailList())){
            for(FinishDetailVO detailVO : finishVO.getFinishDetailList()){
                detailVO.setId(finishVO.getId() == null ?  null : detailVO.getId());

                if(CollectionUtils.isNotEmpty(detailVO.getFinishDetailItemList())){
                    for(FinishDetailItemVO itemVO : detailVO.getFinishDetailItemList()){
                        if (finishVO.getId() == null){
                            itemVO.setId(null);
                        }
                        // 处理主表数据
                        newFinishMny = ComputeUtil.safeAdd(newFinishMny, itemVO.getFinishMny());
                        newFinishTaxMny = ComputeUtil.safeAdd(newFinishTaxMny, itemVO.getFinishTaxMny());
                    }
                }

            }
        }

        finishVO.setFinishMny(newFinishMny);
        finishVO.setFinishTaxMny(newFinishTaxMny);
        finishVO.setTax(ComputeUtil.safeSub(newFinishTaxMny,newFinishMny));

        BigDecimal totalFinishMny = BigDecimal.ZERO;
        BigDecimal totalFinishTaxMny = BigDecimal.ZERO;

        LambdaQueryWrapper<FinishEntity> query = new LambdaQueryWrapper<>();
        query.eq(FinishEntity::getProjectId, finishVO.getProjectId());
        query.in(FinishEntity::getBillState, "1,3");
        query.ne(finishVO.getId() != null, FinishEntity::getId, finishVO.getId());
        List<FinishEntity> finishEntities = super.list(query);
        for (FinishEntity finishEntity : finishEntities){
            totalFinishMny = ComputeUtil.safeAdd(totalFinishMny, finishEntity.getFinishMny());
            totalFinishTaxMny = ComputeUtil.safeAdd(totalFinishTaxMny, finishEntity.getFinishTaxMny());
        }

        finishVO.setTotalMny(ComputeUtil.safeAdd(totalFinishMny,finishVO.getFinishMny()));
        finishVO.setTotalTaxMny(ComputeUtil.safeAdd(totalFinishTaxMny,finishVO.getFinishTaxMny()));

        finishVO.setRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(finishVO.getTotalTaxMny(), finishVO.getTaxMny()), new BigDecimal(100)));

        FinishEntity entity = BeanMapper.map(finishVO, FinishEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),finishVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        //成本明细数据处理
        List<FinishDetailEntity> finishDetailEntities = entity.getFinishDetailList();
        //费用明细编码对应主键
        Map<String, Long> map = new HashMap<>();
        //遍历获取真实主键
        for (FinishDetailEntity finishDetailEntity : finishDetailEntities) {
            map.put(finishDetailEntity.getTid(), finishDetailEntity.getId());
        }

        for (FinishDetailEntity finishDetailEntity : finishDetailEntities) {
            finishDetailEntity.setParentId(map.get(finishDetailEntity.getTpid()));
        }
        service.saveOrUpdate(entity, false);
        //保存成本明细档案
        for (FinishDetailEntity finishDetailEntity : entity.getFinishDetailList()) {

            //保存新成本明细档案项
            List<FinishDetailItemEntity> finishDetailItemList = finishDetailEntity.getFinishDetailItemList();
            if(CollectionUtils.isNotEmpty(finishDetailItemList)){
                List<FinishDetailItemEntity> insertList = new ArrayList<>();
                List<Long> delPkList = new ArrayList<>();
                //保存成本明细对应的档案明细
                for(FinishDetailItemEntity finishDetailItemEntity : finishDetailItemList){
                    if ("del".equals(finishDetailItemEntity.getRowState())) {
                        delPkList.add(finishDetailItemEntity.getId());
                    }else{
                        finishDetailItemEntity.setOrgId(entity.getOrgId());
                        finishDetailItemEntity.setOrgName(entity.getOrgName());
                        finishDetailItemEntity.setProjectId(entity.getProjectId());
                        finishDetailItemEntity.setProjectName(entity.getProjectName());
                        finishDetailItemEntity.setFeeDetailId(finishDetailEntity.getFeeDetailId());
                        finishDetailItemEntity.setFeeDetailCode(finishDetailEntity.getFeeDetailCode());
                        finishDetailItemEntity.setFeeDetailName(finishDetailEntity.getFeeDetailName());
                        finishDetailItemEntity.setCategoryId(finishDetailEntity.getCategoryId());
                        finishDetailItemEntity.setCategoryInnerCode(finishDetailEntity.getCategoryInnerCode());
                        finishDetailItemEntity.setDocType(finishDetailEntity.getDocType());
                        finishDetailItemEntity.setFinishId(finishDetailEntity.getFinishId());//成本主键
                        finishDetailItemEntity.setFinishDetailId(finishDetailEntity.getId());//成本明细主键
                        insertList.add(finishDetailItemEntity);
                    }
                }
                int flag = 0;
                if(CollectionUtil.isNotEmpty(insertList)){
                    finishDetailItemService.saveOrUpdateBatch(finishDetailEntity.getFinishDetailItemList());
                }
                if(CollectionUtil.isNotEmpty(delPkList)){
                    finishDetailItemService.removeByIds(delPkList);
                }
            }
        }
        //返回数据
        FinishVO vo = BeanMapper.map(entity, FinishVO.class);
        List<FinishDetailVO> finishDetailVOList = vo.getFinishDetailList();
        vo.setFinishDetailList(TreeNodeBUtil.buildTree(finishDetailVOList));

        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<CostReportVO> costReportQueryNew(Long projectId, String endDate,String beginPeriod) {
        List<CostReportVO> costReportVOList = new ArrayList<>();
        //查询把目标成本成本科目汇总金额
        List<DutyDetailVO> dutyDetailVOList = dutyMapper.queryDetailSubNew(projectId);

        List<String> dutyDetailFeeDetailCodeList = new ArrayList<>();//孙表feeDetailCodeList
        for(DutyDetailVO dutyDetailVO : dutyDetailVOList){
            dutyDetailFeeDetailCodeList.add(dutyDetailVO.getFeeDetailCode());
        }
       // select * from ejc_targetcost_duty where project_id = 563280631161815101 and enable_state =1

        LambdaQueryWrapper<DutyEntity> queryD = new LambdaQueryWrapper<>();
        queryD.eq(DutyEntity::getProjectId,projectId);
        queryD.eq(DutyEntity::getEnableState,1);
        List<DutyEntity> dutyEntities = dutyService.list(queryD);
        if(CollectionUtil.isNotEmpty(dutyEntities)){
            LambdaQueryWrapper<DutyDetailEntity> querys = new LambdaQueryWrapper<>();
            querys.eq(DutyDetailEntity::getDutyId,dutyEntities.get(0).getId());
            List<DutyDetailEntity>  dutyDetailEntityList = dutyDetailService.list(querys);

            //如果孙表list不包含含这个code.则把他加进去
            for(DutyDetailEntity dutyDetailEntity : dutyDetailEntityList){
                if(!dutyDetailFeeDetailCodeList.contains(dutyDetailEntity.getFeeDetailCode())){
                    DutyDetailVO dutyDetailVO = BeanMapper.map(dutyDetailEntity, DutyDetailVO.class);
                    if(dutyDetailVO.getSumMny() == null || dutyDetailVO.getSumMny().compareTo(new BigDecimal(0)) == 0){
                        dutyDetailVO.setSumMny(dutyDetailVO.getMny());
                        dutyDetailVO.setSumTaxMny(dutyDetailVO.getTaxMny());
                        LambdaQueryWrapper<FeeDetailEntity> queryFee = new LambdaQueryWrapper<>();
                        queryFee.eq(FeeDetailEntity::getId,dutyDetailVO.getFeeDetailId());
                        List<FeeDetailEntity>  feeDetailEntity = feeDetailService.list(queryFee);
                        if(CollectionUtil.isNotEmpty(feeDetailEntity)){
                            dutyDetailVO.setSubjectId(feeDetailEntity.get(0).getSubjectId());
                            dutyDetailVO.setSubjectName(feeDetailEntity.get(0).getSubjectName());
                            dutyDetailVO.setSubjectCode(feeDetailEntity.get(0).getSubjectCode());
                        }
                    }
                    dutyDetailVOList.add(dutyDetailVO);

                }
            }

        }
        for(DutyDetailVO dutyDetailVO:dutyDetailVOList){
            CostReportVO costReportVO = new CostReportVO();
            costReportVO.setSubjectId(dutyDetailVO.getSubjectId());
            costReportVO.setSubjectName(dutyDetailVO.getSubjectName());
            costReportVO.setSubjectCode(dutyDetailVO.getSubjectCode());
            costReportVO.setCbNumAll(dutyDetailVO.getTotalAmount());
            costReportVO.setCbHappenMnyAll(dutyDetailVO.getSumMny());
            costReportVO.setCbHappenTaxMnyAll(dutyDetailVO.getSumTaxMny());
            costReportVO.setFeeDetailCode(dutyDetailVO.getFeeDetailCode());
            costReportVO.setFeeDetailName(dutyDetailVO.getFeeDetailName());
            costReportVO.setCbUnitName(dutyDetailVO.getUnitName());
            costReportVOList.add(costReportVO);
        }
        logger.info("目标成本-----------"+JSONObject.toJSONString(dutyDetailVOList));
        //查询生效的完工统计汇总
        List<FinishDetailVO> finishDetailVOList = dutyMapper.queryFinDetailSubNew(projectId,endDate,beginPeriod);
        logger.info("完工统计----------"+JSONObject.toJSONString(finishDetailVOList));
        Long finishId = dutyMapper.queryFinishId(projectId,endDate);
        //查询子表数据，过滤出没有明细的子表数据
        LambdaQueryWrapper<FinishDetailEntity> query = new LambdaQueryWrapper<>();
        query.eq(FinishDetailEntity::getFinishId,finishId);
        List<FinishDetailEntity> finishDetailEntityList = finishDetailService.list(query);

        List<String> feeDetailCodeList = new ArrayList<>();//孙表feeDetailCodeList
        for(FinishDetailVO finishDetailVO : finishDetailVOList){
            feeDetailCodeList.add(finishDetailVO.getFeeDetailCode());
        }
        //如果孙表list不好含这个code.则把他加进去
        for(FinishDetailEntity finishDetailEntity : finishDetailEntityList){
            if(!feeDetailCodeList.contains(finishDetailEntity.getFeeDetailCode())){
                finishDetailVOList.add(BeanMapper.map(finishDetailEntity, FinishDetailVO.class));
            }
        }
        logger.info("添加子表之后-----"+JSONObject.toJSONString(finishDetailVOList));
        for(FinishDetailVO finishDetailVO : finishDetailVOList){
            for(CostReportVO costReportVO : costReportVOList){
                if(finishDetailVO.getFeeDetailCode().equals(costReportVO.getFeeDetailCode()) && finishDetailVO.getFeeDetailName().equals(costReportVO.getFeeDetailName())){
                    costReportVO.setCbNum(finishDetailVO.getTotalAmount());
                    costReportVO.setCbHappenMny(finishDetailVO.getTotalMny());
                    costReportVO.setCbHappenTaxMny(finishDetailVO.getTotalTaxMny());
                    costReportVO.setCbUnitName(finishDetailVO.getUnitName());
                }
            }
        }

        return costReportVOList;
    }

    @Override
    public List<CostReportVO> costReportQuery(Long projectId, String endDate,String beginPeriod) {
        List<CostReportVO> costReportVOList = new ArrayList<>();
        //查询把目标成本成本科目汇总金额
        List<DutyDetailVO> dutyDetailVOList = dutyMapper.queryDetailSub(projectId);
        for(DutyDetailVO dutyDetailVO:dutyDetailVOList){
            CostReportVO costReportVO = new CostReportVO();
            costReportVO.setSubjectId(dutyDetailVO.getSubjectId());
            costReportVO.setSubjectName(dutyDetailVO.getSubjectName());
            costReportVO.setSubjectCode(dutyDetailVO.getSubjectCode());
            costReportVO.setCbNumAll(dutyDetailVO.getTotalAmount());
            costReportVO.setCbHappenMnyAll(dutyDetailVO.getSumMny());
            costReportVO.setCbHappenTaxMnyAll(dutyDetailVO.getSumTaxMny());
            costReportVO.setFeeDetailCode(dutyDetailVO.getFeeDetailCode());
            costReportVO.setFeeDetailName(dutyDetailVO.getFeeDetailName());
            costReportVOList.add(costReportVO);
        }
        if(endDate == null){//不传时间区间得情况，只根据项目查询
            List<FinishDetailVO> finishDetailVOList = dutyMapper.queryFinDetailSub(projectId);
            for(FinishDetailVO finishDetailVO : finishDetailVOList){
                for(CostReportVO costReportVO : costReportVOList){
                    if(finishDetailVO.getFeeDetailCode().equals(costReportVO.getFeeDetailCode()) && finishDetailVO.getFeeDetailName().equals(costReportVO.getFeeDetailName())){
                        costReportVO.setCbNum(finishDetailVO.getTotalAmount());
                        costReportVO.setCbHappenMny(finishDetailVO.getTotalMny());
                        costReportVO.setCbHappenTaxMny(finishDetailVO.getTotalTaxMny());
                    }
                }
            }
        }else{
            //查询生效的完工统计汇总
            List<FinishDetailVO> finishDetailVOList = dutyMapper.queryFinDetailSub2(projectId,endDate,beginPeriod);
            for(FinishDetailVO finishDetailVO : finishDetailVOList){
                for(CostReportVO costReportVO : costReportVOList){
                    if(finishDetailVO.getFeeDetailCode().equals(costReportVO.getFeeDetailCode()) && finishDetailVO.getFeeDetailName().equals(costReportVO.getFeeDetailName())){
                        costReportVO.setCbNum(finishDetailVO.getTotalAmount());
                        costReportVO.setCbHappenMny(finishDetailVO.getTotalMny());
                        costReportVO.setCbHappenTaxMny(finishDetailVO.getTotalTaxMny());
                    }
                }
            }
        }
        return costReportVOList;
    }
}
