package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.mapper.TotalCacheMapper;
import com.ejianc.business.targetcost.service.IDutyDetailItemService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标成本总金额汇总缓存
 *
 * @author generator
 *
 */
@Service("totalCacheService")
public class TotalCacheServiceImpl extends BaseServiceImpl<TotalCacheMapper, TotalCacheEntity> implements ITotalCacheService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;

    @Override
    public ExecutionReportVO queryReport(Long projectId) {
        Map<String, String> map = new HashMap<>();
        map.put(BussinessTypeEnum.专业分包合同.getCode(), ContractTypeEnum.专业分包合同.getTypeCode());
        map.put(BussinessTypeEnum.劳务分包合同.getCode(), ContractTypeEnum.劳务分包合同.getTypeCode());
        map.put(BussinessTypeEnum.其他支出合同.getCode(), ContractTypeEnum.其他支出.getTypeCode());
        map.put("WZCGHT", ContractTypeEnum.物资采购合同.getTypeCode());
        map.put(BussinessTypeEnum.混凝土采购合同.getCode(), ContractTypeEnum.混凝土合同.getTypeCode());
        map.put(BussinessTypeEnum.周转材租赁合同.getCode(), ContractTypeEnum.周转材合同.getTypeCode());
        map.put(BussinessTypeEnum.设备采购合同.getCode(), ContractTypeEnum.设备采购.getTypeCode());
        map.put(BussinessTypeEnum.设备租赁合同.getCode(), ContractTypeEnum.设备租赁.getTypeCode());
        map.put(BussinessTypeEnum.临时设备租赁合同.getCode(), ContractTypeEnum.临时设备.getTypeCode());
        map.put(BussinessTypeEnum.大型设备安拆合同.getCode(), ContractTypeEnum.安拆合同.getTypeCode());
        ExecutionReportVO reportVO = new ExecutionReportVO();
        reportVO.setId(Long.valueOf(11111));
        LambdaQueryWrapper<TotalCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalCacheEntity::getProjectId, projectId);
        queryWrapper.orderByAsc(TotalCacheEntity::getCode);
        List<TotalCacheEntity> list = list(queryWrapper);
        for (TotalCacheEntity totalCacheEntity : list) {
            totalCacheEntity.setId(totalCacheEntity.getDutyDetailId());
            totalCacheEntity.setTid(totalCacheEntity.getId().toString());
            totalCacheEntity.setTpid(totalCacheEntity.getParentId()!= null&&totalCacheEntity.getParentId()>0?totalCacheEntity.getParentId().toString():"");
            if(null == totalCacheEntity.getParentId()){
                fullPayAndSettleMny(map, totalCacheEntity);
            }
        }
        List<TotalCacheVO> resultMapList = BeanMapper.mapList(list, TotalCacheVO.class);
        //实现排序
        Collections.sort(resultMapList, new DetailCompareVO());
        reportVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));

        CommonResponse<List<SubjectOrgVO>> subjectResponse = shareSubjectOrgApi.shareSubjectOrgApi();
        if(subjectResponse.isSuccess()){
            CommonResponse<List<CostDetailVO>> listCommonResponse = costDetailApi.queryMnyBySubjectId(null, projectId, new ArrayList<>());
            Map<Long, CostDetailVO> costMap = new HashMap<>();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                costMap = listCommonResponse.getData().stream().collect(Collectors.toMap(CostDetailVO::getSubjectId, Function.identity(), (key1, key2) -> key1));
            }

            List<DutyDetailItemVO> dutyCostList = dutyDetailItemService.queryCostMny(projectId, null);
            Map<Long, DutyDetailItemVO> dutyCostMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(dutyCostList)) {
                for (DutyDetailItemVO itemVO : dutyCostList) {
                    String[] innerArr = itemVO.getSubjectInnerCode().split(",");
                    for (String innerCode : innerArr) {
                        Long key = Long.valueOf(innerCode);
                        DutyDetailItemVO value;
                        if (dutyCostMap.containsKey(key)) {
                            value = dutyCostMap.get(key);
                        }else {
                            value = new DutyDetailItemVO();
                            value.setSubjectId(key);
                        }
                        value.setMny(ComputeUtil.safeAdd(value.getMny(), itemVO.getMny()));
                        value.setTaxMny(ComputeUtil.safeAdd(value.getTaxMny(), itemVO.getTaxMny()));
                        dutyCostMap.put(key, value);
                    }
                }
            }

            List<ExecutionSubjectVO> subjectDetailVOS = BeanMapper.mapList(subjectResponse.getData(), ExecutionSubjectVO.class);
            for(ExecutionSubjectVO subjectDetailVO : subjectDetailVOS){
                subjectDetailVO.setSubjectId(subjectDetailVO.getId());
                subjectDetailVO.setTid(String.valueOf(subjectDetailVO.getId()));
                subjectDetailVO.setTpid(String.valueOf(subjectDetailVO.getParentId()));
                if(dutyCostMap.containsKey(subjectDetailVO.getSubjectId())){
                    DutyDetailItemVO itemVO = dutyCostMap.get(subjectDetailVO.getSubjectId());
                    subjectDetailVO.setMny(itemVO.getMny());
                    subjectDetailVO.setTaxMny(itemVO.getTaxMny());
                }
                if(costMap.containsKey(subjectDetailVO.getSubjectId())){
                    CostDetailVO costDetailVO = costMap.get(subjectDetailVO.getSubjectId());
                    subjectDetailVO.setCostMny(costDetailVO.getHappenMny());
                    subjectDetailVO.setCostTaxMny(costDetailVO.getHappenTaxMny());
                }
            }

            List<Map> subjectMapList = BeanMapper.mapList(subjectDetailVOS, Map.class);
            List<Map<String, Object>> treeData =  ResultAsTree.createTreeData(subjectMapList);
            gatherMny(null, treeData);
            reportVO.setSubjectList(BeanMapper.mapList(treeData, ExecutionSubjectVO.class));
        }
        return reportVO;
    }

    // 实现 Comparator 接口，并实现该接口的 compare 方法的类
    class DetailCompareVO implements Comparator<TotalCacheVO> {
        @Override
        public int compare(TotalCacheVO o1, TotalCacheVO o2) {
            String[] parts1 = o1.getTreeIndex().split("\\.");
            String[] parts2 = o2.getTreeIndex().split("\\.");

            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; i++) {
                int part1 = Integer.parseInt(parts1[i]);
                int part2 = Integer.parseInt(parts2[i]);

                if (part1 < part2) {
                    return -1;
                } else if (part1 > part2) {
                    return 1;
                }
            }
            // 如果前面的部分都相等，比较版本号长度
            return Integer.compare(parts1.length, parts2.length);
        }
    }

    /**
     * 汇总金额
     */
    private void gatherMny(Map<String, Object> now, List<Map<String, Object>> list) {
//        BigDecimal mny = null;
//        BigDecimal taxMny = null;
        BigDecimal costMny = null;
        BigDecimal costTaxMny = null;
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                gatherMny(ypd, (List) ypd.get("children"));
            }
//            mny = ComputeUtil.safeAdd(mny, getBigDecimalValue(ypd, "mny"));
//            taxMny = ComputeUtil.safeAdd(taxMny, getBigDecimalValue(ypd, "taxMny"));

            costMny = ComputeUtil.safeAdd(costMny, getBigDecimalValue(ypd, "costMny"));
            costTaxMny = ComputeUtil.safeAdd(costTaxMny, getBigDecimalValue(ypd, "costTaxMny"));
        }
        if (now != null) {
            now.put("costMny", costMny);
            now.put("costTaxMny", costTaxMny);
//            now.put("mny", mny);
//            now.put("taxMny", taxMny);
        }
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code) {
        return ypd.get(code) == null ? null : (BigDecimal) ypd.get(code);
    }

    private void fullPayAndSettleMny(Map<String, String> map, TotalCacheEntity cacheEntity){
        LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, cacheEntity.getFeeDetailId());
        List<FeeDetailScopeEntity> list = feeDetailScopeService.list(scopeQuery);
        BigDecimal settleMny = null;
        BigDecimal payMny = null;
        Boolean isFirstWzcg = true;
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> billTypeSet = new HashSet<>();
            Map<String, BigDecimal> settleMnyMap = new HashMap<>();
            for(FeeDetailScopeEntity scopeEntity : list){
                String billType = map.get(scopeEntity.getBillCode().contains("WZCGHT") ? "WZCGHT" : scopeEntity.getBillCode());
                if (StringUtils.isNotBlank(billType)) {
                    billTypeSet.add(billType);
                }
            }
            if(!billTypeSet.isEmpty()){
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, cacheEntity.getProjectId()));
                queryParam.getParams().put("contractType", new Parameter(QueryParam.IN, billTypeSet));
                logger.info("settlePoolApi.queryContractsTotalSettleMny queryParam is" + JSONObject.toJSONString(queryParam));
                CommonResponse<Map<String, BigDecimal>> response = settlePoolApi.queryContractsTotalSettleMny(queryParam);
                logger.info("settlePoolApi.queryContractsTotalSettleMny result is" + JSONObject.toJSONString(response));
                if(response.isSuccess() && null != response.getData()){
                    settleMnyMap = response.getData();
                }
            }

            for(FeeDetailScopeEntity scopeEntity : list){
                String billCode = scopeEntity.getBillCode();
                if(scopeEntity.getBillCode().contains("WZCGHT")){
                    if(isFirstWzcg){
                        billCode = "WZCGHT";
                        isFirstWzcg = false;
                    }else{
                        continue;
                    }
                }
                String billType = map.get(billCode);
                if (StringUtils.isNotBlank(billType)) {
                    if(null != settleMnyMap && settleMnyMap.containsKey(billType)){
                        settleMny = ComputeUtil.safeAdd(settleMny, settleMnyMap.get(billType));
                    }

                    CommonResponse<JSONObject> payResponse = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(cacheEntity.getProjectId(), billType);
                    if(payResponse.isSuccess()){
                        payMny = ComputeUtil.safeAdd(payMny, payResponse.getData().getBigDecimal("payMny"));
                    }
                }
            }
        }

        cacheEntity.setSettleMny(settleMny);
        cacheEntity.setPayMny(payMny);
    }

    @Override
    public List<ExecutionLinkVO> linkFeeScale(Long projectId) {
        List<ExecutionLinkVO> linkVOS = new ArrayList<>();
        CommonResponse<BigDecimal> commonResponse = proincomeContractApi.queryContranct(projectId);
        BigDecimal incomeMny = commonResponse.isSuccess() ? commonResponse.getData() :  null;
        LambdaQueryWrapper<TotalCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalCacheEntity::getProjectId, projectId);
        queryWrapper.orderByAsc(TotalCacheEntity::getTreeIndex);
        List<TotalCacheEntity> list = list(queryWrapper);
        BigDecimal totalMny = BigDecimal.ZERO;
        for (TotalCacheEntity totalCacheEntity : list) {
            if(null == totalCacheEntity.getParentId()){
                ExecutionLinkVO linkVO = BeanMapper.map(totalCacheEntity, ExecutionLinkVO.class);
                totalMny = ComputeUtil.safeAdd(totalMny, linkVO.getTaxMny());
                linkVO.setIncomeMny(incomeMny);// 施工合同金额
                linkVO.setContMnyScale(ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(linkVO.getContTaxMoney(), incomeMny)));
                linkVOS.add(linkVO);  //占总造价比 ContMnyScale
            }
        }
        if(CollectionUtils.isNotEmpty(linkVOS)){
            for (ExecutionLinkVO linkVO : linkVOS) {
                linkVO.setMnyScale(ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(linkVO.getTaxMny(), incomeMny)));
                // 成本占比
            }
        }
        if(linkVOS.size()>=7){
            //计算直接费
            BigDecimal sumDirectMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumDirecttaxMny = new BigDecimal(0);//金额
            BigDecimal sumDirectMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumDirectContMnyScale = new BigDecimal(0);//占总造价比
            BigDecimal sumContMoney = new BigDecimal(0);//合同金额(无税)
            BigDecimal sumContTaxMoney = new BigDecimal(0);//合同金额
            for (ExecutionLinkVO linkVO : linkVOS) {
                if((linkVO.getName().equals("人工费") || linkVO.getName().equals("材料费") ||
                        linkVO.getName().equals("机械设备费") || linkVO.getName().indexOf("其他支出合同费用") != -1 ||
                        linkVO.getName().equals("专业分包费") || linkVO.getName().equals("专业分包") ) && linkVO.getMny()!=null
                ){
                    sumContMoney =  ComputeUtil.safeAdd(sumContMoney,linkVO.getContMoney());
                    sumContTaxMoney =  ComputeUtil.safeAdd(sumContTaxMoney,linkVO.getContTaxMoney());
                    sumDirectMny =  sumDirectMny.add(linkVO.getMny());
                    if(linkVO.getTaxMny() != null){
                        sumDirecttaxMny =  sumDirecttaxMny.add(linkVO.getTaxMny());
                    }

                }
            }
            sumDirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumDirecttaxMny, incomeMny));//直接费占比
            sumDirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumContTaxMoney, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO = new ExecutionLinkVO();
            executionLinkVO.setId(Long.parseLong("99999"));
            executionLinkVO.setName("小计(直接费)");
            executionLinkVO.setMny(sumDirectMny);
            executionLinkVO.setTaxMny(sumDirecttaxMny);
            executionLinkVO.setMnyScale(sumDirectMnyScale);
            executionLinkVO.setContMnyScale(sumDirectContMnyScale);
            executionLinkVO.setContMoney(sumContMoney);
            executionLinkVO.setContTaxMoney(sumContTaxMoney);
            //计算间接费
            BigDecimal sumIndirectMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumIndirecttaxMny = new BigDecimal(0);//金额
            BigDecimal sumIndirectMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumIndirectContMnyScale = new BigDecimal(0);//占总造价比
            BigDecimal sumIndirectContMoney = new BigDecimal(0);//合同金额(无税)
            BigDecimal sumIndirectContTaxMoney = new BigDecimal(0);//合同金额
            for (ExecutionLinkVO linkVO : linkVOS) {
                if((linkVO.getName().equals("税金") || linkVO.getName().equals("间接费") ) && linkVO.getMny()!=null
                ){
                    sumIndirectContMoney =  ComputeUtil.safeAdd(sumIndirectContMoney,linkVO.getContMoney());
                    sumIndirectContTaxMoney =  ComputeUtil.safeAdd(sumIndirectContTaxMoney,linkVO.getContTaxMoney());
                    sumIndirectMny =  sumIndirectMny.add(linkVO.getMny());
                    if(linkVO.getTaxMny() != null){
                        sumIndirecttaxMny =  sumIndirecttaxMny.add(linkVO.getTaxMny());
                    }

                }
            }
            sumIndirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumIndirecttaxMny, incomeMny));//直接费占比
            sumIndirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumIndirectContTaxMoney, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO2 = new ExecutionLinkVO();
            executionLinkVO2.setId(Long.parseLong("88888"));
            executionLinkVO2.setName("小计(间接费)");
            executionLinkVO2.setMny(sumIndirectMny);
            executionLinkVO2.setTaxMny(sumIndirecttaxMny);
            executionLinkVO2.setMnyScale(sumIndirectMnyScale);
            executionLinkVO2.setContMnyScale(sumIndirectContMnyScale);
            executionLinkVO2.setContMoney(sumIndirectContMoney);
            executionLinkVO2.setContTaxMoney(sumIndirectContTaxMoney);
            //计算合计
            BigDecimal sumTotalMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumTotaltaxMny = new BigDecimal(0);//金额
            BigDecimal sumTotalMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumTotalContMnyScale = new BigDecimal(0);//占总造价比
            BigDecimal sumTotalContMoney = new BigDecimal(0);//合同金额(无税)
            BigDecimal sumTotalContTaxMoney = new BigDecimal(0);//合同金额
            for (ExecutionLinkVO linkVO : linkVOS) {
                if(linkVO.getMny() != null){
                    sumTotalMny =  sumTotalMny.add(linkVO.getMny());
                }
                if(linkVO.getTaxMny() != null){
                    sumTotaltaxMny =  sumTotaltaxMny.add(linkVO.getTaxMny());
                }
                if(linkVO.getMnyScale() != null){
                    sumTotalMnyScale = sumTotalMnyScale.add(linkVO.getMnyScale());
                }
                sumTotalContMoney =  ComputeUtil.safeAdd(sumTotalContMoney,linkVO.getContMoney());
                sumTotalContTaxMoney =  ComputeUtil.safeAdd(sumTotalContTaxMoney,linkVO.getContTaxMoney());
            }
            sumTotalContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotaltaxMny, incomeMny));

            sumIndirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotaltaxMny, incomeMny));
            sumIndirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotalContTaxMoney, incomeMny));
            ExecutionLinkVO executionLinkVO3 = new ExecutionLinkVO();
            executionLinkVO3.setId(Long.parseLong("66666"));
            executionLinkVO3.setName("合计");
            executionLinkVO3.setMny(sumTotalMny);
            executionLinkVO3.setTaxMny(sumTotaltaxMny);
            executionLinkVO3.setMnyScale(sumIndirectMnyScale);
            executionLinkVO3.setContMnyScale(sumIndirectContMnyScale);
            executionLinkVO3.setContMoney(sumTotalContMoney);
            executionLinkVO3.setContTaxMoney(sumTotalContTaxMoney);
            List<ExecutionLinkVO> linkVOList = new ArrayList<>();
            for (int i = 0; i<=4; i++){
                linkVOList.add(linkVOS.get(i));
            }
            linkVOList.add(executionLinkVO);
            for (int i = 5; i<=6; i++){
                linkVOList.add(linkVOS.get(i));
            }
            linkVOList.add(executionLinkVO2);
            linkVOList.add(executionLinkVO3);
            return linkVOList;
        }else{
            return linkVOS;
        }
    }

    @Override
    public void deleteByProjectIdPhy(Long projectId) {
        baseMapper.deleteByProjectIdPhy(projectId);
    }
}
