package com.ejianc.business.targetcost.utils;

import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DutyCalcUtil {

    private final String COST_PARAM = "P-S713uy0201";

    private IParamConfigApi paramConfigApi;

    public DutyCalcUtil(IParamConfigApi paramConfigApi) {
        this.paramConfigApi = paramConfigApi;
    }

    /**
     * 汇总金额和数量
     */
    public static void gatherMnyAndNum(Map<String, Object> now, List<Map<String, Object>> list) {
        BigDecimal mny = null;
        BigDecimal taxMny = null;

        BigDecimal planMoney = null;
        BigDecimal planTaxMoney = null;
        BigDecimal outPlanMoney = null;
        BigDecimal outPlanTaxMoney = null;

        BigDecimal contMoney = null;
        BigDecimal contTaxMoney = null;
        BigDecimal outContMoney = null;
        BigDecimal outContTaxMoney = null;

        BigDecimal storeMoney = null;
        BigDecimal storeTaxMoney = null;
        BigDecimal outStoreMoney = null;
        BigDecimal outStoreTaxMoney = null;

        BigDecimal otherMoney = null;
        BigDecimal otherTaxMoney = null;
        BigDecimal outOtherMoney = null;
        BigDecimal outOtherTaxMoney = null;

        BigDecimal settleMoney = null;
        BigDecimal settleTaxMoney = null;
        BigDecimal outSettleMoney = null;
        BigDecimal outSettleTaxMoney = null;

        Boolean allCostFlag = false;

        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                gatherMnyAndNum(ypd, (List) ypd.get("children"));
            }
            mny = ComputeUtil.safeAdd(mny, getBigDecimalValue(ypd, "mny"));
            taxMny = ComputeUtil.safeAdd(taxMny, getBigDecimalValue(ypd, "taxMny"));

            planMoney = ComputeUtil.safeAdd(planMoney, getBigDecimalValue(ypd, "planMoney"));
            planTaxMoney = ComputeUtil.safeAdd(planTaxMoney, getBigDecimalValue(ypd, "planTaxMoney"));
            outPlanMoney = ComputeUtil.safeAdd(outPlanMoney, getBigDecimalValue(ypd, "outPlanMoney"));
            outPlanTaxMoney = ComputeUtil.safeAdd(outPlanTaxMoney, getBigDecimalValue(ypd, "outPlanTaxMoney"));

            contMoney = ComputeUtil.safeAdd(contMoney, getBigDecimalValue(ypd, "contMoney"));
            contTaxMoney = ComputeUtil.safeAdd(contTaxMoney, getBigDecimalValue(ypd, "contTaxMoney"));
            outContMoney = ComputeUtil.safeAdd(outContMoney, getBigDecimalValue(ypd, "outContMoney"));
            outContTaxMoney = ComputeUtil.safeAdd(outContTaxMoney, getBigDecimalValue(ypd, "outContTaxMoney"));

            storeMoney = ComputeUtil.safeAdd(storeMoney, getBigDecimalValue(ypd, "storeMoney"));
            storeTaxMoney = ComputeUtil.safeAdd(storeTaxMoney, getBigDecimalValue(ypd, "storeTaxMoney"));
            outStoreMoney = ComputeUtil.safeAdd(outStoreMoney, getBigDecimalValue(ypd, "outStoreMoney"));
            outStoreTaxMoney = ComputeUtil.safeAdd(outStoreTaxMoney, getBigDecimalValue(ypd, "outStoreTaxMoney"));

            otherMoney = ComputeUtil.safeAdd(otherMoney, getBigDecimalValue(ypd, "otherMoney"));
            otherTaxMoney = ComputeUtil.safeAdd(otherTaxMoney, getBigDecimalValue(ypd, "otherTaxMoney"));
            outOtherMoney = ComputeUtil.safeAdd(outOtherMoney, getBigDecimalValue(ypd, "outOtherMoney"));
            outOtherTaxMoney = ComputeUtil.safeAdd(outOtherTaxMoney, getBigDecimalValue(ypd, "outOtherTaxMoney"));

            settleMoney = ComputeUtil.safeAdd(settleMoney, getBigDecimalValue(ypd, "settleMoney"));
            settleTaxMoney = ComputeUtil.safeAdd(settleTaxMoney, getBigDecimalValue(ypd, "settleTaxMoney"));
            outSettleMoney = ComputeUtil.safeAdd(outSettleMoney, getBigDecimalValue(ypd, "outSettleMoney"));
            outSettleTaxMoney = ComputeUtil.safeAdd(outSettleTaxMoney, getBigDecimalValue(ypd, "outSettleTaxMoney"));

            if (DocTypeEnum.成本科目.getCode().equals(ypd.get("docType"))) {
                allCostFlag = true;
            }
        }
        if(now != null){
            now.put("allCostFlag", allCostFlag);

            now.put("outPlanMoney", outPlanMoney);
            now.put("outPlanTaxMoney", outPlanTaxMoney);
            now.put("outContMoney", outContMoney);
            now.put("outContTaxMoney", outContTaxMoney);
            now.put("outStoreMoney", outStoreMoney);
            now.put("outStoreTaxMoney", outStoreTaxMoney);
            now.put("outOtherMoney", outOtherMoney);
            now.put("outOtherTaxMoney", outOtherTaxMoney);
            now.put("outSettleMoney", outSettleMoney);
            now.put("outSettleTaxMoney", outSettleTaxMoney);

            if (!(Boolean) now.get("selfScopeFlag") || (!(Boolean) now.get("leafFlag") && allCostFlag)) {
                now.put("planMoney", planMoney);
                now.put("planTaxMoney", planTaxMoney);

                now.put("contMoney", contMoney);
                now.put("contTaxMoney", contTaxMoney);

                now.put("storeMoney", storeMoney);
                now.put("storeTaxMoney", storeTaxMoney);

                now.put("otherMoney", otherMoney);
                now.put("otherTaxMoney", otherTaxMoney);

                now.put("settleMoney", settleMoney);
                now.put("settleTaxMoney", settleTaxMoney);
            }
        }
    }

    public static BigDecimal getBigDecimalValue(Map<String, Object> ypd, String code){
        return ypd.get(code) == null ? null : (BigDecimal) ypd.get(code);
    }

    public Map<String, List<String>> getSubCostMap(){
        //分包有节点结算和月度结算，根据参数判断，把哪种结算数据过滤掉
        List<String> unSubList = new ArrayList<>();
        List<String> subList = new ArrayList<>();
        CommonResponse<ParamRegisterSetVO> subResponse = paramConfigApi.getByCode(COST_PARAM);
        if (subResponse.isSuccess() && (null == subResponse.getData() || (null != subResponse.getData() && subResponse.getData().getValueData().equals("1")))) {
            subList.add(BussinessTypeEnum.专业分包月度结算单.getCode());
            subList.add(BussinessTypeEnum.劳务分包月度结算单.getCode());
            unSubList.add(BussinessTypeEnum.专业分包节点结算单.getCode());
            unSubList.add(BussinessTypeEnum.劳务分包节点结算单.getCode());
        } else {
            subList.add(BussinessTypeEnum.专业分包节点结算单.getCode());
            subList.add(BussinessTypeEnum.劳务分包节点结算单.getCode());
            unSubList.add(BussinessTypeEnum.专业分包月度结算单.getCode());
            unSubList.add(BussinessTypeEnum.劳务分包月度结算单.getCode());
        }
        Map<String, List<String>> map = new HashMap<>();
        map.put("subList", subList);
        map.put("unSubList", unSubList);
        return  map;
    }

    public static void setValue(TotalCacheEntity totalCacheEntity, TotalExecutionVO totalExecutionVO){
        if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setPlanNum(null);
            totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setContNum(null);
            totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setStoreNum(null);
            totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setOtherNum(null);
            totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), totalExecutionVO.getTaxMoney()));
        }else  if (BillCategoryEnum.结算.getCode().equals(totalExecutionVO.getBillCategory())) {
            totalCacheEntity.setSettleNum(null);
            totalCacheEntity.setSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleMoney(), totalExecutionVO.getMoney()));
            totalCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleTaxMoney(), totalExecutionVO.getTaxMoney()));
        }
    }

    public static void setValue(TotalCacheEntity totalCacheEntity, List<DetailCacheEntity> itemEntityList, TotalExecutionVO totalExecutionVO){
        if(totalCacheEntity.getLeafFlag() && BooleanUtils.isTrue(totalCacheEntity.getSelfScopeFlag()) && !DocTypeEnum.成本科目.getCode().equals(totalCacheEntity.getDocType())){
            if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), totalExecutionVO.getTaxMoney()));
            }else  if (BillCategoryEnum.结算.getCode().equals(totalExecutionVO.getBillCategory())) {
                totalCacheEntity.setSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleMoney(), totalExecutionVO.getMoney()));
                totalCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleTaxMoney(), totalExecutionVO.getTaxMoney()));
            }
        }else{
            if(totalCacheEntity.getLeafFlag()){
                if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setPlanMoney(null);
                    totalCacheEntity.setPlanNum(null);
                    totalCacheEntity.setPlanTaxMoney(null);
                    totalCacheEntity.setOutPlanMoney(null);
                    totalCacheEntity.setOutPlanTaxMoney(null);
                }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setContMoney(null);
                    totalCacheEntity.setContNum(null);
                    totalCacheEntity.setContTaxMoney(null);
                    totalCacheEntity.setOutContMoney(null);
                    totalCacheEntity.setOutContTaxMoney(null);
                }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setStoreMoney(null);
                    totalCacheEntity.setStoreNum(null);
                    totalCacheEntity.setStoreTaxMoney(null);
                    totalCacheEntity.setOutStoreMoney(null);
                    totalCacheEntity.setOutStoreTaxMoney(null);
                }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setOtherMoney(null);
                    totalCacheEntity.setOtherNum(null);
                    totalCacheEntity.setOtherTaxMoney(null);
                    totalCacheEntity.setOutOtherMoney(null);
                    totalCacheEntity.setOutOtherTaxMoney(null);
                }else  if (BillCategoryEnum.结算.getCode().equals(totalExecutionVO.getBillCategory())) {
                    totalCacheEntity.setSettleMoney(null);
                    totalCacheEntity.setSettleNum(null);
                    totalCacheEntity.setSettleTaxMoney(null);
                    totalCacheEntity.setOutSettleMoney(null);
                    totalCacheEntity.setOutSettleTaxMoney(null);
                }
            }
            if(CollectionUtils.isNotEmpty(itemEntityList)){
                for(DetailCacheEntity detailCacheEntity : itemEntityList){
                    if (BillCategoryEnum.计划.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setPlanNum(ComputeUtil.safeAdd(totalCacheEntity.getPlanNum(), detailCacheEntity.getPlanNum()));
                        totalCacheEntity.setPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanMoney(), detailCacheEntity.getPlanMoney()));
                        totalCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getPlanTaxMoney(), detailCacheEntity.getPlanTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutPlanMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutPlanMoney(), detailCacheEntity.getPlanMoney()));
                            totalCacheEntity.setOutPlanTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutPlanTaxMoney(), detailCacheEntity.getPlanTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.合同.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setContNum(ComputeUtil.safeAdd(totalCacheEntity.getContNum(), detailCacheEntity.getContNum()));
                        totalCacheEntity.setContMoney(ComputeUtil.safeAdd(totalCacheEntity.getContMoney(), detailCacheEntity.getContMoney()));
                        totalCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getContTaxMoney(), detailCacheEntity.getContTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutContMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutContMoney(), detailCacheEntity.getContMoney()));
                            totalCacheEntity.setOutContTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutContTaxMoney(), detailCacheEntity.getContTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.入库.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setStoreNum(ComputeUtil.safeAdd(totalCacheEntity.getStoreNum(), detailCacheEntity.getStoreNum()));
                        totalCacheEntity.setStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreMoney(), detailCacheEntity.getStoreMoney()));
                        totalCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getStoreTaxMoney(), detailCacheEntity.getStoreTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutStoreMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutStoreMoney(), detailCacheEntity.getStoreMoney()));
                            totalCacheEntity.setOutStoreTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutStoreTaxMoney(), detailCacheEntity.getStoreTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.其他.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setOtherNum(ComputeUtil.safeAdd(totalCacheEntity.getOtherNum(), detailCacheEntity.getOtherNum()));
                        totalCacheEntity.setOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherMoney(), detailCacheEntity.getOtherMoney()));
                        totalCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOtherTaxMoney(), detailCacheEntity.getOtherTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutOtherMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutOtherMoney(), detailCacheEntity.getOtherMoney()));
                            totalCacheEntity.setOutOtherTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutOtherTaxMoney(), detailCacheEntity.getOtherTaxMoney()));
                        }
                    }else  if (BillCategoryEnum.结算.getCode().equals(totalExecutionVO.getBillCategory())) {
                        totalCacheEntity.setSettleNum(ComputeUtil.safeAdd(totalCacheEntity.getSettleNum(), detailCacheEntity.getSettleNum()));
                        totalCacheEntity.setSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleMoney(), detailCacheEntity.getSettleMoney()));
                        totalCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getSettleTaxMoney(), detailCacheEntity.getSettleTaxMoney()));
                        if(null == detailCacheEntity.getDutyItemId()) {
                            totalCacheEntity.setOutSettleMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutSettleMoney(), detailCacheEntity.getSettleMoney()));
                            totalCacheEntity.setOutSettleTaxMoney(ComputeUtil.safeAdd(totalCacheEntity.getOutSettleTaxMoney(), detailCacheEntity.getSettleTaxMoney()));
                        }
                    }
                }
            }
        }
    }

    public static void setDetailValue(DetailCacheEntity detailCacheEntity, DetailExecutionVO detailExecutionVO, TotalExecutionVO totalVO) {
        if (BillCategoryEnum.计划.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setPlanMoney(ComputeUtil.safeAdd(detailCacheEntity.getPlanMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setPlanNum(ComputeUtil.safeAdd(detailCacheEntity.getPlanNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setPlanTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getPlanTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.合同.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setContMoney(ComputeUtil.safeAdd(detailCacheEntity.getContMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setContNum(ComputeUtil.safeAdd(detailCacheEntity.getContNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setContTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getContTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.入库.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setStoreMoney(ComputeUtil.safeAdd(detailCacheEntity.getStoreMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setStoreNum(ComputeUtil.safeAdd(detailCacheEntity.getStoreNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setStoreTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getStoreTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.其他.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setOtherMoney(ComputeUtil.safeAdd(detailCacheEntity.getOtherMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setOtherNum(ComputeUtil.safeAdd(detailCacheEntity.getOtherNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setOtherTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getOtherTaxMoney(), detailExecutionVO.getTaxMoney()));
        } else if (BillCategoryEnum.结算.getCode().equals(totalVO.getBillCategory())) {
            detailCacheEntity.setSettleMoney(ComputeUtil.safeAdd(detailCacheEntity.getSettleMoney(), detailExecutionVO.getMoney()));
            detailCacheEntity.setSettleNum(ComputeUtil.safeAdd(detailCacheEntity.getSettleNum(), detailExecutionVO.getNum()));
            detailCacheEntity.setSettleTaxMoney(ComputeUtil.safeAdd(detailCacheEntity.getSettleTaxMoney(), detailExecutionVO.getTaxMoney()));
        }
    }
}
