/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.targetcost.bean.DetailCacheEntity;
import com.ejianc.business.targetcost.bean.DetailExecutionEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.service.IDetailCacheService;
import com.ejianc.business.targetcost.service.IDetailExecutionService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.ExecutionReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"execution"})
public class ExecutionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IDetailExecutionService detailExecutionService;
    @Autowired
    private ITotalCacheService totalCacheService;
    @Autowired
    private IDetailCacheService detailCacheService;
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;

    @RequestMapping(value={"/reCalc"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> reCalc(@RequestParam(value="projectId") Long projectId) {
        return this.totalExecutionService.reCalc(projectId);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecutionReportVO> queryReport(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.totalCacheService.queryReport(projectId));
    }

    @RequestMapping(value={"/queryReportDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DetailCacheEntity>> queryReportDetail(@RequestParam(value="dutyDetailId") Long dutyDetailId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.detailCacheService.queryReportDetail(dutyDetailId, false));
    }

    @RequestMapping(value={"/queryAllReportDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DetailCacheEntity>> queryAllReportDetail(@RequestParam(value="dutyDetailId") Long dutyDetailId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.detailCacheService.queryReportDetail(dutyDetailId, true));
    }

    @RequestMapping(value={"/loadExecItemList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DutyDetailItemEntity>> loadExecItemList(@RequestParam(value="projectId") Long projectId, @RequestParam(value="feeDetailId") Long feeDetailId) {
        List<DetailCacheEntity> detailCacheEntityList = this.detailCacheService.queryByProjAndFeeDetail(projectId, feeDetailId, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList(detailCacheEntityList, DutyDetailItemEntity.class));
    }

    @RequestMapping(value={"/linkTotalExec"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TotalExecutionEntity>> linkTotalExec(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        HashMap<String, String> billTypeMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("feeDetailId")) {
                Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
                scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, (Object)feeDetailId);
                List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
                ArrayList<String> scopeList = new ArrayList<String>();
                for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                    scopeList.add(scopeEntity.getBillCode());
                    billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                }
                param.getParams().put("bussinessType", new Parameter("in", scopeList));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("billCategory")) {
                Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                param.getParams().put("billCategory", new Parameter("eq", (Object)billCategory));
            }
        } else {
            return CommonResponse.error((String)"condition\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        IPage page = this.totalExecutionService.queryPage(param, false);
        for (TotalExecutionEntity entity : page.getRecords()) {
            entity.setBillTypeName((String)billTypeMap.get(entity.getBussinessType()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/linkDetailExec"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DetailExecutionEntity>> linkDetailExec(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        HashMap<String, String> billTypeMap = new HashMap<String, String>();
        ArrayList<Long> categoryList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("docId")) {
                if (null != conditionMap.get("feeDetailId")) {
                    Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                    LambdaQueryWrapper feeQuery = new LambdaQueryWrapper();
                    feeQuery.like(FeeDetailEntity::getInnerCode, (Object)feeDetailId);
                    List feeEntities = this.feeDetailService.list((Wrapper)feeQuery);
                    ArrayList<Long> longList = new ArrayList<Long>();
                    for (FeeDetailEntity feeDetailEntity : feeEntities) {
                        longList.add(feeDetailEntity.getId());
                        categoryList.add(feeDetailEntity.getCategoryId());
                    }
                    LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
                    scopeQuery.in(FeeDetailScopeEntity::getFeeDetailId, longList);
                    List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
                    ArrayList<String> scopeList = new ArrayList<String>();
                    for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                        scopeList.add(scopeEntity.getBillCode());
                        billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                    }
                    param.getParams().put("bussinessType", new Parameter("in", scopeList));
                }
                if (null != conditionMap.get("projectId")) {
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                }
                if (null != conditionMap.get("billCategory")) {
                    Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                    param.getParams().put("billCategory", new Parameter("eq", (Object)billCategory));
                }
            } else {
                Long docId = Long.valueOf(conditionMap.get("docId").toString());
                param.getParams().put("docId", new Parameter("eq", (Object)docId));
                if (null != conditionMap.get("docType")) {
                    Integer docType = Integer.valueOf(conditionMap.get("docType").toString());
                    param.getParams().put("docType", new Parameter("eq", (Object)docType));
                }
                if (null != conditionMap.get("projectId")) {
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                }
                if (null != conditionMap.get("billCategory")) {
                    Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                    param.getParams().put("billCategory", new Parameter("eq", (Object)billCategory));
                }
                if (null != conditionMap.get("feeDetailId")) {
                    Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                    LambdaQueryWrapper scopeQuery = new LambdaQueryWrapper();
                    scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, (Object)feeDetailId);
                    List scopeEntities = this.feeDetailScopeService.list((Wrapper)scopeQuery);
                    for (FeeDetailScopeEntity scopeEntity : scopeEntities) {
                        billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                    }
                }
            }
        } else {
            return CommonResponse.error((String)"condition\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isNotEmpty(categoryList)) {
            param.getComplexParams().add(this.getPageQueryParam(categoryList));
        }
        IPage page = this.detailExecutionService.queryPage(param, false);
        for (DetailExecutionEntity entity : page.getRecords()) {
            entity.setBillTypeName((String)billTypeMap.get(entity.getBussinessType()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private ComplexParam getPageQueryParam(List<Long> categoryList) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        for (Long categoryId : categoryList) {
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("category_inner_code", new Parameter("like", (Object)categoryId));
            c1.getComplexParams().add(c2);
        }
        return c1;
    }

    @RequestMapping(value={"/linkFeeScale"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ExecutionLinkVO>> linkFeeScale(@RequestParam Long projectId) {
        List<ExecutionLinkVO> linkVOS = this.totalCacheService.linkFeeScale(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", linkVOS);
    }

    @RequestMapping(path={"/ctrlWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> ctrlWarn(HttpServletRequest request) {
        return this.totalExecutionService.ctrlWarn(request);
    }
}

