package com.ejianc.business.targetcost.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.enums.ConversionEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.business.zhht.vo.*;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/12/12 16:01
 */
@Service("zhhtBuildHandler")
public class ZHHTHandler extends ConversionBaseHandler implements IConversioneHandler {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;


    @Override
    public List<DutyEntity> handlerDetail(DutyEntity dutyEntity, FeeVO feeVO, BaseVO baseVO) {
        List<DutyEntity> resp = new ArrayList<>();
        BuildDutyVO buildDutyVO = (BuildDutyVO) baseVO;

        Map<String, Object> handleApi = new HashMap<>();
        handleApi.put("人工费", shareLabsubApi);
        handleApi.put("专业费", shareProsubApi);
        handleApi.put("材料费", shareMaterialApi);
        handleApi.put("机械费", shareEquipmentApi); //华泰 设备选择的也是 物料档案 故这里使用物料API
        handleApi.put("措施费", null);
        handleApi.put("其他费", null);
//        handleApi.put("特种设备费", shareLabsubApi);

        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        List<Future<DutyEntity>> futures = new ArrayList<>();
        CommonCallable call = null;
        Future<DutyEntity> future = null;
        for(String handleType : handleApi.keySet()) {
            call = new CommonCallable(buildDutyVO, dutyEntity, feeVO, handleType, handleApi.get(handleType), "机械费".equals(handleType) ? shareLabsubApi : null);
            future = threadPool.submit(call);
            futures.add(future);
        }

        try {
            for(Future<DutyEntity> f : futures) {
                resp.add(f.get());
            }
        } catch (Exception e) {
            logger.error("项目策划转换异常：", e);
            throw new BusinessException("项目策划转换异常, ", e);
        } finally {
            threadPool.shutdown();
        }

        return resp;
    }

    @Override
    public void checkFeeCode(FeeVO feeVO) {
        //检测费用模板中是否配置对应的费用项
    }

    @Override
    public CommonResponse<String> push(BaseVO baseVO, Boolean isEff) {
        BuildDutyVO buildDutyVO = (BuildDutyVO) baseVO;
        DutyEntity dutyEntity = BeanMapper.map(buildDutyVO, DutyEntity.class);
        dutyEntity.setFirstImportId(buildDutyVO.getBaseDutyId());
        dutyEntity.setImportId(buildDutyVO.getId());
        dutyEntity.setImportType(ConversionEnum.中核华泰房建.getCode());

        handlerHead(dutyEntity, isEff, baseVO);

        return CommonResponse.success("转换项目策划单据成功！");
    }

    @Override
    public CommonResponse<String> delete(Long importId) {
        deleteDuty(importId);
        return CommonResponse.success("删除目标成本单据成功！");
    }

    class CommonCallable implements Callable<DutyEntity> {
        private RequestAttributes context = RequestContextHolder.getRequestAttributes();
        private BuildDutyVO buildDutyVO;
        private DutyEntity baseDutyEntity;
        private FeeVO feeVO;
        private String handleType;
        private Object restApi;
        private Object restApi2;

        public CommonCallable(BuildDutyVO buildDutyVO, DutyEntity baseDutyEntity, FeeVO feeVO, String handleType, Object restApi, Object restApi2) {
            this.buildDutyVO = buildDutyVO;
            this.baseDutyEntity = baseDutyEntity;
            this.feeVO = feeVO;
            this.handleType = handleType;
            this.restApi = restApi;
            this.restApi2 = restApi2;
        }

        @Override
        public DutyEntity call() throws Exception {
            RequestContextHolder.setRequestAttributes(context);
            switch (handleType) {
                case "人工费":
                    return dealLasubData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "特种设备费":
                    return dealSubEquipData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "专业费":
                    return dealProsubData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "材料费":
                    return dealMaterialData(buildDutyVO, baseDutyEntity, feeVO, restApi);
                case "机械费":
                    return dealEquipData(buildDutyVO, baseDutyEntity, feeVO, restApi, restApi2);
                case "措施费":
                    return dealMeasureData(buildDutyVO.getMeasureDetailList(), baseDutyEntity, feeVO, handleType);
                case "其他费":
                    return dealOtherFeeData(buildDutyVO.getOtherDetailList(), baseDutyEntity, feeVO, handleType);
                default:
                    throw new BusinessException("错误的费用名称" + handleType);
            }
        }
    }

    /**
     * 其他费用转换
     *
     * @param vos
     * @param sourceDutyEntity
     * @param feeVO
     * @param feeName
     * @return
     */
    private DutyEntity dealOtherFeeData(List<BuildDutyOtherDetailVO> vos, DutyEntity sourceDutyEntity, FeeVO feeVO, String feeName) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        //安全文明施工费
        Long aqwmsgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (feeName.equals(detailVO.getName())) {
                aqwmsgfId = detailVO.getId();
            }
        }

        //获取 措施费下 所有页子节点
        List<String> leafFeeDetailName = new ArrayList<>();
        List<Long> leafFeeDetailIds = new ArrayList<>();
        Map<String, String> nameTreeIndexMap = new HashMap<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if(null != detailVO.getLeafFlag() && detailVO.getLeafFlag() && detailVO.getInnerCode().startsWith(aqwmsgfId.toString())) {
                leafFeeDetailName.add(detailVO.getName());
                leafFeeDetailIds.add(detailVO.getId());
            }
        }

        Map<String, List<BuildDutyOtherDetailVO>> dutyDetailMap = new HashMap<>();

        vos.stream().filter(item -> leafFeeDetailName.contains(item.getOtherName())).forEach(item -> {
            nameTreeIndexMap.put(item.getOtherName(), item.getOtherTreeIndex());
            dutyDetailMap.put(item.getOtherTreeIndex(), new ArrayList<>());
        });
        vos.stream().filter(cData -> null != cData.getLeafFlag() && cData.getLeafFlag()).forEach(cData -> {
            for(String treeIndex : dutyDetailMap.keySet()) {
                if(cData.getOtherTreeIndex().startsWith(treeIndex)) {
                    dutyDetailMap.get(treeIndex).add(cData);
                }
            }
        });

        logger.info("other: {}", JSONObject.toJSONString(nameTreeIndexMap));
        logger.info("leafFeeDetailIds: {}", JSONObject.toJSONString(leafFeeDetailIds));

        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (!detailEntity.getLeafFlag()) {
                continue;
            }
            if(!leafFeeDetailIds.contains(detailEntity.getFeeDetailId())) {
                continue;
            }
            logger.info("other dutyEntity name ： {}",detailEntity.getFeeDetailName());

            int num = 1;
            if(dutyDetailMap.containsKey(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) {
                for(BuildDutyOtherDetailVO cData : dutyDetailMap.get(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) {
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(cData.getOtherCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(cData.getOtherCode());
                    }
                    itemEntity.setName(cData.getOtherName());
                    itemEntity.setUnitName(cData.getOtherUnitName());
                    itemEntity.setTaxRate(cData.getOtherCostRate());
                    itemEntity.setPrice(cData.getOtherCostPrice());
                    itemEntity.setTaxPrice(cData.getOtherCostTaxPrice());
                    itemEntity.setAmount(cData.getOtherNum());
                    itemEntity.setMny(cData.getOtherCostMny());
                    itemEntity.setTaxMny(cData.getOtherCostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    num++;
                }
            }

        }

        return dutyEntity;
    }


    /**
     * 措施费用转换
     *
     * @param vos
     * @param sourceDutyEntity
     * @param feeVO
     * @param feeName
     * @return
     */
    private DutyEntity dealMeasureData(List<BuildDutyMeasureDetailVO> vos, DutyEntity sourceDutyEntity, FeeVO feeVO, String feeName) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        //措施费
        Long aqwmsgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (feeName.equals(detailVO.getName())) {
                aqwmsgfId = detailVO.getId();
            }
        }

        //获取 措施费下 所有页子节点
        List<String> leafFeeDetailName = new ArrayList<>();
        Map<String, String> nameTreeIndexMap = new HashMap<>();
        List<Long> leafFeeDetailIds = new ArrayList<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if(null != detailVO.getLeafFlag() && detailVO.getLeafFlag() && detailVO.getInnerCode().startsWith(aqwmsgfId.toString())) {
                leafFeeDetailName.add(detailVO.getName());
                leafFeeDetailIds.add(detailVO.getId());
            }
        }

        Map<String, List<BuildDutyMeasureDetailVO>> dutyDetailMap = new HashMap<>();

        vos.stream().filter(item -> leafFeeDetailName.contains(item.getMeasureName())).forEach(item -> {
            nameTreeIndexMap.put(item.getMeasureName(), item.getMeasureTreeIndex());
            dutyDetailMap.put(item.getMeasureTreeIndex(), new ArrayList<>());
        });
        vos.stream().filter(cData -> null != cData.getLeafFlag() && cData.getLeafFlag()).forEach(cData -> {
            for(String treeIndex : dutyDetailMap.keySet()) {
                if(cData.getMeasureTreeIndex().startsWith(treeIndex)) {
                    dutyDetailMap.get(treeIndex).add(cData);
                }
            }
        });

        logger.info("measure: {}", JSONObject.toJSONString(nameTreeIndexMap));

        for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
            if (!detailEntity.getLeafFlag()) {
                continue;
            }
            if(!leafFeeDetailIds.contains(detailEntity.getFeeDetailId())) {
                continue;
            }
            logger.info("measure dutyEntity name ： {}",detailEntity.getFeeDetailName());
            int num = 1;
            if(dutyDetailMap.containsKey(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) {
                for(BuildDutyMeasureDetailVO cData : dutyDetailMap.get(nameTreeIndexMap.get(detailEntity.getFeeDetailName()))) {
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(cData.getMeasureCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(cData.getMeasureCode());
                    }
                    itemEntity.setName(cData.getMeasureName());
                    itemEntity.setUnitName(cData.getMeasureUnitName());
                    itemEntity.setTaxRate(cData.getMeasureCostRate());
                    itemEntity.setPrice(cData.getMeasureCostPrice());
                    itemEntity.setTaxPrice(cData.getMeasureCostTaxPrice());
                    itemEntity.setAmount(cData.getMeasureNum());
                    itemEntity.setMny(cData.getMeasureCostMny());
                    itemEntity.setTaxMny(cData.getMeasureCostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                    num++;
                }
            }

        }

        return dutyEntity;
    }

    /**
     * 机械费转换
     *
     * @param buildDutyVO
     * @param sourceDutyEntity
     * @param feeVO
     * @param restApi
     * @return
     */
    private DutyEntity dealEquipData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi, Object restApi2) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareEquipmentApi _restApi = (IShareEquipmentApi) restApi;
        IShareLabsubApi _labsubrestApi = (IShareLabsubApi) restApi2;
        //物资分类的内码map
//        Map<Long, String> matCtyLongInnerMap = new HashMap<>();
//        Map<String, String> matCtyStringInnerMap = new HashMap<>();
        if(CollectionUtils.isEmpty(feeVO.getFeeDetailList())) {
            return dutyEntity;
        }
        //机械设备费
        Long jxfId = null, tzsbfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238542").equals(detailVO.getFeePropId())) {
                jxfId = detailVO.getId();
            }
            if (Long.valueOf("1932409448614203393").equals(detailVO.getFeePropId())) {
                tzsbfId = detailVO.getId();
            }
        }
        if (null == jxfId) {
            throw new BusinessException("费用模板中未配置【机械费】的费用项，无法转换！");
        }
        //机械设备费下的主键集合
        Set<Long> jxfSet = new HashSet<>();
        Set<String> jxfDetailNameSet = new HashSet<>();
        Set<Long> tzsbfSet = new HashSet<>();
        Set<String> tzsbfDetailNameSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(jxfId))) {
                jxfSet.add(detailVO.getId());
                jxfDetailNameSet.add(detailVO.getName());
            }
            if (detailVO.getInnerCode().contains(String.valueOf(tzsbfId))) {
                tzsbfSet.add(detailVO.getId());
                tzsbfDetailNameSet.add(detailVO.getName());
            }
        }
        //其他机械设备费
        Long qtjxfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238543").equals(detailVO.getFeePropId()) && jxfSet.contains(detailVO.getId())) {
                qtjxfId = detailVO.getId();
            }
        }
        if (null == qtjxfId) {
            logger.error("费用模板中未配置【机械费】的费用项");
            qtjxfId = -1L;
//            throw new BusinessException("费用模板中未配置【机械费】的费用项，无法转换！");
        }

        logger.info(" ******* jxfSet : {}", JSONObject.toJSONString(jxfSet));
        logger.info(" jxfDetailNameSet : {}", JSONObject.toJSONString(jxfDetailNameSet));

        logger.info(" ******* tzsbfSet : {}", JSONObject.toJSONString(tzsbfSet));
        logger.info(" ******* tzsbfDetailNameSet : {}", JSONObject.toJSONString(tzsbfDetailNameSet));

        List<String> equipCodeList = new ArrayList<>();
        List<String> labsubCodeList = new ArrayList<>();
        List<String> tzsbTreeIndex = new ArrayList<>();
        List<String> tzsbLeafTreeIndex = new ArrayList<>();
        List<String> jxfTreeIndex = new ArrayList<>();
        List<String> jxfLeafTreeIndex = new ArrayList<>();
        buildDutyVO.getEquipDetailList().stream().forEach(item -> {
            if(jxfDetailNameSet.contains(item.getEquipDocName())) {
                jxfTreeIndex.add(item.getEquipTreeIndex());
            }
            if(tzsbfDetailNameSet.contains(item.getEquipDocName())) {
                tzsbTreeIndex.add(item.getEquipTreeIndex());
            }
        });

        logger.info(" ******* jxfTreeIndex : {}", JSONObject.toJSONString(jxfTreeIndex));
        logger.info(" ******* tzsbTreeIndex : {}", JSONObject.toJSONString(tzsbTreeIndex));

        buildDutyVO.getEquipDetailList().stream().filter(cData -> null != cData.getLeafFlag() && cData.getLeafFlag()).forEach(cData -> {
            for(String treeIndex : tzsbTreeIndex) {
                if(cData.getEquipTreeIndex().startsWith(treeIndex)) {
                    tzsbLeafTreeIndex.add(cData.getEquipTreeIndex());
                    labsubCodeList.add(cData.getEquipDocCode());
                }
            }
            for(String treeIndex : jxfTreeIndex) {
                if(cData.getEquipTreeIndex().startsWith(treeIndex)) {
                    equipCodeList.add(cData.getEquipDocCode());
                    jxfLeafTreeIndex.add(cData.getEquipTreeIndex());
                }
            }
        });

        logger.info(" ******* tzsbLeafTreeIndex : {}", JSONObject.toJSONString(tzsbLeafTreeIndex));
        logger.info(" labsubCodeList : {}", JSONObject.toJSONString(labsubCodeList));

        logger.info(" ******* equipCodeList : {}", JSONObject.toJSONString(equipCodeList));
        logger.info(" ******* jxfLeafTreeIndex : {}", JSONObject.toJSONString(jxfLeafTreeIndex));


        Map<String, EquipmentVO> matMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(equipCodeList)) {
            CommonResponse<List<EquipmentVO>> matResponse = _restApi.queryEquipmentListByCodes(equipCodeList);
            if(CollectionUtils.isEmpty(matResponse.getData())) {
                logger.error("!!!!项目策划 机械费转换失败，查询到物料档案为空！");
                return dutyEntity;
            }
            if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
                matMap = matResponse.getData().stream().collect(Collectors.toMap(EquipmentVO::getCode, Function.identity(), (key1, key2) -> key1));
            }
        }

        CommonResponse<List<EquipmentCategoryVO>> equipCtyResponse = shareEquipmentApi.queryCategoryListByIds(new ArrayList<>());
        Map<Long, String> equipCtyLongInnerMap = new HashMap<>();
        Map<String, String> equipCtyStringInnerMap = new HashMap<>();
        for (EquipmentCategoryVO categoryVO : equipCtyResponse.getData()) {
            equipCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
            equipCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
        }

        //劳务分包分类的内码map
        Map<Long, String> labCtyInnerCodeMap = new HashMap<>();
        Map<String, LabsubItemVO> labSubMap = new HashMap<>();
        CommonResponse<List<LabsubCategoryVO>> labCtyResponse = _labsubrestApi.queryCategoryListByIds(new ArrayList<>());

        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(labCtyResponse.getData())) {
            labCtyInnerCodeMap = labCtyResponse.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        if(CollectionUtils.isNotEmpty(labsubCodeList)) {
            CommonResponse<List<LabsubItemVO>> labItemResponse = _labsubrestApi.queryItemListByCodes(labsubCodeList);
            if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty(labItemResponse.getData())) {
                labSubMap = labItemResponse.getData().stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
            }
        }

        int num = 1;
        for (BuildDutyEquipDetailVO buildEquipmentVO : buildDutyVO.getEquipDetailList()) {
            if (null == buildEquipmentVO.getLeafFlag() || !buildEquipmentVO.getLeafFlag() || null == buildEquipmentVO.getEquipNum()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }

                //匹配到档案
                if (StringUtils.isNotBlank(buildEquipmentVO.getEquipDocCode()) && matMap.containsKey(buildEquipmentVO.getEquipDocCode())) {
                    EquipmentVO equipmentVO = matMap.get(buildEquipmentVO.getEquipDocCode());
                    String innerCode = equipCtyLongInnerMap.get(equipmentVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(equipmentVO.getCode());
                        itemEntity.setName(equipmentVO.getName());
                        itemEntity.setModel(equipmentVO.getSpec());
                        itemEntity.setUnitId(equipmentVO.getUnitId());
                        itemEntity.setUnitName(equipmentVO.getUnitName());
                        itemEntity.setTaxRate(buildEquipmentVO.getEquipCostRate());
                        itemEntity.setPrice(buildEquipmentVO.getEquipCostPrice());
                        itemEntity.setTaxPrice(buildEquipmentVO.getEquipCostTaxPrice());
                        itemEntity.setAmount(buildEquipmentVO.getEquipNum());
                        itemEntity.setMny(buildEquipmentVO.getEquipCostMny());
                        itemEntity.setTaxMny(buildEquipmentVO.getEquipCostTaxMny());
                        itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipRentDays());
                        itemEntity.setCategoryId(equipmentVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(equipmentVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.设备档案.getCode());
                        itemEntity.setDocId(equipmentVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                } else if(StringUtils.isNotBlank(buildEquipmentVO.getEquipDocCode()) && labSubMap.containsKey(buildEquipmentVO.getEquipDocCode())) {
                    LabsubItemVO labsubItemVO = labSubMap.get(buildEquipmentVO.getEquipDocCode());
                    String labsubInnerCode = labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    if(((null != detailEntity.getCategoryId() && labsubInnerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(labsubInnerCode, detailEntity.getCategoryInnerCode()))
                            && tzsbfSet.contains(detailEntity.getFeeDetailId()))) {

                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(labsubItemVO.getTrawlingCode());
                        itemEntity.setName(labsubItemVO.getTrawlingName());
                        itemEntity.setPriceType(labsubItemVO.getPriceType());
                        itemEntity.setJobContent(labsubItemVO.getJobContent());
                        itemEntity.setUnitName(labsubItemVO.getUnitName());
                        itemEntity.setTaxRate(buildEquipmentVO.getEquipCostRate());
                        itemEntity.setPrice(buildEquipmentVO.getEquipCostPrice());
                        itemEntity.setTaxPrice(buildEquipmentVO.getEquipCostTaxPrice());
                        itemEntity.setAmount(buildEquipmentVO.getEquipNum());
                        itemEntity.setMny(buildEquipmentVO.getEquipCostMny());
                        itemEntity.setTaxMny(buildEquipmentVO.getEquipCostTaxMny());
                        itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(labsubInnerCode);
                        itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        itemEntity.setDocId(labsubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);

                    }
                } else if (StringUtils.isNotBlank(buildEquipmentVO.getEquipDocCode()) && equipCtyStringInnerMap.containsKey(buildEquipmentVO.getEquipDocCode())) {//匹配到分类
                    String innerCode = equipCtyStringInnerMap.get(buildEquipmentVO.getEquipDocCode());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && jxfSet.contains(detailEntity.getFeeDetailId()))) {
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), buildEquipmentVO.getEquipNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), buildEquipmentVO.getEquipCostMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), buildEquipmentVO.getEquipCostTaxMny()));
                    }
                } else if (detailEntity.getFeeDetailId().equals(qtjxfId)) {//匹配不到档案且子表为“其他机械设备费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(buildEquipmentVO.getEquipDocCode())) {
                        itemEntity.setCode(String.valueOf(num));
                    } else {
                        itemEntity.setCode(buildEquipmentVO.getEquipDocCode());
                    }
                    itemEntity.setName(buildEquipmentVO.getEquipDocName());
                    itemEntity.setUnitName(buildEquipmentVO.getEquipUnitName());
                    itemEntity.setTaxRate(buildEquipmentVO.getEquipCostRate());
                    itemEntity.setPrice(buildEquipmentVO.getEquipCostPrice());
                    itemEntity.setTaxPrice(buildEquipmentVO.getEquipCostTaxPrice());
                    itemEntity.setAmount(buildEquipmentVO.getEquipNum());
                    itemEntity.setMny(buildEquipmentVO.getEquipCostMny());
                    itemEntity.setTaxMny(buildEquipmentVO.getEquipCostTaxMny());
                    itemEntity.setRmatRentMonth(buildEquipmentVO.getEquipRentDays());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
            if (StringUtils.isBlank(buildEquipmentVO.getEquipDocCode())) {
                num++;
            }
        }

        return dutyEntity;
    }


    /**
     * 专业费转换
     *
     * @param buildDutyVO
     * @param sourceDutyEntity
     * @param feeVO
     * @param restApi
     * @return
     */
    private DutyEntity dealMaterialData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        IShareMaterialApi _restApi = (IShareMaterialApi) restApi;
        if(CollectionUtils.isEmpty(buildDutyVO.getMaterialDetailList())) {
            return dutyEntity;
        }
        //物资分类的内码map
        Map<Long, String> matCtyLongInnerMap = new HashMap<>();
        Map<String, String> matCtyStringInnerMap = new HashMap<>();

        //先判断费用模板有无关联材料费
        //材料费
        Long clfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238535").equals(detailVO.getFeePropId())) {
                clfId = detailVO.getId();
            }
        }
        if (null == clfId) {
            throw new BusinessException("费用模板中未配置【材料费】的费用项，无法转换！");
        }
        //材料费下的主键集合
        Set<Long> clfSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(clfId))) {
                clfSet.add(detailVO.getId());
            }
        }
        //其他材料费
        Long qtclfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238539").equals(detailVO.getFeePropId()) && clfSet.contains(detailVO.getId())) {
                qtclfId = detailVO.getId();
            }
        }
        if (null == qtclfId) {
            logger.error("费用模板中未配置【其他材料费】的费用项！");
            qtclfId = -1L;
//            throw new BusinessException("费用模板中未配置【其他材料费】的费用项，无法转换！");
        }
        List<String> codeList = buildDutyVO.getMaterialDetailList().stream()
                .filter(item -> null != item.getLeafFlag() && item.getLeafFlag() && StringUtils.isNotBlank(item.getMaterialDocCode()))
                .map(BuildDutyMaterialDetailVO::getMaterialDocCode).collect(Collectors.toList());

        CommonResponse<List<MaterialVO>> matResponse = _restApi.queryMaterialListByCodes(codeList);

        Map<String, MaterialVO> matMap = new HashMap<>();
        if (matResponse.isSuccess() && CollectionUtils.isNotEmpty(matResponse.getData())) {
            matMap = matResponse.getData().stream().collect(Collectors.toMap(MaterialVO::getCode, Function.identity(), (key1, key2) -> key1));
        }

        int num = 1;
        for (BuildDutyMaterialDetailVO buildMaterialVO : buildDutyVO.getMaterialDetailList()) {
            if (null == buildMaterialVO.getLeafFlag() || !buildMaterialVO.getLeafFlag() || null == buildMaterialVO.getMaterialNum()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                if(StringUtils.isNotBlank(buildMaterialVO.getMaterialDocCode())){
                    if(matMap.containsKey(buildMaterialVO.getMaterialDocCode())){
                        MaterialVO materialVO = matMap.get(buildMaterialVO.getMaterialDocCode());
                        if(!matCtyLongInnerMap.containsKey(materialVO.getCategoryId())){
                            CommonResponse<MaterialCategoryVO> response = _restApi.queryCategoryById(materialVO.getCategoryId());
                            MaterialCategoryVO categoryVO = response.getData();
                            matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                            matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                        }
                    }else{
                        if(!matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialDocCode())){
                            CommonResponse<MaterialCategoryVO> response = _restApi.queryCategoryByCode(buildMaterialVO.getMaterialDocCode());
                            if (response.isSuccess() && null != response.getData()) {
                                MaterialCategoryVO categoryVO = response.getData();
                                matCtyLongInnerMap.put(categoryVO.getId(), categoryVO.getInnerCode());
                                matCtyStringInnerMap.put(categoryVO.getCode(), categoryVO.getInnerCode());
                            }
                        }
                    }
                }
                //匹配到档案
                if (StringUtils.isNotBlank(buildMaterialVO.getMaterialDocCode()) && matMap.containsKey(buildMaterialVO.getMaterialDocCode())) {
                    MaterialVO materialVO = matMap.get(buildMaterialVO.getMaterialDocCode());
                    String innerCode = matCtyLongInnerMap.get(materialVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && clfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(materialVO.getCode());
                        itemEntity.setName(materialVO.getName());
                        itemEntity.setModel(materialVO.getSpec());
                        itemEntity.setUnitId(materialVO.getUnitId());
                        itemEntity.setUnitName(materialVO.getUnitName());
                        itemEntity.setTaxRate(buildMaterialVO.getMaterialCostRate());
                        itemEntity.setPrice(buildMaterialVO.getMaterialCostPrice());
                        itemEntity.setTaxPrice(buildMaterialVO.getMaterialCostTaxPrice());
                        itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                        itemEntity.setMny(buildMaterialVO.getMaterialCostMny());
                        itemEntity.setTaxMny(buildMaterialVO.getMaterialCostTaxMny());
                        itemEntity.setCategoryId(materialVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(materialVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.物料档案.getCode());
                        itemEntity.setDocId(materialVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                } else if (StringUtils.isNotBlank(buildMaterialVO.getMaterialDocCode()) && matCtyStringInnerMap.containsKey(buildMaterialVO.getMaterialDocCode())) {//匹配到分类
                    String innerCode = matCtyStringInnerMap.get(buildMaterialVO.getMaterialDocCode());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“材料费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && clfSet.contains(detailEntity.getFeeDetailId()))) {
                        detailEntity.setPreTypeAmount(ComputeUtil.safeAdd(detailEntity.getPreTypeAmount(), buildMaterialVO.getMaterialNum()));
                        detailEntity.setMny(ComputeUtil.safeAdd(detailEntity.getMny(), buildMaterialVO.getMaterialCostMny()));
                        detailEntity.setTaxMny(ComputeUtil.safeAdd(detailEntity.getTaxMny(), buildMaterialVO.getMaterialCostTaxMny()));
                    }
                } else if (detailEntity.getFeeDetailId().equals(qtclfId)) {//匹配不到档案且子表为“其他材料费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    if (StringUtils.isBlank(buildMaterialVO.getMaterialDocCode())) {
                        itemEntity.setCode(String.valueOf(num));
                        num++;
                    }else{
                        itemEntity.setCode(buildMaterialVO.getMaterialDocCode());
                    }
                    itemEntity.setName(buildMaterialVO.getMaterialDocName());
                    itemEntity.setUnitName(buildMaterialVO.getMaterialUnitName());
                    itemEntity.setTaxRate(buildMaterialVO.getMaterialCostRate());
                    itemEntity.setPrice(buildMaterialVO.getMaterialCostPrice());
                    itemEntity.setTaxPrice(buildMaterialVO.getMaterialCostTaxPrice());
                    itemEntity.setAmount(buildMaterialVO.getMaterialNum());
                    itemEntity.setMny(buildMaterialVO.getMaterialCostMny());
                    itemEntity.setTaxMny(buildMaterialVO.getMaterialCostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }


    /**
     * 转业费转换
     *
     * @param buildDutyVO
     * @param sourceDutyEntity
     * @param feeVO
     * @param restApi
     * @return
     */
    private DutyEntity dealProsubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        if(CollectionUtils.isEmpty(buildDutyVO.getProSubDetailList())) {
            return dutyEntity;
        }
        IShareProsubApi _restApi = (IShareProsubApi) restApi;
        //先判断费用模板有无关联专业分包费
        //专业分包费
        Long zyfbId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238540").equals(detailVO.getFeePropId())) {
                zyfbId = detailVO.getId();
            }
        }
        if (null == zyfbId) {
            throw new BusinessException("费用模板中未配置【专业费】的费用项，无法转换！");
        }
        //专业分包费下的主键集合
        Set<Long> zyfbSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(zyfbId))) {
                zyfbSet.add(detailVO.getId());
            }
        }
        //其他专业分包费
        Long qtzyfbId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238541").equals(detailVO.getFeePropId()) && zyfbSet.contains(detailVO.getId())) {
                qtzyfbId = detailVO.getId();
            }
        }
        if (null == qtzyfbId) {
            logger.error("费用模板中未配置【其他专业费】的费用项");
            qtzyfbId= -1L;
//            throw new BusinessException("费用模板中未配置【其他专业费】的费用项，无法转换！");
        }

        List<String> codeList = buildDutyVO.getProSubDetailList().stream()
                .filter(subVO -> null != subVO.getLeafFlag() && subVO.getLeafFlag() && StringUtils.isNotBlank(subVO.getProSubDocCode()))
                .map(BuildDutyProSubDetailVO::getProSubDocCode).collect(Collectors.toList());

        CommonResponse<List<ProsubCategoryVO>> proCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        //专业分包分类的内码map
        Map<Long, String> proCtyInnerCodeMap = new HashMap<>();
        if (proCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(proCtyResponse.getData())) {
            proCtyInnerCodeMap = proCtyResponse.getData().stream().collect(Collectors.toMap(ProsubCategoryVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        Map<String, ProsubItemVO> proSubMap = new HashMap<>();
        CommonResponse<List<ProsubItemVO>> proItemResponse = _restApi.queryItemListByCodes(codeList);
        if (proItemResponse.isSuccess() && CollectionUtils.isNotEmpty(proItemResponse.getData())) {
            proSubMap = proItemResponse.getData().stream().collect(Collectors.toMap(ProsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }

        for (BuildDutyProSubDetailVO subVO : buildDutyVO.getProSubDetailList()) {
            if (null == subVO.getLeafFlag() || !subVO.getLeafFlag() || null == subVO.getProSubNum()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(subVO.getProSubDocCode()) && proSubMap.containsKey(subVO.getProSubDocCode())) {
                    ProsubItemVO prosubItemVO = proSubMap.get(subVO.getProSubDocCode());
                    String innerCode = proCtyInnerCodeMap.get(prosubItemVO.getCategoryId());
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && zyfbSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(prosubItemVO.getTrawlingCode());
                        itemEntity.setName(prosubItemVO.getTrawlingName());
                        itemEntity.setPriceType(prosubItemVO.getPriceType());
                        itemEntity.setJobContent(prosubItemVO.getJobContent());
                        itemEntity.setUnitName(prosubItemVO.getUnitName());
                        itemEntity.setTaxRate(subVO.getProSubCostRate());
                        itemEntity.setPrice(subVO.getProSubCostPrice());
                        itemEntity.setTaxPrice(subVO.getProSubCostTaxPrice());
                        itemEntity.setAmount(subVO.getProSubNum());
                        itemEntity.setMny(subVO.getProSubCostMny());
                        itemEntity.setTaxMny(subVO.getProSubCostTaxMny());
                        itemEntity.setCategoryId(prosubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(prosubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.专业分包档案.getCode());
                        itemEntity.setDocId(prosubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }else if (detailEntity.getFeeDetailId().equals(qtzyfbId)) {//匹配不到档案且子表为“其他专业分包费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(subVO.getProSubDocCode());
                    itemEntity.setName(subVO.getProSubDocName());
                    itemEntity.setUnitName(subVO.getProSubUnitName());
                    itemEntity.setTaxRate(subVO.getProSubCostRate());
                    itemEntity.setPrice(subVO.getProSubCostPrice());
                    itemEntity.setTaxPrice(subVO.getProSubCostTaxPrice());
                    itemEntity.setAmount(subVO.getProSubNum());
                    itemEntity.setMny(subVO.getProSubCostMny());
                    itemEntity.setTaxMny(subVO.getProSubCostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }


    /**
     * 人工费转换
     *
     * @param buildDutyVO
     * @param sourceDutyEntity
     * @param feeVO
     * @param restApi
     * @return
     */
    private DutyEntity dealLasubData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        if(CollectionUtils.isEmpty(buildDutyVO.getLaborDetailList())) {
            return dutyEntity;
        }
        IShareLabsubApi _restApi = (IShareLabsubApi) restApi;
        //先判断费用模板有无关联人工费
        //人工费
        Long rgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238533").equals(detailVO.getFeePropId())) {
                rgfId = detailVO.getId();
            }
        }
        if (null == rgfId) {
            throw new BusinessException("费用模板中未配置【人工费】的费用项，无法转换！");
        }
        //人工费下的主键集合
        Set<Long> rgfSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(rgfId))) {
                rgfSet.add(detailVO.getId());
            }
        }
        //其他人工费
        Long qtrgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) && rgfSet.contains(detailVO.getId())) {
                qtrgfId = detailVO.getId();
            }
        }
        if (null == qtrgfId) {
            logger.error("费用模板中未配置【其他人工费】的费用项");
            qtrgfId = -1L;
//            throw new BusinessException("费用模板中未配置【其他人工费】的费用项，无法转换！");
        }

        List<String> codeList = buildDutyVO.getLaborDetailList().stream()
                .filter(rgcostVO -> null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag() && StringUtils.isNotBlank(rgcostVO.getLaborDocCode()))
                .map(BuildDutyLaborCostDetailVO::getLaborDocCode).collect(Collectors.toList());

        CommonResponse<List<LabsubCategoryVO>> labCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        //劳务分包分类的内码map
        Map<Long, String> labCtyInnerCodeMap = new HashMap<>();
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(labCtyResponse.getData())) {
            labCtyInnerCodeMap = labCtyResponse.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        Map<String, LabsubItemVO> labSubMap = new HashMap<>();
        CommonResponse<List<LabsubItemVO>> labItemResponse = _restApi.queryItemListByCodes(codeList);
        if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty(labItemResponse.getData())) {
            labSubMap = labItemResponse.getData().stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }

        for (BuildDutyLaborCostDetailVO rgcostVO : buildDutyVO.getLaborDetailList()) {
            if (null == rgcostVO.getLeafFlag() || !rgcostVO.getLeafFlag() || null == rgcostVO.getLaborNum()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(rgcostVO.getLaborDocCode()) && labSubMap.containsKey(rgcostVO.getLaborDocCode())) {
                    LabsubItemVO labsubItemVO = labSubMap.get(rgcostVO.getLaborDocCode());
                    String innerCode = labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“人工费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && rgfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(labsubItemVO.getTrawlingCode());
                        itemEntity.setName(labsubItemVO.getTrawlingName());
                        itemEntity.setPriceType(labsubItemVO.getPriceType());
                        itemEntity.setJobContent(labsubItemVO.getJobContent());
                        itemEntity.setUnitName(labsubItemVO.getUnitName());
                        itemEntity.setTaxRate(rgcostVO.getLaborCostRate());
                        itemEntity.setPrice(rgcostVO.getLaborCostPrice());
                        itemEntity.setTaxPrice(rgcostVO.getLaborCostTaxPrice());
                        itemEntity.setAmount(rgcostVO.getLaborNum());
                        itemEntity.setMny(rgcostVO.getLaborCostMny());
                        itemEntity.setTaxMny(rgcostVO.getLaborCostTaxMny());
                        itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.劳务分包档案.getCode());
                        itemEntity.setDocId(labsubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }else if (detailEntity.getFeeDetailId().equals(qtrgfId)) {//匹配不到档案且子表为“其他人工费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(rgcostVO.getLaborDocCode());
                    itemEntity.setName(rgcostVO.getLaborDocName());
                    itemEntity.setUnitName(rgcostVO.getLaborUnitName());
                    itemEntity.setTaxRate(rgcostVO.getLaborCostRate());
                    itemEntity.setPrice(rgcostVO.getLaborCostPrice());
                    itemEntity.setTaxPrice(rgcostVO.getLaborCostTaxPrice());
                    itemEntity.setAmount(rgcostVO.getLaborNum());
                    itemEntity.setMny(rgcostVO.getLaborCostMny());
                    itemEntity.setTaxMny(rgcostVO.getLaborCostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }



    /**
     * 特种设备费转换
     *
     * @param buildDutyVO
     * @param sourceDutyEntity
     * @param feeVO
     * @param restApi
     * @return
     */
    private DutyEntity dealSubEquipData(BuildDutyVO buildDutyVO, DutyEntity sourceDutyEntity, FeeVO feeVO, Object restApi) {
        DutyEntity dutyEntity = BeanMapper.map(sourceDutyEntity, DutyEntity.class);
        if(CollectionUtils.isEmpty(buildDutyVO.getLaborDetailList())) {
            return dutyEntity;
        }
        IShareLabsubApi _restApi = (IShareLabsubApi) restApi;
        //先判断费用模板有无关联人工费
        //人工费
        Long rgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("1932409448614203393").equals(detailVO.getFeePropId())) {
                rgfId = detailVO.getId();
            }
        }
        if (null == rgfId) {
            logger.error("********费用模板中未配置【特种设备费】的费用项，不进行转换！**********");
            return dutyEntity;
        }

        //人工费下的主键集合
        Set<Long> rgfSet = new HashSet<>();
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (detailVO.getInnerCode().contains(String.valueOf(rgfId))) {
                rgfSet.add(detailVO.getId());
            }
        }
        //其他人工费
        Long qtrgfId = null;
        for (FeeDetailVO detailVO : feeVO.getFeeDetailList()) {
            if (Long.valueOf("546645586985238534").equals(detailVO.getFeePropId()) && rgfSet.contains(detailVO.getId())) {
                qtrgfId = detailVO.getId();
            }
        }
        if (null == qtrgfId) {
            logger.error("费用模板中未配置【其他特种设备费】的费用项");
            qtrgfId = -1L;
        }

        List<String> codeList = buildDutyVO.getLaborDetailList().stream()
                .filter(rgcostVO -> null != rgcostVO.getLeafFlag() && rgcostVO.getLeafFlag() && StringUtils.isNotBlank(rgcostVO.getLaborDocCode()))
                .map(BuildDutyLaborCostDetailVO::getLaborDocCode).collect(Collectors.toList());

        CommonResponse<List<LabsubCategoryVO>> labCtyResponse = _restApi.queryCategoryListByIds(new ArrayList<>());
        //劳务分包分类的内码map
        Map<Long, String> labCtyInnerCodeMap = new HashMap<>();
        if (labCtyResponse.isSuccess() && CollectionUtils.isNotEmpty(labCtyResponse.getData())) {
            labCtyInnerCodeMap = labCtyResponse.getData().stream().collect(Collectors.toMap(LabsubCategoryVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key1));
        }

        Map<String, LabsubItemVO> labSubMap = new HashMap<>();
        CommonResponse<List<LabsubItemVO>> labItemResponse = _restApi.queryItemListByCodes(codeList);
        if (labItemResponse.isSuccess() && CollectionUtils.isNotEmpty(labItemResponse.getData())) {
            labSubMap = labItemResponse.getData().stream().collect(Collectors.toMap(LabsubItemVO::getTrawlingCode, Function.identity(), (key1, key2) -> key1));
        }

        for (BuildDutyLaborCostDetailVO rgcostVO : buildDutyVO.getLaborDetailList()) {
            if (null == rgcostVO.getLeafFlag() || !rgcostVO.getLeafFlag() || null == rgcostVO.getLaborNum()) {
                continue;
            }
            for (DutyDetailEntity detailEntity : dutyEntity.getDutyDetailList()) {
                if (!detailEntity.getLeafFlag()) {
                    continue;
                }
                //匹配到档案
                if (StringUtils.isNotBlank(rgcostVO.getLaborDocCode()) && labSubMap.containsKey(rgcostVO.getLaborDocCode())) {
                    LabsubItemVO labsubItemVO = labSubMap.get(rgcostVO.getLaborDocCode());
                    String innerCode = labCtyInnerCodeMap.get(labsubItemVO.getCategoryId());
                    //1.有分类主键说明是选分类添加 2.内码包含分类主键 3.是“人工费”下的
                    if (((null != detailEntity.getCategoryId() && innerCode.contains(String.valueOf(detailEntity.getCategoryId())))
                            || (null == detailEntity.getCategoryId() && TreeNodeBUtil.judgeContain(innerCode, detailEntity.getCategoryInnerCode()))
                            && rgfSet.contains(detailEntity.getFeeDetailId()))) {
                        List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                        DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                        itemEntity.setId(IdWorker.getId());
                        itemEntity.setCode(labsubItemVO.getTrawlingCode());
                        itemEntity.setName(labsubItemVO.getTrawlingName());
                        itemEntity.setPriceType(labsubItemVO.getPriceType());
                        itemEntity.setJobContent(labsubItemVO.getJobContent());
                        itemEntity.setUnitName(labsubItemVO.getUnitName());
                        itemEntity.setTaxRate(rgcostVO.getLaborCostRate());
                        itemEntity.setPrice(rgcostVO.getLaborCostPrice());
                        itemEntity.setTaxPrice(rgcostVO.getLaborCostTaxPrice());
                        itemEntity.setAmount(rgcostVO.getLaborNum());
                        itemEntity.setMny(rgcostVO.getLaborCostMny());
                        itemEntity.setTaxMny(rgcostVO.getLaborCostTaxMny());
                        itemEntity.setCategoryId(labsubItemVO.getCategoryId());
                        itemEntity.setCategoryInnerCode(innerCode);
                        itemEntity.setCategoryName(labsubItemVO.getCategoryName());
                        itemEntity.setDocType(DocTypeEnum.特种设备档案.getCode());
                        itemEntity.setDocId(labsubItemVO.getId());
                        itemList.add(itemEntity);
                        detailEntity.setDutyDetailItemList(itemList);
                    }
                }else if (detailEntity.getFeeDetailId().equals(qtrgfId)) {//匹配不到档案且子表为“其他人工费”
                    List<DutyDetailItemEntity> itemList = CollectionUtils.isNotEmpty(detailEntity.getDutyDetailItemList()) ? detailEntity.getDutyDetailItemList() : new ArrayList<>();
                    DutyDetailItemEntity itemEntity = new DutyDetailItemEntity();
                    itemEntity.setId(IdWorker.getId());
                    itemEntity.setCode(rgcostVO.getLaborDocCode());
                    itemEntity.setName(rgcostVO.getLaborDocName());
                    itemEntity.setUnitName(rgcostVO.getLaborUnitName());
                    itemEntity.setTaxRate(rgcostVO.getLaborCostRate());
                    itemEntity.setPrice(rgcostVO.getLaborCostPrice());
                    itemEntity.setTaxPrice(rgcostVO.getLaborCostTaxPrice());
                    itemEntity.setAmount(rgcostVO.getLaborNum());
                    itemEntity.setMny(rgcostVO.getLaborCostMny());
                    itemEntity.setTaxMny(rgcostVO.getLaborCostTaxMny());
                    itemEntity.setDocType(6);
                    itemList.add(itemEntity);
                    detailEntity.setDutyDetailItemList(itemList);
                }
            }
        }

        return dutyEntity;
    }
}
