package com.ejianc.business.zhht.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestContextHolder;


public class ThreadContextDecorator implements TaskDecorator {

	private Logger logger = LoggerFactory.getLogger(ThreadContextDecorator.class);

	private String baseHost;
	private boolean contextFlag; //是否必须有上下文

	public String getBaseHost() {
		return baseHost;
	}

	public void setBaseHost(String baseHost) {
		this.baseHost = baseHost;
	}

	public ThreadContextDecorator() {
	}

	public ThreadContextDecorator(String baseHost) {
		this(baseHost, true);
	}

	public ThreadContextDecorator(String baseHost, boolean contextFlag) {
		this.baseHost = baseHost;
		this.contextFlag = contextFlag;
	}

	public boolean isContextFlag() {
		return contextFlag;
	}

	public void setContextFlag(boolean contextFlag) {
		this.contextFlag = contextFlag;
	}

	@Override
	public Runnable decorate(Runnable runnable) {
		JSONObject userContext = getToken();

		StringBuilder authtoken = new StringBuilder();
		if(null == userContext) {
			if(contextFlag) {
				throw new BusinessException("初始化异步任务上下文失败");
			}
			logger.error("初始化异步任务上下文失败");
		} else {
			authtoken.append("userType=").append(userContext.get("userType"))
					.append(";userCode=").append(userContext.get("userCode"))
					.append(";orgId=").append(userContext.get("orgId"))
					.append(";tenantid=").append(userContext.get("tenantid"))
					.append(";token=").append(userContext.get("token"))
					.append(";u_logints=").append(userContext.get("u_logints"))
					.append(";u_usercode=").append(userContext.get("u_usercode"))
					.append(";userId=").append(userContext.get("userId"));
		}

		return () -> {
			try {
				if(authtoken.length() > 0) {
					InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
				}
				if(null != userContext) {
					InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
					InvocationInfoProxy.setUserid(userContext.getLong("userId"));
					InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
					InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
				}
				runnable.run();
			} finally {
				RequestContextHolder.resetRequestAttributes();
			}
		};
	}

	public JSONObject getToken() {
		if(null != baseHost) {
			String initContextUrl = baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
			if(null != InvocationInfoProxy.getUserid()) {
				initContextUrl = initContextUrl + "&userId="+ InvocationInfoProxy.getUserid().toString();
			}
			String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

			CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
			try {
				if(userContextResponse.isSuccess()) {
					return userContextResponse.getData().getJSONObject("userContext");
				}
			} catch (Exception e) {
				logger.error("初始化异步任务上下文异常：",e);
				return null;
			}
		}
		return null;
	}
}
