package com.ejianc.business.zhht.controller.api;

import com.ejianc.business.zhht.service.IBuildDutyService;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2024/12/13 16:55
 */
@RestController
@RequestMapping(value = "/api/buildDuty/")
public class BuildDutyApi {

    @Autowired
    private IBuildDutyService service;

    /**
     * 查询项目下的项目策划详情
     *
     * @return
     */
    @GetMapping(value = "queryBuildDutyByProjectId")
    CommonResponse<BuildDutyVO> queryBuildDutyByProjectId(@RequestParam(value = "projectId") Long projectId) {
        BuildDutyVO resp = service.getByProjectId(projectId);
        return CommonResponse.success(resp);
    }

}
