package com.ejianc.business.targetcost.service;

import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.targetcost.vo.DutyVO;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 目标责任成本
 *
 * @author generator
 *
 */
public interface IDutyService extends IBaseService<DutyEntity> {

    CommonResponse<DutyVO> saveOrUpdate(DutyVO dutyVO);

    DutyVO queryDetail(Long id, boolean hasChildren);

    /**
     * 查询修订详情
     * @param id
     * @return
     */
    DutyVO queryReviseDetail(Long id);

    void deleteList(List<DutyVO> vos);

    ParamsCheckVO checkParams(DutyVO dutyVO);

    List<ExecutionLinkVO> linkFeeScale(Long projectId, Long id);

    List<Map<String,Object>> queryDuty();

    Map<Long,BigDecimal> queryDoc(Long projectId);

    Map<Long,BigDecimal> querySumPreTypeAmount(Long projectId);

    List<ParamsCheckVO> checkParamCode(DutyVO dutyVO, BigDecimal incomeMny);

    List<ParamsCheckVO> checkParamCodeP(DutyVO dutyVO, BigDecimal incomeMny);

    List<ParamsCheckVO> checkParamCodeR(DutyVO dutyVO, BigDecimal incomeMny);

    List<ParamsCheckVO> checkWZ(DutyVO dutyVO);

    List<ParamsCheckVO> checkLW(DutyVO dutyVO);

    Map<Long, DutyDetailItemVO> queryDocDutyDetailItem(Long projectId, Integer docType);

    DutyVO gatherDuty(Long dutyId);

    /**
     * 导入推送
     * @param baseVO 导入单据VO，如无孙表，直接传selectById()方法返回结果就行
     * @param isEff 是否生效 生效传true， 弃审和保存传false
     * @param conversionType 导入类型标识，参见ConversionEnum
     * @return
     */
    CommonResponse<String> pushFromImport(BaseVO baseVO, Boolean isEff, String conversionType);

    /**
     * 导入删除
     * @param importId 导入单据Id
     * @param conversionType 导入类型标识，参见ConversionEnum
     * @return
     */
    CommonResponse<String> deleteFromImport(Long importId, String conversionType);

    Map<Long,BigDecimal> queryPriceByDocIds(Long projectId, Integer docType, Boolean isRent, List<Long> docIds);
    CommonResponse<Boolean> queryDutyByProjectId(Long projectId);

    void handleBill(Long buildDutyId, boolean isEff, String type, Long userId);

    CommonResponse<List<Long>> queryDutyByProjectIds(List<Long> projectIds);

    CommonResponse<List<BuildDutyVO>> buildQueryProjects(List<Long> projectIds);
}
