package com.ejianc.business.zhht.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目季度成本分析 
 * 
 * @author generator
 * 
 */
 @TableName("ejc_targetcost_project_season_analyse")
public class ProjectSeasonAnalyseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="construct_name")
    private String constructName; // 建设单位
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_area")
    private String projectArea; // 工程规模
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同总金额
    @TableField(value="memo")
    private String memo; // 成本分析情况总结
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="construct_id")
    private Long constructId; // 建设单位id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 成本分析开始日期
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 成本分析结束日期
    @TableField(value="sum_product_mny")
    private BigDecimal sumProductMny; // 实际完成产值   累计产值金额
    @TableField(value="sum_reply_mny")
    private BigDecimal sumReplyMny; // 业主批复产值
    @TableField(value="plan_cost_mny")
    private BigDecimal planCostMny; // 策划成本金额
    @TableField(value="actual_cost_mny")
    private BigDecimal actualCostMny; // 实际成本金额
    @TableField(value="sum_product_actual_sub")
    private BigDecimal sumProductActualSub; // 累计(产值-实际成本)
    @TableField(value="sum_receive_mny")
    private BigDecimal sumReceiveMny; // 累计收款金额
    @TableField(value="sum_pay_mny")
    private BigDecimal sumPayMny; // 累计付款金额
    @TableField(value="sum_receive_pay_sub")
    private BigDecimal sumReceivePaySub; // 累计(收款-付款)


    public Long getConstructId() {
        return constructId;
    }

    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectArea() {
        return projectArea;
    }

    public void setProjectArea(String projectArea) {
        this.projectArea = projectArea;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getSumProductMny() {
        return sumProductMny;
    }

    public void setSumProductMny(BigDecimal sumProductMny) {
        this.sumProductMny = sumProductMny;
    }
    public BigDecimal getSumReplyMny() {
        return sumReplyMny;
    }

    public void setSumReplyMny(BigDecimal sumReplyMny) {
        this.sumReplyMny = sumReplyMny;
    }
    public BigDecimal getPlanCostMny() {
        return planCostMny;
    }

    public void setPlanCostMny(BigDecimal planCostMny) {
        this.planCostMny = planCostMny;
    }
    public BigDecimal getActualCostMny() {
        return actualCostMny;
    }

    public void setActualCostMny(BigDecimal actualCostMny) {
        this.actualCostMny = actualCostMny;
    }

    public BigDecimal getSumProductActualSub() {
        return sumProductActualSub;
    }

    public void setSumProductActualSub(BigDecimal sumProductActualSub) {
        this.sumProductActualSub = sumProductActualSub;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumReceivePaySub() {
        return sumReceivePaySub;
    }

    public void setSumReceivePaySub(BigDecimal sumReceivePaySub) {
        this.sumReceivePaySub = sumReceivePaySub;
    }
    
}
