/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zhht.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.api.IConcreteCheckApi;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckDetailVO;
import com.ejianc.business.zhht.bean.ProjectMaterialEntity;
import com.ejianc.business.zhht.service.IProjectMaterialService;
import com.ejianc.business.zhht.vo.ProjectMaterialDetailVO;
import com.ejianc.business.zhht.vo.ProjectMaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectMaterial"})
public class ProjectMaterialController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROJECT_MATERIAL";
    @Autowired
    private IProjectMaterialService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IConcreteCheckApi concreteCheckApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectMaterialVO> saveOrUpdate(@RequestBody ProjectMaterialVO saveOrUpdateVO) {
        ProjectMaterialEntity entity = (ProjectMaterialEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectMaterialEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!this.service.checkPartOnly(entity.getProjectId(), entity.getPartId(), entity.getId()).booleanValue()) {
            throw new BusinessException("\u8be5\u65bd\u5de5\u90e8\u4f4d\u5df2\u5b58\u5728\u6750\u6599\u9884\u7b97\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectMaterialVO vo = (ProjectMaterialVO)BeanMapper.map((Object)((Object)entity), ProjectMaterialVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectMaterialVO> queryDetail(@RequestParam Long id, @RequestParam(value="queryActNum", defaultValue="false") boolean queryActNum) {
        ProjectMaterialEntity entity = (ProjectMaterialEntity)((Object)this.service.selectById(id));
        ProjectMaterialVO vo = (ProjectMaterialVO)BeanMapper.map((Object)((Object)entity), ProjectMaterialVO.class);
        ArrayList<ProjectMaterialDetailVO> allDetails = new ArrayList<ProjectMaterialDetailVO>();
        if (queryActNum) {
            CommonResponse detailResp = this.concreteCheckApi.getDetailListByPmId(id);
            if (!detailResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u6e05\u5355\u5b9e\u9645\u91cf\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)detailResp.getData()))) {
                List materialVOS = (List)detailResp.getData();
                HashMap<Long, ConcreteCheckDetailVO> materialMap = new HashMap<Long, ConcreteCheckDetailVO>();
                for (ConcreteCheckDetailVO checkDetail : materialVOS) {
                    if (!materialMap.containsKey(checkDetail.getMaterialId())) {
                        materialMap.put(checkDetail.getMaterialId(), checkDetail);
                        continue;
                    }
                    ((ConcreteCheckDetailVO)materialMap.get(checkDetail.getMaterialId())).setCheckNum(ComputeUtil.safeAdd((BigDecimal)checkDetail.getCheckNum(), (BigDecimal)((ConcreteCheckDetailVO)materialMap.get(checkDetail.getMaterialId())).getCheckNum()));
                }
                for (ProjectMaterialDetailVO detail : vo.getProjectMaterialDetailList()) {
                    if (null != detail.getMaterialDocId() && materialMap.containsKey(detail.getMaterialDocId())) {
                        detail.setActualNum(((ConcreteCheckDetailVO)materialMap.get(detail.getMaterialDocId())).getCheckNum());
                        materialMap.remove(detail.getMaterialDocId());
                    }
                    allDetails.add(detail);
                }
                if (!materialMap.isEmpty()) {
                    ProjectMaterialDetailVO tmp = null;
                    for (ConcreteCheckDetailVO checkDetailVO : materialMap.values()) {
                        tmp = new ProjectMaterialDetailVO();
                        tmp.setId(checkDetailVO.getId());
                        tmp.setMaterialCategoryId(checkDetailVO.getMaterialTypeId());
                        tmp.setMaterialCategoryName(checkDetailVO.getMaterialTypeName());
                        tmp.setMaterialDocId(checkDetailVO.getMaterialId());
                        tmp.setMaterialDocCode(checkDetailVO.getMaterialCode());
                        tmp.setMaterialDocName(checkDetailVO.getMaterialName());
                        tmp.setMaterialUnitId(checkDetailVO.getUnitId());
                        tmp.setMaterialUnitName(checkDetailVO.getUnit());
                        tmp.setMaterialDocSpec(checkDetailVO.getSpec());
                        tmp.setPlanNum(BigDecimal.ZERO);
                        tmp.setNum(BigDecimal.ZERO);
                        tmp.setActualNum(checkDetailVO.getCheckNum());
                        tmp.setDetailMemo("\u6765\u6e90\u4e8e\u76f4\u5165\u76f4\u51fa\u5355");
                        tmp.setPid(checkDetailVO.getCheckId());
                        allDetails.add(tmp);
                    }
                }
                vo.setProjectMaterialDetailList(allDetails);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkPartOnly"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkPartOnly(Long projectId, Long partId, Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.checkPartOnly(projectId, partId, id));
    }

    @RequestMapping(value={"/queryCostAnalyse"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryCostAnalyse(@RequestParam(value="projectId") Long projectId, @RequestParam(value="partId", required=false) Long partId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.queryCostAnalyse(projectId, partId));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectMaterialVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectMaterialVO projectMaterialVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectMaterialVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "constructName", "parentOrgName", "billCode", "partName", "employeeName", "sceneEngineerName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectMaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "constructName", "parentOrgName", "billCode", "partName", "employeeName", "sceneEngineerName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List volist = BeanMapper.mapList((Iterable)list, ProjectMaterialVO.class);
        volist.stream().forEach(item -> item.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", volist);
        ExcelExport.getInstance().exportWithTrans("ProjectMaterial-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectMaterialData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectMaterialVO>> refProjectMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"orgId")) {
            orgId = _con.getLong("orgId");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectMaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

