package com.ejianc.business.targetcost.controller.api;

import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/duty/")
public class DutyApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDutyService dutyService;

    /**
     * @Description
     */
    @PostMapping(value = "queryDuty")
    public CommonResponse<List<Map<String,Object>>> queryDuty() {
        return CommonResponse.success("查询数据成功！", dutyService.queryDuty());
    }

    @PostMapping(value = "queryDoc")
    public CommonResponse<Map<Long,BigDecimal>> queryDoc(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询数据成功！", dutyService.queryDoc(projectId));
    }

    @PostMapping(value = "querySumPreTypeAmount")
    public CommonResponse<Map<Long,BigDecimal>> querySumPreTypeAmount(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询数据成功！", dutyService.querySumPreTypeAmount(projectId));
    }

    @PostMapping(value = "/queryDocDutyDetailItem")
    public CommonResponse <Map<Long, DutyDetailItemVO>> queryDocDutyDetailItem(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "docType") Integer docType) {
        return CommonResponse.success("查询数据成功！", dutyService.queryDocDutyDetailItem(projectId,docType));
    }

    /**
     * 根据档案主键集合查询目标成本价
     *
     * @return
     */
    @GetMapping(value = "queryPriceByDocIds")
    public CommonResponse<Map<Long, BigDecimal>> queryPriceByDocIds(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "docType") Integer docType, @RequestParam(value = "docIds") List<Long> docIds){
        return CommonResponse.success("查询数据成功！", dutyService.queryPriceByDocIds(projectId, docType, false, docIds));
    }

    /**
     * 根据租赁档案主键集合查询目标成本价
     *
     * @return
     */
    @GetMapping(value = "queryPriceByRentDocIds")
    public CommonResponse<Map<Long, BigDecimal>> queryPriceByRentDocIds(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "docType") Integer docType,
                                                                     @RequestParam(value = "docIds") List<Long> docIds){
        return CommonResponse.success("查询数据成功！", dutyService.queryPriceByDocIds(projectId, docType, true, docIds));
    }
    /**
     * 查询当前项目是否存在目标责任成本
     *
     * @return
     */
    @GetMapping(value = "queryDutyByProjectId")
    public CommonResponse<Boolean> queryDutyByProjectId(@RequestParam(value = "projectId") Long projectId){
        return dutyService.queryDutyByProjectId(projectId);
    }


    /**
     * 查询项目是否存在目标责任成本
     *
     * @return
     */
    @PostMapping(value = "queryExtInfoByProjectIds")
    public CommonResponse<List<Long>> queryDutyByProjectIds(@RequestBody List<Long> projectIds){
        return dutyService.queryDutyByProjectIds(projectIds);
    }
    @RequestMapping(value = "buildQueryProjects", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<BuildDutyVO>> buildQueryProjects(@RequestBody List<Long> projectIds){
        return dutyService.buildQueryProjects(projectIds);
    }

}
