package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.DutyDetailItemEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.targetcost.mapper.DutyDetailMapper;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.service.IDutyDetailService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 目标责任成本明细
 *
 * @author generator
 *
 */
@Service("dutyDetailService")
public class DutyDetailServiceImpl extends BaseServiceImpl<DutyDetailMapper, DutyDetailEntity> implements IDutyDetailService{
    @Autowired
    private IFeeDetailService feeDetailService;

    @Override
    public List<DutyDetailEntity> findByDutyId(Long dutyId) {
        LambdaQueryWrapper<DutyDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyDetailEntity::getDutyId, dutyId);
        return list(queryWrapper);
    }

    @Override
    public List<DutyDetailEntity> queryParentId(Long dutyId, List<DutyDetailEntity> dutyDetailEntities) {
        //查询父级
        LambdaQueryWrapper<DutyDetailEntity> queryWrappers = new LambdaQueryWrapper<>();
        queryWrappers.eq(DutyDetailEntity::getDutyId, dutyId);
        queryWrappers.eq(DutyDetailEntity::getDr, 0);
        List<Long> parentId = new ArrayList<>();
        for(DutyDetailEntity dutyDetailEntity:dutyDetailEntities){
            if (!parentId.contains(dutyDetailEntity.getParentId())) {
                if(dutyDetailEntity.getParentId() != null ){
                    parentId.add(dutyDetailEntity.getParentId());
                }
            }
        }
        if(CollectionUtils.isNotEmpty(parentId)){
            queryWrappers.in(DutyDetailEntity::getId, parentId);
            List<DutyDetailEntity> dutyDetailEntityList = list(queryWrappers);
            return dutyDetailEntityList;
        }else{
            return null;
        }
    }

    @Override
    public List<DutyDetailEntity> queryDutyDetailParentId(Long dutyId, List<DutyDetailEntity> dataList) {
        //这里只找到第六级
        List<DutyDetailEntity> dutyDetailEntities =  this.queryParentId(dutyId,dataList);
        //查询数据不为空 就添加到列表中
        if(CollectionUtils.isNotEmpty(dutyDetailEntities)){
            for(DutyDetailEntity dutyDetailEntity :dutyDetailEntities){
                dataList.add(dutyDetailEntity);
            }
        }
        List<DutyDetailEntity> dutyDetailEntities1 = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dutyDetailEntities)){
            dutyDetailEntities1 = this.queryParentId(dutyId,dutyDetailEntities);
            if(CollectionUtils.isNotEmpty(dutyDetailEntities1)){
                for(DutyDetailEntity dutyDetailEntity :dutyDetailEntities1){
                    dataList.add(dutyDetailEntity);
                }
            }
        }
        List<DutyDetailEntity> dutyDetailEntities2 = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dutyDetailEntities1)) {
            dutyDetailEntities2 = this.queryParentId(dutyId, dutyDetailEntities1);
            if (CollectionUtils.isNotEmpty(dutyDetailEntities2)) {
                for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities2) {
                    dataList.add(dutyDetailEntity);
                }
            }
        }
        List<DutyDetailEntity> dutyDetailEntities3 = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dutyDetailEntities2)) {
            dutyDetailEntities3 = this.queryParentId(dutyId, dutyDetailEntities2);
            if (CollectionUtils.isNotEmpty(dutyDetailEntities3)) {
                for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities3) {
                    dataList.add(dutyDetailEntity);
                }
            }
        }
        List<DutyDetailEntity> dutyDetailEntities4 = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dutyDetailEntities3)) {
            dutyDetailEntities4 = this.queryParentId(dutyId, dutyDetailEntities3);
            if (CollectionUtils.isNotEmpty(dutyDetailEntities4)) {
                for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities4) {
                    dataList.add(dutyDetailEntity);
                }
            }
        }
        List<DutyDetailEntity> dutyDetailEntities5 = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dutyDetailEntities4)) {
            dutyDetailEntities5 = this.queryParentId(dutyId, dutyDetailEntities4);
            if (CollectionUtils.isNotEmpty(dutyDetailEntities5)) {
                for (DutyDetailEntity dutyDetailEntity : dutyDetailEntities5) {
                    dataList.add(dutyDetailEntity);
                }
            }
        }
        //lsit根据id去重
        List<DutyDetailEntity> newList = dataList.stream().collect(Collectors
                .collectingAndThen(
                        Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(DutyDetailEntity::getId))),
                        ArrayList::new));

        return newList;
    }

    @Override
    public int deleteByDutyIdPhy(Long dutyId) {
        return baseMapper.deleteByDutyIdPhy(dutyId);
    }

}
