package com.ejianc.business.zhht.utils;

import com.ejianc.framework.core.util.EnvironmentTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author CJ
 * @Description:
 * @date 2024/12/17 10:44
 */
@Configuration
public class TargetTaskPoolConfig {

    @Autowired
    private EnvironmentTools environmentTools;

    @Bean(name = "maContextCommonTask")
    public Executor maContextCommonTask() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        //核心线程池大小
        executor.setCorePoolSize(2);
        //最大线程数
        executor.setMaxPoolSize(8);
        //队列容量
        executor.setQueueCapacity(16);
        //活跃时间
        executor.setKeepAliveSeconds(60);
        executor.setTaskDecorator(new ThreadContextDecorator(environmentTools.getBaseHost()));
        //线程名字前缀
        executor.setThreadNamePrefix("commonTaskExecutor-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(name = "taCommonTask")
    public Executor commonTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        //核心线程池大小
        executor.setCorePoolSize(2);
        //最大线程数
        executor.setMaxPoolSize(8);
        //队列容量
        executor.setQueueCapacity(16);
        //活跃时间
        executor.setKeepAliveSeconds(60);
        //线程名字前缀
        executor.setThreadNamePrefix("commonTaskExecutor-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }
}
