package com.ejianc.business.costcheck.mapper;

import com.ejianc.business.costcheck.vo.ProjectCheckCollectDetailEntitVO;
import com.ejianc.business.costcheck.vo.ProjectCheckVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.costcheck.bean.ProjectCheckEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 项目检查表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectCheckMapper extends BaseCrudMapper<ProjectCheckEntity> {

//    @Select("SELECT pcheck.problem_description_staff,project.project_id,project.project_name,pcheck.id project_check_id,pcheck.major_project_id,pcheck.person_check_id,pcheck.person_check_name,pcheck.check_date,pcheck.grade_staff,pcheck.remark FROM `ejc_costcheck_major_project_detail` project\n" +
//            "            LEFT JOIN (select * from \n" +
//            "ejc_costcheck_project_check \n" +
//            "where dr = 0\n" +
//            "            and cite = 0\n" +
//            "            and bill_state in (1,3)\n" +
//            ")\n" +
//            "as pcheck\n" +
//            "            on pcheck.major_project_id = project.id\n" +
//            "            where project.dr = 0")
    @Select("SELECT\n" +
            "pcheck.problem_description_staff,\n" +
            "pcheck.project_id,\n" +
            "pcheck.project_name,\n" +
            "pcheck.id project_check_id,\n" +
            "pcheck.major_project_id,\n" +
            "pcheck.person_check_id,\n" +
            "pcheck.person_check_name,\n" +
            "pcheck.check_date,\n" +
            "pcheck.grade_staff,\n" +
            "pcheck.c_type_problem as c_type_problem_staff,\n" +
            "pcheck.c_type_problem_ids as c_type_problem_ids_staff,\n" +
            "pcheck.c_type_problem as c_type_problem_leader,\n" +
            "pcheck.c_type_problem_ids as c_type_problem_ids_leader,\n" +
            "pcheck.c_type_problem as c_type_problem_leadero,\n" +
            "pcheck.c_type_problem_ids as c_type_problem_ids_leadero,\n" +
            "pcheck.remark \n" +
            " FROM ejc_costcheck_project_check pcheck WHERE dr = 0 AND cite = 0 AND bill_state IN ( 1, 3 ) ")
    List<ProjectCheckCollectDetailEntitVO> getListByProjectId();

    @Select("SELECT count(*) num from ejc_costcheck_record\n" +
            "where dr = 0 and bill_state in (1,3) and cite = 0")
    Integer getTips();

    @Select("SELECT * from ejc_costcheck_project_check where id in (\n" +
            "SELECT MAX(id) id FROM `ejc_costcheck_project_check`\n" +
            "where project_id = #{projectId} and dr = 0 and bill_state in (1,3) \n" +
            ")")
    ProjectCheckVO getLastCheckByProjectId(Long projectId);
}
