package com.ejianc.business.costinspection.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 成本巡检整改通知单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costinspection_rectification_notice")
public class RectificationNoticeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="bill_code")
    private String billCode; // 通知单编号
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="tracking_id")
    private Long trackingId; // 跟踪单
    @TableField(value="tracking_code")
    private String trackingCode; // 跟踪单编号
    @TableField(value="inspection_time")
    private Date inspectionTime; // 巡检时间
    @TableField(value="rectification_leader_id")
    private Long rectificationLeaderId; // 整改负责人
    @TableField(value="rectification_leader")
    private String rectificationLeader; // 整改负责人名称
    @TableField(value="rectification_publisher_id")
    private Long rectificationPublisherId; // 整改单下发人
    @TableField(value="rectification_publisher_name")
    private String rectificationPublisherName; // 整改单下发人名称
    @TableField(value="rectification_notice_time")
    private Date rectificationNoticeTime; // 下发整改通知单时间
    @TableField(value="rectification_finish_time")
    private Date rectificationFinishTime; // 限时整改日期

    @TableField(exist=false)
    @SubEntity(serviceName="rectificationNoticeContentService")
    private List<RectificationNoticeContentEntity> rectificationNoticeContentList = new ArrayList<>(); // 巡检整改回复子表


    public List<RectificationNoticeContentEntity> getRectificationNoticeContentList() {
        return rectificationNoticeContentList;
    }

    public void setRectificationNoticeContentList(List<RectificationNoticeContentEntity> rectificationNoticeContentList) {
        this.rectificationNoticeContentList = rectificationNoticeContentList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getTrackingId() {
        return trackingId;
    }

    public void setTrackingId(Long trackingId) {
        this.trackingId = trackingId;
    }
    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }
    public Long getRectificationLeaderId() {
        return rectificationLeaderId;
    }

    public void setRectificationLeaderId(Long rectificationLeaderId) {
        this.rectificationLeaderId = rectificationLeaderId;
    }
    public String getRectificationLeader() {
        return rectificationLeader;
    }

    public void setRectificationLeader(String rectificationLeader) {
        this.rectificationLeader = rectificationLeader;
    }
    public Long getRectificationPublisherId() {
        return rectificationPublisherId;
    }

    public void setRectificationPublisherId(Long rectificationPublisherId) {
        this.rectificationPublisherId = rectificationPublisherId;
    }
    public String getRectificationPublisherName() {
        return rectificationPublisherName;
    }

    public void setRectificationPublisherName(String rectificationPublisherName) {
        this.rectificationPublisherName = rectificationPublisherName;
    }
    public Date getRectificationNoticeTime() {
        return rectificationNoticeTime;
    }

    public void setRectificationNoticeTime(Date rectificationNoticeTime) {
        this.rectificationNoticeTime = rectificationNoticeTime;
    }
    public Date getRectificationFinishTime() {
        return rectificationFinishTime;
    }

    public void setRectificationFinishTime(Date rectificationFinishTime) {
        this.rectificationFinishTime = rectificationFinishTime;
    }
    
}
